/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.AbstractNode;
import org.aika.Document;
import org.aika.Model;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.INeuron;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;
import org.aika.neuron.activation.Range;
import org.aika.training.PatternDiscovery;

public class AndNode
extends Node<AndNode, NodeActivation<AndNode>> {
    public SortedMap<Refinement, Provider<? extends Node>> parents = new TreeMap<Refinement, Provider<? extends Node>>();
    public boolean combinatorialExpensive = false;
    public int numCombExpParents = 0;

    public AndNode() {
    }

    public AndNode(Model m, int level, SortedMap<Refinement, Provider<? extends Node>> parents) {
        super(m, level);
        this.parents = parents;
    }

    private void init() {
        for (Map.Entry<Refinement, Provider<? extends Node>> me : this.parents.entrySet()) {
            Refinement ref = me.getKey();
            Node pn = me.getValue().get();
            pn.addAndChild(ref, this.provider);
            pn.setModified();
            if (this.level <= 2 || !((AndNode)pn).combinatorialExpensive) continue;
            ++this.numCombExpParents;
        }
        if (this.provider.model.getAndNodeCheck() != null) {
            this.combinatorialExpensive = this.provider.model.getAndNodeCheck().checkIfCombinatorialExpensive(this);
        }
    }

    @Override
    NodeActivation<AndNode> processActivation(Document doc, NodeActivation.Key<AndNode> ak, Collection<NodeActivation> inputActs) {
        if (inputActs.size() + this.numCombExpParents != this.level) {
            return null;
        }
        return super.processActivation(doc, ak, inputActs);
    }

    @Override
    public void propagate(NodeActivation act) {
        this.apply(act);
    }

    @Override
    public void cleanup() {
        if (!this.isRemoved && !this.isRequired()) {
            this.remove();
            for (Provider<? extends Node> p : this.parents.values()) {
                p.get().cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void apply(NodeActivation<AndNode> act) {
        if (this.andChildren != null) {
            for (NodeActivation<?> pAct : act.inputs.values()) {
                Object pn = pAct.key.node;
                try {
                    ((Node)pn).lock.acquireReadLock();
                    Refinement ref = ((Node)pn).reverseAndChildren.get(new Node.ReverseAndRefinement(((AndNode)act.key.node).provider, act.key.rid, pAct.key.rid));
                    if (ref == null) continue;
                    for (NodeActivation<AndNode> nodeActivation : pAct.outputs.values()) {
                        Refinement nRef;
                        Provider<AndNode> nlp;
                        Refinement secondRef;
                        if (act == nodeActivation || (secondRef = ((Node)pn).reverseAndChildren.get(new Node.ReverseAndRefinement(((Node)nodeActivation.key.node).provider, nodeActivation.key.rid, pAct.key.rid))) == null || (nlp = this.getAndChild(nRef = new Refinement(secondRef.rid, ref.getOffset(), secondRef.input))) == null) continue;
                        AndNode.addNextLevelActivation(act, nodeActivation, nlp);
                    }
                }
                finally {
                    ((Node)pn).lock.releaseReadLock();
                }
            }
        }
        OrNode.processCandidate(this, act, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discover(NodeActivation<AndNode> act, PatternDiscovery.Config config) {
        Document doc = act.doc;
        for (NodeActivation<?> pAct : act.inputs.values()) {
            Object pn = pAct.key.node;
            try {
                ((Node)pn).lock.acquireReadLock();
                Refinement ref = ((Node)pn).reverseAndChildren.get(new Node.ReverseAndRefinement(((AndNode)act.key.node).provider, act.key.rid, pAct.key.rid));
                for (NodeActivation<?> secondAct : pAct.outputs.values()) {
                    if (!(secondAct.key.node instanceof AndNode) || act == secondAct || !config.checkExpandable.evaluate(secondAct)) continue;
                    Refinement secondRef = ((Node)pn).reverseAndChildren.get(new Node.ReverseAndRefinement(((Node)secondAct.key.node).provider, secondAct.key.rid, pAct.key.rid));
                    Refinement nRef = new Refinement(secondRef.rid, ref.getOffset(), secondRef.input);
                    AndNode nln = AndNode.createNextLevelNode(doc.model, doc.threadId, doc, this, nRef, config);
                    if (nln == null) continue;
                    nln.isDiscovered = true;
                }
            }
            finally {
                ((Node)pn).lock.releaseReadLock();
            }
        }
    }

    @Override
    boolean contains(Refinement ref) {
        if (ref.rid == null || ref.rid >= 0) {
            boolean flag = false;
            this.lock.acquireReadLock();
            if (ref.rid == null || ref.rid > 0) {
                flag = this.parents.containsKey(ref);
            } else if (ref.rid == 0) {
                for (Refinement pRef : this.parents.keySet()) {
                    if (pRef.rid != null && pRef.rid > 0 || pRef.input != ref.input) continue;
                    flag = true;
                    break;
                }
            }
            this.lock.releaseReadLock();
            return flag;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndNode createNextLevelNode(Model m, int threadId, Document doc, Node n, Refinement ref, PatternDiscovery.Config config) {
        Provider<AndNode> pnln = n.getAndChild(ref);
        if (pnln != null) {
            return config != null ? null : pnln.get();
        }
        if (n.contains(ref)) {
            return null;
        }
        SortedMap<Refinement, Provider<? extends Node>> parents = AndNode.computeNextLevelParents(m, threadId, doc, n, ref, config);
        AndNode nln = null;
        if (parents != null) {
            TreeSet<Provider<? extends Node>> parentsForLocking = new TreeSet<Provider<? extends Node>>(parents.values());
            try {
                for (Provider<? extends Node> pn : parentsForLocking) {
                    pn.get().lock.acquireWriteLock();
                }
                if (n.andChildren == null || !n.andChildren.containsKey(ref)) {
                    nln = new AndNode(m, n.level + 1, parents);
                    if (config == null || config.checkValidPattern.evaluate(nln)) {
                        nln.init();
                        nln.postCreate(doc);
                    } else {
                        m.removeProvider(nln.provider);
                        nln = null;
                    }
                }
            }
            catch (Throwable throwable) {
                for (Provider<? extends Node> pn : parentsForLocking) {
                    pn.get().lock.releaseWriteLock();
                }
                throw throwable;
            }
            for (Provider<? extends Node> pn : parentsForLocking) {
                pn.get().lock.releaseWriteLock();
            }
        }
        return nln;
    }

    public static void addNextLevelActivation(NodeActivation<AndNode> act, NodeActivation<AndNode> secondAct, Provider<AndNode> pnlp) {
        Document doc = act.doc;
        AndNode nlp = pnlp.get(doc);
        if (act.repropagateV != null && act.repropagateV != nlp.markedCreated) {
            return;
        }
        NodeActivation.Key ak = act.key;
        Node.addActivation(doc, new NodeActivation.Key<AndNode>(nlp, Range.mergeRange(ak.range, secondAct.key.range), Utils.nullSafeMin(ak.rid, secondAct.key.rid)), AndNode.prepareInputActs(act, secondAct));
    }

    @Override
    public void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        super.changeNumberOfNeuronRefs(threadId, v, d);
        this.parents.values().forEach(n3 -> ((Node)n3.get()).changeNumberOfNeuronRefs(threadId, v, d));
    }

    public static Collection<NodeActivation<?>> prepareInputActs(NodeActivation<?> firstAct, NodeActivation<?> secondAct) {
        ArrayList inputActs = new ArrayList(2);
        inputActs.add(firstAct);
        inputActs.add(secondAct);
        return inputActs;
    }

    public static SortedMap<Refinement, Provider<? extends Node>> computeNextLevelParents(Model m, int threadId, Document doc, Node pa, Refinement ref, PatternDiscovery.Config config) {
        Collection<Refinement> refinements = pa.collectNodeAndRefinements(ref);
        long v = Model.visitedCounter.addAndGet(1L);
        TreeMap<Refinement, Provider<? extends Node>> parents = new TreeMap<Refinement, Provider<? extends Node>>();
        for (Refinement pRef : refinements) {
            TreeSet<Refinement> childInputs = new TreeSet<Refinement>(refinements);
            childInputs.remove(pRef);
            try {
                if (pRef.input.get().computeAndParents(m, threadId, doc, pRef.getRelativePosition(), childInputs, parents, config, v)) continue;
                return null;
            }
            catch (Node.ThreadState.RidOutOfRange e) {
                return null;
            }
        }
        return parents;
    }

    @Override
    Collection<Refinement> collectNodeAndRefinements(Refinement newRef) {
        ArrayList<Refinement> inputs = new ArrayList<Refinement>(this.parents.size() + 1);
        inputs.add(newRef);
        int numRidRefs = 0;
        for (Refinement ref : this.parents.keySet()) {
            if (ref.rid == null) continue;
            ++numRidRefs;
        }
        for (Refinement ref : this.parents.keySet()) {
            if (newRef.rid != null && newRef.rid != null && (newRef.rid < 0 || numRidRefs == 1)) {
                inputs.add(new Refinement(ref.getRelativePosition(), newRef.rid, ref.input));
                continue;
            }
            if (ref.rid != null && newRef.rid != null && ref.getOffset() < 0) {
                inputs.add(new Refinement(0, Math.min(-ref.getOffset().intValue(), newRef.getRelativePosition()), ref.input));
                continue;
            }
            inputs.add(ref);
        }
        return inputs;
    }

    @Override
    public void reprocessInputs(Document doc) {
        for (Provider<? extends Node> pp : this.parents.values()) {
            Node pn = pp.get();
            for (NodeActivation act : pn.getActivations(doc)) {
                act.repropagateV = this.markedCreated;
                ((AbstractNode)act.key.node).propagate((NodeActivation)act);
            }
        }
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, INeuron n) {
        double sum = n.biasSum;
        for (Refinement ref : this.parents.keySet()) {
            Synapse s = ref.getSynapse(offset, (Neuron)n.provider);
            sum += Math.abs(s.weight);
        }
        return sum;
    }

    @Override
    protected NodeActivation<AndNode> createActivation(Document doc, NodeActivation.Key ak) {
        return new NodeActivation<AndNode>(doc.activationIdCounter++, doc, ak);
    }

    @Override
    public void remove() {
        super.remove();
        for (Map.Entry<Refinement, Provider<? extends Node>> me : this.parents.entrySet()) {
            Node pn = me.getValue().get();
            pn.lock.acquireWriteLock();
            pn.removeAndChild(me.getKey());
            pn.setModified();
            pn.lock.releaseWriteLock();
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND[");
        boolean first = true;
        for (Refinement ref : this.parents.keySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(ref);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(65);
        super.write(out);
        out.writeInt(this.parents.size());
        for (Map.Entry<Refinement, Provider<? extends Node>> me : this.parents.entrySet()) {
            me.getKey().write(out);
            out.writeInt(me.getValue().id);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            Refinement ref = Refinement.read(in, m);
            Object pn = m.lookupNodeProvider(in.readInt());
            this.parents.put(ref, (Provider<? extends Node>)pn);
        }
    }

    public static class Refinement
    implements Comparable<Refinement> {
        public static Refinement MIN = new Refinement(null, null);
        public static Refinement MAX = new Refinement(null, null);
        public Integer rid;
        public Provider<InputNode> input;

        private Refinement() {
        }

        public Refinement(Integer rid, Provider<InputNode> input) {
            this.rid = rid;
            this.input = input;
        }

        public Refinement(Integer rid, Integer offset, Provider<InputNode> input) {
            this.rid = offset == null && rid != null ? Integer.valueOf(0) : (offset == null || rid == null ? null : Integer.valueOf(rid - offset));
            this.input = input;
        }

        public Integer getOffset() {
            return this.rid != null ? Integer.valueOf(Math.min(0, this.rid)) : null;
        }

        public Integer getRelativePosition() {
            return this.rid != null ? Integer.valueOf(Math.max(0, this.rid)) : null;
        }

        public Synapse getSynapse(Integer offset, Neuron n) {
            return this.input.get().getSynapse(Utils.nullSafeAdd(this.getRelativePosition(), false, offset, false), n);
        }

        public String toString() {
            return "(" + (this.rid != null ? this.rid + ":" : "") + this.input.get().logicToString() + ")";
        }

        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.rid != null);
            if (this.rid != null) {
                out.writeInt(this.rid);
            }
            out.writeInt(this.input.id);
        }

        public boolean readFields(DataInput in, Model m) throws IOException {
            if (in.readBoolean()) {
                this.rid = in.readInt();
            }
            this.input = m.lookupNodeProvider(in.readInt());
            return true;
        }

        public static Refinement read(DataInput in, Model m) throws IOException {
            Refinement k = new Refinement();
            k.readFields(in, m);
            return k;
        }

        @Override
        public int compareTo(Refinement ref) {
            if (this == MIN || ref == MAX) {
                return -1;
            }
            if (this == MAX || ref == MIN) {
                return 1;
            }
            int r = this.input.compareTo(ref.input);
            if (r != 0) {
                return r;
            }
            return Utils.compareInteger(this.rid, ref.rid);
        }
    }
}

