/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.aika.Document;
import org.aika.Model;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.lattice.InputNode;
import org.aika.neuron.INeuron;
import org.aika.neuron.Neuron;
import org.aika.neuron.activation.Linker;
import org.aika.neuron.activation.Range;
import org.aika.training.MetaSynapse;

public class Synapse
implements Writable {
    public static final Comparator<Synapse> INPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.input.compareTo(s2.input);
        if (r != 0) {
            return r;
        }
        return s1.key.compareTo(s2.key);
    };
    public static final Comparator<Synapse> OUTPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.output.compareTo(s2.output);
        if (r != 0) {
            return r;
        }
        return s1.key.compareTo(s2.key);
    };
    public Neuron input;
    public Neuron output;
    public Provider<InputNode> inputNode;
    public Key key;
    public boolean inactive;
    public double weight;
    public double weightDelta;
    public double bias;
    public double biasDelta;
    public boolean toBeDeleted;
    public boolean isConjunction;
    public MetaSynapse meta;
    public int createdInDoc;
    public int committedInDoc;
    static Map<Key, Key> keyMap = new TreeMap<Key, Key>();

    public Synapse() {
    }

    public Synapse(Neuron input, Neuron output) {
        this.input = input;
        this.output = output;
    }

    public Synapse(Neuron input, Neuron output, Key key) {
        this(input, output);
        this.key = Synapse.lookupKey(key);
    }

    public void link() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        ((Neuron)in.provider).lock.acquireWriteLock();
        ((Neuron)in.provider).inMemoryOutputSynapses.put(this, this);
        int n = Linker.SortGroup.getSortGroup(this.key).ordinal();
        ((Neuron)in.provider).outputSortGroupCounts[n] = ((Neuron)in.provider).outputSortGroupCounts[n] + 1;
        ((Neuron)in.provider).lock.releaseWriteLock();
        ((Neuron)out.provider).lock.acquireWriteLock();
        ((Neuron)out.provider).inMemoryInputSynapses.put(this, this);
        int n2 = Linker.SortGroup.getSortGroup(this.key).ordinal();
        ((Neuron)out.provider).inputSortGroupCounts[n2] = ((Neuron)out.provider).inputSortGroupCounts[n2] + 1;
        ((Neuron)out.provider).lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        if (this.isConjunction(true, false)) {
            out.inputSynapses.put(this, this);
            this.isConjunction = true;
            out.setModified();
        } else {
            in.outputSynapses.put(this, this);
            this.isConjunction = false;
            in.setModified();
        }
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    public void relink() {
        boolean newIsConjunction = this.isConjunction(true, false);
        if (newIsConjunction != this.isConjunction) {
            INeuron in = (INeuron)this.input.get();
            INeuron out = (INeuron)this.output.get();
            boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
            (dir ? in : out).lock.acquireWriteLock();
            (dir ? out : in).lock.acquireWriteLock();
            if (newIsConjunction) {
                out.inputSynapses.put(this, this);
                this.isConjunction = true;
                out.setModified();
            } else {
                in.outputSynapses.put(this, this);
                this.isConjunction = false;
                in.setModified();
            }
            (dir ? in : out).lock.releaseWriteLock();
            (dir ? out : in).lock.releaseWriteLock();
        }
    }

    public void unlink() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        ((Neuron)in.provider).lock.acquireWriteLock();
        ((Neuron)in.provider).inMemoryOutputSynapses.remove(this);
        int n = Linker.SortGroup.getSortGroup(this.key).ordinal();
        ((Neuron)in.provider).outputSortGroupCounts[n] = ((Neuron)in.provider).outputSortGroupCounts[n] - 1;
        ((Neuron)in.provider).lock.releaseWriteLock();
        ((Neuron)out.provider).lock.acquireWriteLock();
        ((Neuron)out.provider).inMemoryInputSynapses.remove(this);
        int n2 = Linker.SortGroup.getSortGroup(this.key).ordinal();
        ((Neuron)out.provider).inputSortGroupCounts[n2] = ((Neuron)out.provider).inputSortGroupCounts[n2] - 1;
        ((Neuron)out.provider).lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    private void removeLinkInternal(INeuron in, INeuron out) {
        if (this.isConjunction(false, false)) {
            if (out.inputSynapses.remove(this) != null) {
                out.setModified();
            }
        } else if (in.outputSynapses.remove(this) != null) {
            in.setModified();
        }
    }

    public boolean exists() {
        if (((INeuron)this.input.get()).outputSynapses.containsKey(this)) {
            return true;
        }
        return ((INeuron)this.output.get()).inputSynapses.containsKey(this);
    }

    public boolean isConjunction(boolean v, boolean absolute) {
        INeuron out = (INeuron)this.output.get();
        return (v ? this.getNewWeight() : this.weight) + (absolute ? 0.0 : out.requiredSum) + (v ? out.getNewBiasSum() : out.biasSum) <= 0.0;
    }

    public void updateDelta(Document doc, double weightDelta, double biasDelta) {
        this.weightDelta += weightDelta;
        this.biasDelta += biasDelta;
        ((INeuron)this.output.get()).biasSumDelta += biasDelta;
        this.relink();
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public void update(Document doc, double weight, double bias) {
        this.weightDelta = weight - this.weight;
        double newBiasDelta = bias - this.bias;
        ((INeuron)this.output.get()).biasSumDelta += newBiasDelta - this.biasDelta;
        this.biasDelta = newBiasDelta;
        this.relink();
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public boolean isNegative() {
        return this.weight < 0.0;
    }

    public String toString() {
        return "S OW:" + this.weight + " NW:" + (this.weight + this.weightDelta) + " " + this.key + " " + this.input + "->" + this.output;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.input.id);
        out.writeInt(this.output.id);
        out.writeInt(this.inputNode.id);
        this.key.write(out);
        out.writeDouble(this.weight);
        out.writeDouble(this.bias);
        out.writeBoolean(this.isConjunction);
        out.writeBoolean(this.meta != null);
        if (this.meta != null) {
            this.meta.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.input = m.lookupNeuron(in.readInt());
        this.output = m.lookupNeuron(in.readInt());
        this.inputNode = m.lookupNodeProvider(in.readInt());
        this.key = Synapse.lookupKey(Key.read(in, m));
        this.weight = in.readDouble();
        this.bias = in.readDouble();
        this.isConjunction = in.readBoolean();
        if (in.readBoolean()) {
            this.meta = new MetaSynapse();
            this.meta.readFields(in, m);
        }
    }

    public static Synapse read(DataInput in, Model m) throws IOException {
        Synapse s = new Synapse();
        s.readFields(in, m);
        return s;
    }

    public static Key lookupKey(Key k) {
        if (k.minKey || k.maxKey) {
            return k;
        }
        Key rk = keyMap.get(k);
        if (rk == null) {
            keyMap.put(k, k);
            rk = k;
        }
        return rk;
    }

    public static Synapse createOrLookup(Document doc, Key synapseKey, Neuron inputNeuron, Neuron outputNeuron) {
        Provider<InputNode> inp = ((INeuron)inputNeuron.get()).outputNodes.get(synapseKey.createInputNodeKey());
        Synapse synapse = null;
        InputNode in = null;
        if (inp != null) {
            in = inp.get();
            synapse = in.getSynapse(synapseKey.relativeRid, outputNeuron);
        }
        if (synapse == null) {
            synapse = new Synapse(inputNeuron, outputNeuron, synapseKey);
            if (in == null) {
                in = InputNode.add(outputNeuron.model, synapseKey.createInputNodeKey(), (INeuron)synapse.input.get());
            }
            in.setSynapse(synapse);
            synapse.link();
            synapse.createdInDoc = doc.id;
        }
        return synapse;
    }

    public double getNewWeight() {
        return this.weight + this.weightDelta;
    }

    public double getNewBias() {
        return this.bias + this.biasDelta;
    }

    public static class Builder
    implements Comparable<Builder> {
        public boolean recurrent;
        public Neuron neuron;
        public double weight;
        public double bias;
        public Range.Relation rangeMatch = Range.Relation.NONE;
        public Range.Output rangeOutput = Range.Output.NONE;
        public Integer relativeRid;
        public Integer absoluteRid;

        public Builder setRecurrent(boolean recurrent) {
            this.recurrent = recurrent;
            return this;
        }

        public Builder setNeuron(Neuron neuron) {
            assert (neuron != null);
            this.neuron = neuron;
            return this;
        }

        public Builder setWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder setBias(double bias) {
            this.bias = bias;
            return this;
        }

        public Builder setAbsoluteRid(Integer absoluteRid) {
            this.absoluteRid = absoluteRid;
            return this;
        }

        public Builder setRelativeRid(Integer relativeRid) {
            this.relativeRid = relativeRid;
            return this;
        }

        public Builder setRangeMatch(Range.Relation rr) {
            this.rangeMatch = rr;
            return this;
        }

        public Builder setRangeMatch(Range.Operator beginToBegin, Range.Operator endToEnd) {
            this.rangeMatch = Range.Relation.create(beginToBegin, endToEnd);
            return this;
        }

        public Builder setRangeOutput(boolean ro) {
            this.rangeOutput = ro ? Range.Output.DIRECT : Range.Output.NONE;
            return this;
        }

        public Builder setRangeOutput(boolean begin, boolean end) {
            return this.setRangeOutput(begin ? Range.Mapping.BEGIN : Range.Mapping.NONE, end ? Range.Mapping.END : Range.Mapping.NONE);
        }

        public Builder setRangeOutput(Range.Output rangeOutput) {
            this.rangeOutput = rangeOutput;
            return this;
        }

        public Builder setRangeOutput(Range.Mapping begin, Range.Mapping end) {
            this.rangeOutput = Range.Output.create(begin, end);
            return this;
        }

        public Synapse getSynapse(Neuron outputNeuron) {
            Synapse s = new Synapse(this.neuron, outputNeuron, new Key(this.recurrent, this.relativeRid, this.absoluteRid, this.rangeMatch, this.rangeOutput));
            Synapse os = ((INeuron)outputNeuron.get()).inputSynapses.get(s);
            if (os != null) {
                return os;
            }
            os = ((INeuron)this.neuron.get()).outputSynapses.get(s);
            if (os != null) {
                return os;
            }
            return s;
        }

        @Override
        public int compareTo(Builder in) {
            int r = this.neuron.compareTo(in.neuron);
            if (r != 0) {
                return r;
            }
            r = this.rangeMatch.compareTo(in.rangeMatch);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.relativeRid, in.relativeRid);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.absoluteRid, in.absoluteRid);
            if (r != 0) {
                return r;
            }
            r = this.rangeOutput.compareTo(in.rangeOutput);
            return r;
        }
    }

    public static class Key
    implements Comparable<Key>,
    Writable {
        public static final Key MIN_KEY = new Key(true, false);
        public static final Key MAX_KEY = new Key(false, true);
        public boolean isRecurrent;
        public Integer relativeRid;
        public Integer absoluteRid;
        public Range.Relation rangeMatch;
        public Range.Output rangeOutput;
        private boolean minKey = false;
        private boolean maxKey = false;

        public Key() {
        }

        public Key(boolean minKey, boolean maxKey) {
            this.minKey = minKey;
            this.maxKey = maxKey;
        }

        public Key(boolean minKey, boolean maxKey, Integer relativeRid, Range.Relation rangeMatch) {
            this.minKey = minKey;
            this.maxKey = maxKey;
            this.relativeRid = relativeRid;
            this.rangeMatch = rangeMatch;
        }

        public Key(boolean isRecurrent, Integer relativeRid, Integer absoluteRid, Range.Relation rangeMatch, Range.Output rangeOutput) {
            this.isRecurrent = isRecurrent;
            this.relativeRid = relativeRid;
            this.absoluteRid = absoluteRid;
            this.rangeMatch = rangeMatch;
            this.rangeOutput = rangeOutput;
        }

        public Key createInputNodeKey() {
            return this.relativeRid != null ? new Key(this.isRecurrent, 0, this.absoluteRid, this.rangeMatch, this.rangeOutput) : this;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.isRecurrent);
            out.writeBoolean(this.relativeRid != null);
            if (this.relativeRid != null) {
                out.writeByte(this.relativeRid);
            }
            out.writeBoolean(this.absoluteRid != null);
            if (this.absoluteRid != null) {
                out.writeByte(this.absoluteRid);
            }
            this.rangeMatch.write(out);
            this.rangeOutput.write(out);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.isRecurrent = in.readBoolean();
            if (in.readBoolean()) {
                this.relativeRid = in.readByte();
            }
            if (in.readBoolean()) {
                this.absoluteRid = in.readByte();
            }
            this.rangeMatch = Range.Relation.read(in, m);
            this.rangeOutput = Range.Output.read(in, m);
        }

        public static Key read(DataInput in, Model m) throws IOException {
            Key k = new Key();
            k.readFields(in, m);
            return k;
        }

        public String toString() {
            if (this.minKey) {
                return "MIN_KEY";
            }
            if (this.maxKey) {
                return "MAX_KEY";
            }
            return this.relativeRid + " B:" + (Object)((Object)this.rangeOutput.begin) + " E:" + (Object)((Object)this.rangeOutput.end);
        }

        @Override
        public int compareTo(Key k) {
            if (this == k) {
                return 0;
            }
            if (this.minKey && !k.minKey) {
                return -1;
            }
            if (!this.minKey && k.minKey) {
                return 1;
            }
            if (this.maxKey && !k.maxKey) {
                return 1;
            }
            if (!this.maxKey && k.maxKey) {
                return -1;
            }
            int r = Boolean.compare(this.isRecurrent, k.isRecurrent);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.relativeRid, k.relativeRid);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.absoluteRid, k.absoluteRid);
            if (r != 0) {
                return r;
            }
            r = this.rangeMatch.compareTo(k.rangeMatch);
            if (r != 0) {
                return r;
            }
            return this.rangeOutput.compareTo(k.rangeOutput);
        }
    }
}

