/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron.activation;

import org.aika.Utils;
import org.aika.neuron.activation.Activation;
import org.aika.neuron.activation.SearchNode;

public class Candidate
implements Comparable<Candidate> {
    public SearchNode currentSearchNode;
    public SearchNode.Decision cachedDecision = SearchNode.Decision.UNKNOWN;
    public SearchNode cachedSearchNode;
    public SearchNode bestChildNode;
    public Activation activation;
    public int[] debugCounts = new int[3];
    public int[] debugDecisionCounts = new int[3];
    public int[] debugComputed = new int[3];
    public int id;
    int sequence = 0;
    public boolean queued;

    public Candidate(Activation act, int id) {
        this.activation = act;
        this.id = id;
        act.candidate = this;
        this.sequence = act.getSequence();
    }

    public boolean isConflicting() {
        return this.activation.conflicts.hasConflicts();
    }

    public boolean checkDependenciesSatisfied(long v) {
        for (Activation.SynapseActivation sa : this.activation.neuronInputs) {
            if (sa.input.markedHasCandidate == v || sa.synapse.key.isRecurrent || !(sa.input.upperBound > 0.0)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return " CID:" + this.id + " CONFLICT:" + this.isConflicting() + " LIMITED:" + this.debugCounts[SearchNode.DebugState.LIMITED.ordinal()] + " CACHED:" + this.debugCounts[SearchNode.DebugState.CACHED.ordinal()] + " EXPLORE:" + this.debugCounts[SearchNode.DebugState.EXPLORE.ordinal()] + " SELECTED:" + this.debugDecisionCounts[0] + " EXCLUDED:" + this.debugDecisionCounts[1] + " SIM-CACHED:" + this.debugComputed[0] + " SIM-COMPUTED:" + this.debugComputed[1] + " MODIFIED:" + this.debugComputed[2] + " ACT-ID:" + this.activation.id + " " + this.activation.key.range + " " + this.activation.getLabel();
    }

    @Override
    public int compareTo(Candidate c) {
        if (!this.isConflicting() && c.isConflicting()) {
            return -1;
        }
        if (this.isConflicting() && !c.isConflicting()) {
            return 1;
        }
        int r = Integer.compare(this.activation.key.range.begin, c.activation.key.range.begin);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.activation.key.range.end, c.activation.key.range.end);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.sequence, c.sequence);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.activation.key.rid, c.activation.key.rid);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, c.id);
    }
}

