/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron.activation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.aika.neuron.INeuron;
import org.aika.neuron.activation.Activation;
import org.aika.neuron.activation.Linker;

public class Conflicts {
    public SortedSet<Activation> primary = new TreeSet<Activation>();
    public Set<Activation> secondary = new TreeSet<Activation>();

    public static boolean isConflicting(Activation a, Activation b) {
        if (a.conflicts.secondary.contains(b)) {
            return true;
        }
        return b.conflicts.secondary.contains(a);
    }

    public static void linkConflicts(Activation act, long v, Linker.Direction dir) {
        for (Activation.SynapseActivation sa : dir == Linker.Direction.INPUT ? act.neuronInputs : act.neuronOutputs) {
            if (!sa.synapse.isNegative() || !sa.synapse.key.isRecurrent) continue;
            Activation oAct = dir == Linker.Direction.INPUT ? act : sa.output;
            Activation iAct = dir == Linker.Direction.INPUT ? sa.input : act;
            Conflicts.addConflict(oAct, iAct, v);
        }
    }

    private static void addConflict(Activation oAct, Activation iAct, long v) {
        if (oAct == iAct) {
            return;
        }
        if (iAct.getINeuron().type != INeuron.Type.INHIBITORY) {
            Conflicts.add(oAct, iAct);
        } else {
            for (Activation.SynapseActivation sa : iAct.neuronInputs) {
                if (sa.synapse.key.isRecurrent) continue;
                Conflicts.addConflict(oAct, sa.input, v);
            }
        }
    }

    public static Collection<Activation> getConflicting(Activation n) {
        ArrayList<Activation> conflicts = new ArrayList<Activation>();
        Conflicts.collectConflicting(conflicts, n);
        return conflicts;
    }

    private static void collectConflicting(Collection<Activation> results, Activation n) {
        results.addAll(n.conflicts.primary);
        results.addAll(n.conflicts.secondary);
    }

    public static void add(Activation primary, Activation secondary) {
        primary.conflicts.primary.add(secondary);
        secondary.conflicts.secondary.add(primary);
    }

    public boolean hasConflicts() {
        return !this.primary.isEmpty() || !this.secondary.isEmpty();
    }
}

