/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron.activation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.stream.Stream;
import org.aika.Document;
import org.aika.Utils;
import org.aika.lattice.NodeActivation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Neuron;
import org.aika.neuron.Synapse;
import org.aika.neuron.activation.Activation;
import org.aika.neuron.activation.Conflicts;
import org.aika.neuron.activation.Range;
import org.aika.neuron.activation.Selector;

public class Linker {
    public static void link(Activation act) {
        INeuron n = act.getINeuron();
        n.lock.acquireReadLock();
        ((Neuron)n.provider).lock.acquireReadLock();
        Linker.link(act, Direction.INPUT);
        Linker.link(act, Direction.OUTPUT);
        ((Neuron)n.provider).lock.releaseReadLock();
        n.lock.releaseReadLock();
        long v = act.doc.visitedCounter++;
        Conflicts.linkConflicts(act, v, Direction.INPUT);
        Conflicts.linkConflicts(act, v, Direction.OUTPUT);
    }

    private static void link(Activation act, Direction dir) {
        int[] sortGroupCounts;
        Neuron n = act.getNeuron();
        NavigableMap<Synapse, Synapse> syns = dir == Direction.INPUT ? n.inMemoryInputSynapses : n.inMemoryOutputSynapses;
        int[] nArray = sortGroupCounts = dir == Direction.INPUT ? n.inputSortGroupCounts : n.outputSortGroupCounts;
        if (syns.isEmpty()) {
            return;
        }
        if (syns.size() < 10) {
            Linker.linkOthers(act, dir, syns.values());
            return;
        }
        for (SortGroup sg : new SortGroup[]{SortGroup.RANGE_BEGIN, SortGroup.RANGE_END, SortGroup.RID_ZERO}) {
            if (sortGroupCounts[sg.ordinal()] <= 0) continue;
            Linker.link(act, dir, sg, syns);
        }
        NavigableMap<Synapse, Synapse> remainingSyns = syns.subMap(SortGroup.OTHERS.begin, true, SortGroup.OTHERS.end, true);
        if (remainingSyns.isEmpty()) {
            return;
        }
        if (act.doc.activatedNeurons.size() * 20 > sortGroupCounts[SortGroup.OTHERS.ordinal()]) {
            Linker.linkOthers(act, dir, remainingSyns.values());
        } else {
            Linker.linkOthers(act, dir, Linker.getActiveSynapses(act.doc, dir, remainingSyns));
        }
    }

    private static void link(Activation act, Direction dir, SortGroup sortGroup, NavigableMap<Synapse, Synapse> syns) {
        assert (sortGroup.checkActivation(act.key));
        Selector.select(sortGroup, act).forEach(rAct -> {
            Activation oAct = dir == Direction.INPUT ? act : rAct;
            Activation iAct = dir == Direction.INPUT ? rAct : act;
            for (Synapse s : syns.subMap(new Synapse(iAct.getNeuron(), oAct.getNeuron(), sortGroup.begin.key), true, new Synapse(iAct.getNeuron(), oAct.getNeuron(), sortGroup.end.key), true).values()) {
                Synapse.Key sk = s.key;
                if (!rAct.filter(null, Linker.computeTargetRID(act, dir, sk), activation.key.range, dir == Direction.INPUT ? sk.rangeMatch.invert() : sk.rangeMatch)) continue;
                Activation.SynapseActivation sa = new Activation.SynapseActivation(s, iAct, oAct);
                iAct.addSynapseActivation(Direction.INPUT, sa);
                oAct.addSynapseActivation(Direction.OUTPUT, sa);
            }
        });
    }

    private static void linkOthers(Activation act, Direction dir, Collection<Synapse> syns) {
        Document doc = act.doc;
        for (Synapse s : syns) {
            INeuron.ThreadState th;
            Neuron p = dir == Direction.INPUT ? s.input : s.output;
            INeuron an = (INeuron)p.getIfNotSuspended();
            if (an == null || (th = an.getThreadState(doc.threadId, false)) == null || th.activations.isEmpty()) continue;
            Linker.linkActSyn(an, act, dir, s);
        }
    }

    private static void linkActSyn(INeuron n, Activation act, Direction dir, Synapse s) {
        Synapse.Key sk = s.key;
        Stream<Activation> tmp = Selector.select(act.doc, n, Linker.computeTargetRID(act, dir, sk), act.key.range, dir == Direction.INPUT ? sk.rangeMatch.invert() : sk.rangeMatch);
        tmp.forEach(rAct -> {
            Activation oAct = dir == Direction.INPUT ? act : rAct;
            Activation iAct = dir == Direction.INPUT ? rAct : act;
            Activation.SynapseActivation sa = new Activation.SynapseActivation(s, iAct, oAct);
            iAct.addSynapseActivation(Direction.INPUT, sa);
            oAct.addSynapseActivation(Direction.OUTPUT, sa);
        });
    }

    private static Integer computeTargetRID(Activation act, Direction dir, Synapse.Key sk) {
        switch (dir) {
            case INPUT: {
                return sk.absoluteRid != null ? sk.absoluteRid : Utils.nullSafeAdd(act.key.rid, false, sk.relativeRid, false);
            }
            case OUTPUT: {
                return Utils.nullSafeSub(act.key.rid, false, sk.relativeRid, false);
            }
        }
        return null;
    }

    private static Collection<Synapse> getActiveSynapses(Document doc, Direction dir, NavigableMap<Synapse, Synapse> syns) {
        ArrayList<Synapse> results = new ArrayList<Synapse>();
        Synapse lk = new Synapse(null, null, SortGroup.OTHERS.begin.key);
        Synapse uk = new Synapse(null, null, SortGroup.OTHERS.end.key);
        for (INeuron n : doc.activatedNeurons) {
            if (dir == Direction.INPUT) {
                lk.input = (Neuron)n.provider;
                uk.input = (Neuron)n.provider;
            } else {
                lk.output = (Neuron)n.provider;
                uk.output = (Neuron)n.provider;
            }
            for (Synapse s : syns.subMap(lk, true, uk, true).values()) {
                results.add(s);
            }
        }
        return results;
    }

    public static enum SortGroup {
        RANGE_BEGIN(new Synapse.Key(true, false, null, Range.Relation.BEGIN_EQUALS), new Synapse.Key(false, true, null, Range.Relation.BEGIN_EQUALS)),
        RANGE_END(new Synapse.Key(true, false, null, Range.Relation.END_EQUALS), new Synapse.Key(false, true, null, Range.Relation.END_EQUALS)),
        RID_ZERO(new Synapse.Key(true, false, 0, Range.Relation.NONE), new Synapse.Key(false, true, 0, Range.Relation.NONE)),
        OTHERS(new Synapse.Key(true, false, null, Range.Relation.NONE), new Synapse.Key(false, true, null, Range.Relation.NONE));

        Synapse begin;
        Synapse end;

        private SortGroup(Synapse.Key beginKey, Synapse.Key endKey) {
            this.begin = new Synapse(Neuron.MIN_NEURON, Neuron.MIN_NEURON, beginKey);
            this.end = new Synapse(Neuron.MAX_NEURON, Neuron.MAX_NEURON, endKey);
        }

        public static int compare(Synapse.Key ka, Synapse.Key kb) {
            return SortGroup.getSortGroup(ka).compareTo(SortGroup.getSortGroup(kb));
        }

        public static SortGroup getSortGroup(Synapse.Key k) {
            if (k.rangeMatch.beginToBegin == Range.Operator.EQUALS) {
                return RANGE_BEGIN;
            }
            if (k.rangeMatch.endToEnd == Range.Operator.EQUALS) {
                return RANGE_END;
            }
            if (k.relativeRid != null && k.relativeRid == 0) {
                return RID_ZERO;
            }
            return OTHERS;
        }

        public boolean checkActivation(NodeActivation.Key ak) {
            switch (this) {
                case RANGE_BEGIN: {
                    return ak.range.begin != Integer.MIN_VALUE;
                }
                case RANGE_END: {
                    return ak.range.end != Integer.MAX_VALUE;
                }
                case RID_ZERO: {
                    return ak.rid != null;
                }
            }
            return true;
        }
    }

    public static enum Direction {
        INPUT,
        OUTPUT;

    }
}

