/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron.activation;

import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Document;
import org.aika.Utils;
import org.aika.neuron.INeuron;
import org.aika.neuron.activation.Activation;
import org.aika.neuron.activation.Candidate;
import org.aika.neuron.activation.Conflicts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNode
implements Comparable<SearchNode> {
    private static final Logger log = LoggerFactory.getLogger(SearchNode.class);
    public static int MAX_SEARCH_STEPS = Integer.MAX_VALUE;
    public static boolean ENABLE_CACHING = true;
    public int id;
    SearchNode excludedParent;
    SearchNode selectedParent;
    long visited;
    public Candidate candidate;
    int level;
    DebugState debugState;
    Weight weightDelta;
    public Weight accumulatedWeight = Weight.ZERO;
    public Map<Activation, Activation.StateChange> modifiedActs = new TreeMap<Activation, Activation.StateChange>(Activation.ACTIVATION_ID_COMP);
    private Step step = Step.INIT;
    private boolean alreadySelected;
    private boolean alreadyExcluded;
    private SearchNode selectedChild = null;
    private SearchNode excludedChild = null;
    private Weight selectedWeight = Weight.ZERO;
    private Weight excludedWeight = Weight.ZERO;
    private long processVisited;
    private boolean bestPath;
    private Decision skip = Decision.UNKNOWN;

    public SearchNode(Document doc, SearchNode selParent, SearchNode exclParent, int level) {
        this.id = doc.searchNodeIdCounter++;
        this.level = level;
        this.visited = doc.visitedCounter++;
        this.selectedParent = selParent;
        this.excludedParent = exclParent;
        Candidate c = this.getParent() != null ? this.getParent().candidate : null;
        SearchNode csn = null;
        boolean modified = true;
        if (c != null) {
            c.currentSearchNode = this;
            csn = c.cachedSearchNode;
            if (csn == null || csn.getDecision() != this.getDecision()) {
                Activation act = c.activation;
                act.markDirty(this.visited);
                for (Activation.SynapseActivation sa : act.neuronOutputs) {
                    sa.output.markDirty(this.visited);
                }
            } else {
                modified = csn.isModified();
                if (modified) {
                    c.debugComputed[2] = c.debugComputed[2] + 1;
                }
            }
        }
        if (modified) {
            this.weightDelta = doc.vQueue.process(this);
            this.markDirty();
            if (c != null) {
                c.cachedSearchNode = this;
            }
        } else if (ENABLE_CACHING) {
            c.cachedSearchNode.changeState(Activation.Mode.NEW);
            this.weightDelta = c.cachedSearchNode.weightDelta;
            for (Activation act : c.cachedSearchNode.modifiedActs.keySet()) {
                act.saveOldState(this.modifiedActs, doc.visitedCounter++);
                act.saveNewState();
            }
        } else {
            this.weightDelta = doc.vQueue.process(this);
            if (Math.abs(this.weightDelta.w - csn.weightDelta.w) > 1.0E-5 || !this.compareNewState(csn)) {
                log.error("Cached search node activation do not match the newly computed results.");
                log.info("Computed results:");
                this.dumpDebugState();
                log.info("Cached results:");
                csn.dumpDebugState();
            }
        }
        if (c != null) {
            int[] nArray = c.debugComputed;
            int n = modified ? 1 : 0;
            nArray[n] = nArray[n] + 1;
        }
        if (this.getParent() != null) {
            this.accumulatedWeight = this.weightDelta.add(this.getParent().accumulatedWeight);
        }
    }

    private boolean isModified() {
        for (Activation.StateChange sc : this.modifiedActs.values()) {
            if (sc.getActivation().markedDirty > this.visited || sc.newState != sc.getActivation().decision) {
                return true;
            }
            if (!sc.newRounds.isActive()) continue;
            for (Activation.SynapseActivation sa : sc.getActivation().neuronOutputs) {
                if (sa.output.decision == Decision.UNKNOWN || sa.output.markedDirty <= this.visited) continue;
                return true;
            }
        }
        return false;
    }

    private void markDirty() {
        if (this.getParent() == null || this.getParent().candidate == null) {
            return;
        }
        SearchNode csn = this.getParent().candidate.cachedSearchNode;
        TreeSet<Activation> acts = new TreeSet<Activation>(Activation.ACTIVATION_ID_COMP);
        acts.addAll(this.modifiedActs.keySet());
        if (csn != null) {
            acts.addAll(csn.modifiedActs.keySet());
        }
        acts.forEach(act -> {
            Activation.StateChange scb;
            Activation.StateChange sca = this.modifiedActs.get(act);
            Activation.StateChange stateChange = scb = csn != null ? searchNode.modifiedActs.get(act) : null;
            if (sca == null || scb == null || !sca.newRounds.compare(scb.newRounds)) {
                for (Activation.SynapseActivation sa : act.neuronOutputs) {
                    sa.output.markDirty(this.visited);
                }
            }
        });
    }

    public boolean compareNewState(SearchNode cachedNode) {
        if (this.modifiedActs == null && cachedNode.modifiedActs == null) {
            return true;
        }
        if (this.modifiedActs == null || cachedNode.modifiedActs == null) {
            return false;
        }
        if (this.modifiedActs.size() != cachedNode.modifiedActs.size()) {
            return false;
        }
        for (Map.Entry<Activation, Activation.StateChange> me : this.modifiedActs.entrySet()) {
            Activation.StateChange sca = me.getValue();
            Activation.StateChange scb = cachedNode.modifiedActs.get(me.getKey());
            if (sca.newRounds.compare(scb.newRounds)) continue;
            return false;
        }
        return true;
    }

    public void dumpDebugState() {
        String weights = "";
        Decision decision = Decision.UNKNOWN;
        for (SearchNode n = this; n != null && n.level >= 0; n = n.getParent()) {
            log.info(n.level + " " + (Object)((Object)n.debugState) + " DECISION:" + (Object)((Object)decision) + " " + (n.candidate != null ? n.candidate.toString() : "") + " MOD-ACTS:" + n.modifiedActs.size() + weights);
            decision = n.getDecision();
            weights = " AW:" + Utils.round(n.accumulatedWeight.w) + " AN:" + Utils.round(n.accumulatedWeight.n) + " DW:" + Utils.round(n.weightDelta.w) + " DN:" + Utils.round(n.weightDelta.n);
        }
    }

    public static void search(Document doc, SearchNode root, long v, Long timeoutInMilliSeconds) throws TimeoutException {
        SearchNode sn = root;
        Weight returnWeight = null;
        long startTime = System.currentTimeMillis();
        do {
            if (sn.processVisited != v) {
                sn.step = Step.INIT;
                sn.processVisited = v;
            }
            switch (sn.step) {
                case INIT: {
                    if (sn.level >= doc.candidates.size()) {
                        if (timeoutInMilliSeconds != null && System.currentTimeMillis() > startTime + timeoutInMilliSeconds) {
                            throw new TimeoutException("Interpretation search took too long: " + (System.currentTimeMillis() - startTime) + "ms");
                        }
                        returnWeight = sn.processResult(doc);
                        sn.step = Step.FINAL;
                        sn = sn.getParent();
                        break;
                    }
                    sn.initStep(doc);
                    sn.step = Step.PREPARE_SELECT;
                    break;
                }
                case PREPARE_SELECT: {
                    sn.step = sn.prepareSelectStep(doc) ? Step.SELECT : Step.PREPARE_EXCLUDE;
                    break;
                }
                case SELECT: {
                    sn.step = Step.POST_SELECT;
                    sn = sn.selectedChild;
                    break;
                }
                case POST_SELECT: {
                    sn.selectedWeight = returnWeight;
                    sn.postReturn(sn.selectedChild);
                    sn.step = Step.PREPARE_EXCLUDE;
                    break;
                }
                case PREPARE_EXCLUDE: {
                    sn.step = sn.prepareExcludeStep(doc) ? Step.EXCLUDE : Step.FINAL;
                    break;
                }
                case EXCLUDE: {
                    sn.step = Step.POST_EXCLUDE;
                    sn = sn.excludedChild;
                    break;
                }
                case POST_EXCLUDE: {
                    sn.excludedWeight = returnWeight;
                    sn.postReturn(sn.excludedChild);
                    sn.step = Step.FINAL;
                    break;
                }
                case FINAL: {
                    returnWeight = sn.finalStep();
                    SearchNode pn = sn.getParent();
                    if (pn != null) {
                        pn.skip = sn.getDecision();
                    }
                    sn = pn;
                    break;
                }
            }
        } while (sn != null);
    }

    private void initStep(Document doc) {
        this.candidate = doc.candidates.get(this.level);
        boolean precondition = this.checkPrecondition();
        this.alreadySelected = precondition && !this.candidate.isConflicting() || this.candidate.activation.inputDecision == Decision.SELECTED;
        boolean bl = this.alreadyExcluded = !precondition || this.checkExcluded(this.candidate.activation) || this.candidate.activation.inputDecision == Decision.EXCLUDED;
        if (doc.searchStepCounter > MAX_SEARCH_STEPS) {
            this.dumpDebugState();
            throw new RuntimeException("Max search step exceeded.");
        }
        ++doc.searchStepCounter;
        this.storeDebugInfos();
    }

    private Decision getCachedDecision() {
        return !this.alreadyExcluded ? this.candidate.cachedDecision : Decision.UNKNOWN;
    }

    private boolean prepareSelectStep(Document doc) {
        if (this.alreadyExcluded || this.skip == Decision.SELECTED || this.getCachedDecision() == Decision.EXCLUDED) {
            return false;
        }
        this.candidate.activation.setDecision(Decision.SELECTED, this.visited);
        if (this.candidate.cachedDecision == Decision.UNKNOWN) {
            this.invalidateCachedDecisions();
        }
        this.selectedChild = new SearchNode(doc, this, this.excludedParent, this.level + 1);
        this.candidate.debugDecisionCounts[0] = this.candidate.debugDecisionCounts[0] + 1;
        return true;
    }

    private boolean prepareExcludeStep(Document doc) {
        if (this.alreadySelected || this.skip == Decision.EXCLUDED || this.getCachedDecision() == Decision.SELECTED) {
            return false;
        }
        this.candidate.activation.setDecision(Decision.EXCLUDED, this.visited);
        this.excludedChild = new SearchNode(doc, this.selectedParent, this, this.level + 1);
        this.candidate.debugDecisionCounts[1] = this.candidate.debugDecisionCounts[1] + 1;
        return true;
    }

    private void postReturn(SearchNode child) {
        child.changeState(Activation.Mode.OLD);
        this.candidate.activation.setDecision(Decision.UNKNOWN, this.visited);
        this.candidate.activation.rounds.reset();
    }

    private Weight finalStep() {
        SearchNode cn;
        Decision d;
        Decision cd = this.getCachedDecision();
        if (cd == Decision.UNKNOWN) {
            Decision decision = d = this.alreadySelected || !this.alreadyExcluded && this.selectedWeight.getNormWeight() >= this.excludedWeight.getNormWeight() ? Decision.SELECTED : Decision.EXCLUDED;
            if (!this.alreadyExcluded) {
                this.candidate.cachedDecision = d;
            }
        } else {
            d = cd;
        }
        SearchNode searchNode = cn = d == Decision.SELECTED ? this.selectedChild : this.excludedChild;
        if (cn.bestPath) {
            this.candidate.bestChildNode = cn;
            this.bestPath = true;
        }
        if (!this.bestPath || d != Decision.SELECTED) {
            this.selectedChild = null;
        }
        if (!this.bestPath || d != Decision.EXCLUDED) {
            this.excludedChild = null;
        }
        return d == Decision.SELECTED ? this.selectedWeight : this.excludedWeight;
    }

    private boolean checkPrecondition() {
        TreeSet<Activation.SynapseActivation> soin = this.candidate.activation.selectedNeuronInputs;
        return soin != null && !soin.isEmpty();
    }

    private void invalidateCachedDecisions() {
        for (Activation.SynapseActivation sa : this.candidate.activation.neuronOutputs) {
            if (sa.synapse.isNegative()) continue;
            SearchNode.invalidateCachedDecision(sa.output);
        }
    }

    public static void invalidateCachedDecision(Activation n) {
        Candidate pos = n.candidate;
        if (pos != null && pos.cachedDecision == Decision.EXCLUDED) {
            pos.cachedDecision = Decision.UNKNOWN;
        }
        for (Activation c : Conflicts.getConflicting(n)) {
            Candidate neg = c.candidate;
            if (neg == null || neg.cachedDecision != Decision.SELECTED) continue;
            neg.cachedDecision = Decision.UNKNOWN;
        }
    }

    private Weight processResult(Document doc) {
        double accNW = this.accumulatedWeight.getNormWeight();
        if (this.level > doc.selectedSearchNode.level || accNW > this.getSelectedAccumulatedWeight(doc)) {
            doc.selectedSearchNode = this;
            SearchNode.storeFinalState(this);
            this.bestPath = true;
        } else {
            this.bestPath = false;
        }
        return this.accumulatedWeight;
    }

    private static void storeFinalState(SearchNode sn) {
        while (sn != null) {
            if (sn.candidate != null) {
                Activation act = sn.candidate.activation;
                act.finalRounds = act.rounds.copy();
                act.finalDecision = act.decision;
            }
            sn = sn.getParent();
        }
    }

    private double getSelectedAccumulatedWeight(Document doc) {
        return doc.selectedSearchNode != null ? doc.selectedSearchNode.accumulatedWeight.getNormWeight() : -1.0;
    }

    private boolean checkExcluded(Activation ref) {
        for (Activation cn : Conflicts.getConflicting(ref)) {
            if (cn.decision != Decision.SELECTED) continue;
            return true;
        }
        return false;
    }

    public String pathToString() {
        return (this.selectedParent != null ? this.selectedParent.pathToString() : "") + " - " + this.toString();
    }

    public String toString() {
        return this.candidate.activation.id + " Decision:" + (Object)((Object)this.getDecision());
    }

    public void changeState(Activation.Mode m) {
        for (Activation.StateChange sc : this.modifiedActs.values()) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(SearchNode sn) {
        return Integer.compare(this.id, sn.id);
    }

    public SearchNode getParent() {
        return this.getDecision() == Decision.SELECTED ? this.selectedParent : this.excludedParent;
    }

    public Decision getDecision() {
        return this.excludedParent == null || this.selectedParent != null && this.selectedParent.id > this.excludedParent.id ? Decision.SELECTED : Decision.EXCLUDED;
    }

    private void storeDebugInfos() {
        this.debugState = this.alreadyExcluded || this.alreadySelected ? DebugState.LIMITED : (this.getCachedDecision() != Decision.UNKNOWN ? DebugState.CACHED : DebugState.EXPLORE);
        int n = this.debugState.ordinal();
        this.candidate.debugCounts[n] = this.candidate.debugCounts[n] + 1;
    }

    public static class TimeoutException
    extends RuntimeException {
        public TimeoutException(String message) {
            super(message);
        }
    }

    public static class Weight {
        public static final Weight ZERO = new Weight(0.0, 0.0);
        public final double w;
        public final double n;

        private Weight(double w, double n) {
            this.w = w;
            this.n = n;
        }

        public static Weight create(double w, double n) {
            assert (w >= 0.0 && n >= 0.0);
            if (w == 0.0 && n == 0.0) {
                return ZERO;
            }
            return new Weight(w, n);
        }

        public Weight add(Weight nw) {
            if (nw == null || nw == ZERO) {
                return this;
            }
            return new Weight(this.w + nw.w, this.n + nw.n);
        }

        public Weight sub(Weight nw) {
            if (nw == null || nw == ZERO) {
                return this;
            }
            return new Weight(this.w - nw.w, this.n - nw.n);
        }

        public double getNormWeight() {
            return this.n > 0.0 ? this.w / this.n : 0.0;
        }

        public boolean equals(Weight nw) {
            return Math.abs(this.w - nw.w) <= INeuron.WEIGHT_TOLERANCE && Math.abs(this.n - nw.n) <= INeuron.WEIGHT_TOLERANCE;
        }

        public String toString() {
            return "W:" + Utils.round(this.w) + " N:" + Utils.round(this.n);
        }
    }

    private static enum Step {
        INIT,
        PREPARE_SELECT,
        SELECT,
        POST_SELECT,
        PREPARE_EXCLUDE,
        EXCLUDE,
        POST_EXCLUDE,
        FINAL;

    }

    public static enum DebugState {
        CACHED,
        LIMITED,
        EXPLORE;

    }

    public static enum Decision {
        SELECTED('S'),
        EXCLUDED('E'),
        UNKNOWN('U');

        char s;

        private Decision(char s) {
            this.s = s;
        }
    }
}

