/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron.activation;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import org.aika.Document;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.neuron.INeuron;
import org.aika.neuron.activation.Activation;
import org.aika.neuron.activation.Linker;
import org.aika.neuron.activation.Range;

public class Selector {
    public static Activation get(Document doc, INeuron n, Integer rid, Range r, Range.Relation rr) {
        Stream<Activation> s = Selector.select(doc, n, rid, r, rr);
        return s.findFirst().orElse(null);
    }

    public static Activation get(Document doc, INeuron n, NodeActivation.Key ak) {
        return Selector.get(doc, n, ak.rid, ak.range, Range.Relation.EQUALS);
    }

    public static Stream<Activation> select(Document doc, INeuron n, Integer rid, Range r, Range.Relation rr) {
        INeuron.ThreadState th = n.getThreadState(doc.threadId, false);
        if (th == null) {
            return Stream.empty();
        }
        return Selector.select(th, n, rid, r, rr);
    }

    public static Stream<Activation> select(INeuron.ThreadState th, INeuron n, Integer rid, Range r, Range.Relation rr) {
        int s = th.activations.size();
        if (s == 0) {
            return Stream.empty();
        }
        Stream<Activation> results = s == 1 ? th.activations.values().stream() : (rid != null ? Selector.getActivationsByRid(th, n, rid).stream() : (rr != null ? Selector.getActivationsByRange(th, n, r, rr).stream() : th.activations.values().stream()));
        return results.filter(act -> act.filter((Node)iNeuron.node.get(), rid, r, rr));
    }

    private static Collection<Activation> getActivationsByRid(INeuron.ThreadState th, INeuron n, Integer rid) {
        Node node = n.node.get();
        NodeActivation.Key<Node> bk = new NodeActivation.Key<Node>(node, Range.MIN, rid);
        NodeActivation.Key<Node> ek = new NodeActivation.Key<Node>(node, Range.MAX, rid);
        if (th.activationsRid != null) {
            return th.activationsRid.subMap(bk, true, ek, true).values();
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection<Activation> getActivationsByRange(INeuron.ThreadState th, INeuron n, Range r, Range.Relation rr) {
        Node node = n.node.get();
        if (rr.beginToBegin == Range.Operator.EQUALS || rr.beginToEnd == Range.Operator.EQUALS || rr.endToBegin == Range.Operator.EQUALS || rr.endToEnd == Range.Operator.EQUALS) {
            return Selector.getActivationsByRangeEquals(th, n, r, rr);
        }
        if ((rr.beginToBegin.isGreaterThanOrGreaterThanEqual() || rr.beginToEnd.isGreaterThanOrGreaterThanEqual()) && r.begin <= r.end) {
            return Selector.getActivationsByRangeBeginGreaterThan(th, r, rr, node);
        }
        if ((rr.endToEnd.isGreaterThanOrGreaterThanEqual() || rr.endToBegin.isGreaterThanOrGreaterThanEqual()) && r.begin >= r.end) {
            return Selector.getActivationsByRangeEndGreaterThan(th, r, rr, node);
        }
        if ((rr.beginToBegin.isLessThanOrLessThanEqual() || rr.beginToEnd.isLessThanOrLessThanEqual()) && r.begin <= r.end) {
            return Selector.getActivationsByRangeBeginLessThanEqual(th, r, rr, node);
        }
        if ((rr.endToEnd.isLessThanOrLessThanEqual() || rr.endToBegin.isLessThanOrLessThanEqual()) && r.begin >= r.end) {
            return Selector.getActivationsByRangeEndLessThanEqual(th, r, rr, node);
        }
        return th.activations.values();
    }

    private static Collection<Activation> getActivationsByRangeBeginGreaterThan(INeuron.ThreadState th, Range r, Range.Relation rr, Node node) {
        boolean toInclusive;
        int toKey;
        boolean fromInclusive;
        int fromKey;
        if (rr.beginToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin;
            fromInclusive = rr.beginToBegin.includesEqual();
        } else {
            fromKey = r.end;
            fromInclusive = rr.beginToEnd.includesEqual();
        }
        if (rr.endToEnd.isLessThanOrLessThanEqual()) {
            toKey = r.end;
            toInclusive = rr.endToEnd.includesEqual();
        } else if (rr.endToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.endToBegin.includesEqual();
        } else {
            toKey = Integer.MAX_VALUE;
            toInclusive = true;
        }
        return th.activations.subMap(new NodeActivation.Key<Node>(node, new Range(fromKey, Integer.MIN_VALUE), null), fromInclusive, new NodeActivation.Key<Node>(node, new Range(toKey, Integer.MAX_VALUE), Integer.MAX_VALUE), toInclusive).values();
    }

    private static Collection<Activation> getActivationsByRangeEndGreaterThan(INeuron.ThreadState th, Range r, Range.Relation rr, Node node) {
        boolean toInclusive;
        int toKey;
        boolean fromInclusive;
        int fromKey;
        if (rr.endToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end;
            fromInclusive = rr.endToEnd.includesEqual();
        } else {
            fromKey = r.begin;
            fromInclusive = rr.endToBegin.includesEqual();
        }
        if (rr.beginToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.beginToBegin.includesEqual();
        } else if (rr.beginToEnd.isLessThanOrLessThanEqual()) {
            toKey = r.end;
            toInclusive = rr.beginToEnd.includesEqual();
        } else {
            toKey = Integer.MAX_VALUE;
            toInclusive = true;
        }
        return th.activationsEnd.subMap(new NodeActivation.Key<Node>(node, new Range(Integer.MIN_VALUE, fromKey), null), fromInclusive, new NodeActivation.Key<Node>(node, new Range(Integer.MAX_VALUE, toKey), Integer.MAX_VALUE), toInclusive).values();
    }

    private static Collection<Activation> getActivationsByRangeBeginLessThanEqual(INeuron.ThreadState th, Range r, Range.Relation rr, Node node) {
        boolean toInclusive;
        int toKey;
        boolean fromInclusive;
        int fromKey;
        if (rr.endToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end - th.maxLength;
            fromInclusive = rr.endToEnd.includesEqual();
        } else if (rr.endToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin - th.maxLength;
            fromInclusive = rr.endToBegin.includesEqual();
        } else {
            fromKey = Integer.MIN_VALUE;
            fromInclusive = true;
        }
        if (rr.beginToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.beginToBegin.includesEqual();
        } else {
            toKey = r.end;
            toInclusive = rr.beginToEnd.includesEqual();
        }
        if (fromKey > toKey) {
            return Collections.EMPTY_LIST;
        }
        return th.activations.subMap(new NodeActivation.Key<Node>(node, new Range(fromKey, Integer.MIN_VALUE), null), fromInclusive, new NodeActivation.Key<Node>(node, new Range(toKey, Integer.MAX_VALUE), null), toInclusive).values();
    }

    private static Collection<Activation> getActivationsByRangeEndLessThanEqual(INeuron.ThreadState th, Range r, Range.Relation rr, Node node) {
        boolean toInclusive;
        int toKey;
        boolean fromInclusive;
        int fromKey;
        if (rr.beginToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end - th.maxLength;
            fromInclusive = rr.beginToEnd.includesEqual();
        } else if (rr.beginToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin - th.maxLength;
            fromInclusive = rr.beginToBegin.includesEqual();
        } else {
            fromKey = Integer.MIN_VALUE;
            fromInclusive = true;
        }
        if (rr.endToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.endToBegin.includesEqual();
        } else {
            toKey = r.end;
            toInclusive = rr.endToEnd.includesEqual();
        }
        if (fromKey > toKey) {
            return Collections.EMPTY_LIST;
        }
        return th.activationsEnd.subMap(new NodeActivation.Key<Node>(node, new Range(Integer.MIN_VALUE, fromKey), null), fromInclusive, new NodeActivation.Key<Node>(node, new Range(Integer.MAX_VALUE, toKey), null), toInclusive).values();
    }

    public static Collection<Activation> getActivationsByRangeEquals(INeuron.ThreadState th, INeuron n, Range r, Range.Relation rr) {
        Node node = n.node.get();
        if (rr.beginToBegin == Range.Operator.EQUALS || rr.beginToEnd == Range.Operator.EQUALS) {
            int key = rr.beginToBegin == Range.Operator.EQUALS ? r.begin : r.end;
            return th.activations.subMap(new NodeActivation.Key<Node>(node, new Range(key, Integer.MIN_VALUE), null), true, new NodeActivation.Key<Node>(node, new Range(key, Integer.MAX_VALUE), Integer.MAX_VALUE), true).values();
        }
        if (rr.endToEnd == Range.Operator.EQUALS || rr.endToBegin == Range.Operator.EQUALS) {
            int key = rr.endToEnd == Range.Operator.EQUALS ? r.end : r.begin;
            return th.activationsEnd.subMap(new NodeActivation.Key<Node>(node, new Range(Integer.MIN_VALUE, key), null), true, new NodeActivation.Key<Node>(node, new Range(Integer.MAX_VALUE, key), Integer.MAX_VALUE), true).values();
        }
        throw new RuntimeException("Invalid Range Relation");
    }

    public static Collection<Activation> select(Linker.SortGroup sortGroup, Activation act) {
        switch (sortGroup) {
            case RANGE_BEGIN: {
                NodeActivation.Key<Node> bk = new NodeActivation.Key<Node>(Node.MIN_NODE, new Range(act.key.range.begin, Integer.MIN_VALUE), Integer.MIN_VALUE);
                NodeActivation.Key<Node> ek = new NodeActivation.Key<Node>(Node.MAX_NODE, new Range(act.key.range.begin, Integer.MAX_VALUE), Integer.MAX_VALUE);
                return act.doc.activationsByRangeBegin.subMap(bk, true, ek, true).values();
            }
            case RANGE_END: {
                NodeActivation.Key<Node> bk = new NodeActivation.Key<Node>(Node.MIN_NODE, new Range(Integer.MIN_VALUE, act.key.range.end), Integer.MIN_VALUE);
                NodeActivation.Key<Node> ek = new NodeActivation.Key<Node>(Node.MAX_NODE, new Range(Integer.MAX_VALUE, act.key.range.end), Integer.MAX_VALUE);
                return act.doc.activationsByRangeEnd.subMap(bk, true, ek, true).values();
            }
            case RID_ZERO: {
                NodeActivation.Key<Node> bk = new NodeActivation.Key<Node>(Node.MIN_NODE, Range.MIN, act.key.rid);
                NodeActivation.Key<Node> ek = new NodeActivation.Key<Node>(Node.MAX_NODE, Range.MAX, act.key.rid);
                return act.doc.activationsByRid.subMap(bk, true, ek, true).values();
            }
        }
        throw new RuntimeException("Unsupported Sort Group.");
    }
}

