/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import network.aika.Document;
import network.aika.Model;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.relation.Relation;
import network.aika.training.PatternDiscovery;

public class InputNode
extends Node<InputNode, InputActivation> {
    public Neuron inputNeuron;
    private long visitedDiscover;

    public InputNode() {
    }

    public InputNode(Model m) {
        super(m, 1);
    }

    public static InputNode add(Model m, INeuron input) {
        if (input.outputNode != null) {
            return input.outputNode.get();
        }
        InputNode in = new InputNode(m);
        if (input != null && in.inputNeuron == null) {
            in.inputNeuron = (Neuron)input.provider;
            input.outputNode = in.provider;
            input.setModified();
        }
        return in;
    }

    @Override
    public void addActivation(Activation inputAct) {
        if (inputAct.repropagateV != null && inputAct.repropagateV != this.markedCreated) {
            return;
        }
        InputActivation act = new InputActivation(inputAct.doc.activationIdCounter++, inputAct, this);
        this.addActivation(act);
    }

    @Override
    public void propagate(InputActivation act) {
        this.apply(act);
    }

    @Override
    public void reprocessInputs(Document doc) {
        ((INeuron)this.inputNeuron.get(doc)).getActivations(doc, false).forEach(act -> {
            act.repropagateV = this.markedCreated;
            if (act.upperBound > 0.0) {
                act.getINeuron().propagate((Activation)act);
            }
        });
    }

    @Override
    public AndNode.RefValue extend(int threadId, Document doc, AndNode.Refinement ref) {
        if (ref.relations.size() == 0) {
            return null;
        }
        Relation rel = ref.relations.get(0);
        if (rel == null) {
            return null;
        }
        AndNode.RefValue rv = this.getAndChild(ref);
        if (rv != null) {
            return rv;
        }
        TreeMap<AndNode.Refinement, AndNode.RefValue> nlParents = new TreeMap<AndNode.Refinement, AndNode.RefValue>();
        AndNode.Refinement mirrorRef = new AndNode.Refinement(new AndNode.RelationsMap(new Relation[]{rel.invert()}), this.provider);
        nlParents.put(mirrorRef, new AndNode.RefValue(new Integer[]{1}, 0, ref.input));
        rv = new AndNode.RefValue(new Integer[]{0}, 1, this.provider);
        nlParents.put(ref, rv);
        return AndNode.createAndNode(this.provider.model, doc, nlParents, this.level + 1) ? rv : null;
    }

    @Override
    void apply(InputActivation act) {
        try {
            this.lock.acquireReadLock();
            if (this.andChildren != null) {
                this.andChildren.forEach((ref, rv) -> {
                    InputNode in = ref.input.getIfNotSuspended();
                    if (in != null) {
                        InputNode.addNextLevelActivations(in, ref, rv.child.get(inputActivation.doc), act);
                    }
                });
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        OrNode.processCandidate(this, act, false);
    }

    private static void addNextLevelActivations(InputNode secondNode, AndNode.Refinement ref, AndNode nln, InputActivation act) {
        Document doc = act.doc;
        INeuron.ThreadState th = ((INeuron)secondNode.inputNeuron.get()).getThreadState(doc.threadId, false);
        if (th == null || th.activations.isEmpty()) {
            return;
        }
        Activation iAct = act.input.input;
        if (act.repropagateV != null && act.repropagateV != nln.markedCreated) {
            return;
        }
        ref.relations.get(0).getActivations((INeuron)secondNode.inputNeuron.get(doc), iAct).forEach(secondIAct -> {
            InputActivation secondAct = secondIAct.outputToInputNode.output;
            if (secondAct != null) {
                AndNode.AndActivation oAct = new AndNode.AndActivation(document.activationIdCounter++, doc, nln);
                for (Map.Entry<AndNode.Refinement, AndNode.RefValue> me : andNode.parents.entrySet()) {
                    boolean match = me.getKey().compareTo(ref) == 0;
                    oAct.link(me.getKey(), me.getValue(), match ? secondAct : act, match ? act : secondAct);
                }
                nln.addActivation(oAct);
            }
        });
    }

    @Override
    public void discover(InputActivation act, PatternDiscovery.Config config) {
        Model cfr_ignored_0 = this.provider.model;
        long v = Model.visitedCounter.addAndGet(1L);
        Document doc = act.doc;
        doc.getFinalActivations().forEach(secondNAct -> {
            InputActivation secondAct = secondNAct.outputToInputNode.output;
            if (act != secondAct) {
                List<Relation> relations = config.refinementFactory.create(act, 0, secondAct, 0);
                for (Relation r : relations) {
                    InputNode in = (InputNode)secondAct.node;
                    if (in.visitedDiscover == v || r == null) continue;
                    in.visitedDiscover = v;
                    AndNode.RelationsMap rm = new AndNode.RelationsMap(new Relation[]{r});
                    AndNode.Refinement ref = new AndNode.Refinement(rm, in.provider);
                    AndNode nln = this.extend((int)document.threadId, (Document)document, (AndNode.Refinement)ref).child.get();
                    if (nln == null) continue;
                    nln.isDiscovered = true;
                }
            }
        });
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I");
        sb.append("[");
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (this.inputNeuron.getLabel() != null) {
                sb.append(",");
                sb.append(this.inputNeuron.getLabel());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(73);
        super.write(out);
        out.writeBoolean(this.inputNeuron != null);
        if (this.inputNeuron != null) {
            out.writeInt(this.inputNeuron.id);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        if (in.readBoolean()) {
            this.inputNeuron = m.lookupNeuron(in.readInt());
        }
    }

    public static class Link {
        Activation input;
        InputActivation output;

        public Link(Activation iAct, InputActivation oAct) {
            this.input = iAct;
            this.output = oAct;
        }
    }

    public static class InputActivation
    extends NodeActivation<InputNode> {
        public Link input;

        public InputActivation(int id, Activation iAct, InputNode node) {
            super(id, iAct.doc, node);
            iAct.outputToInputNode = this.input = new Link(iAct, this);
        }

        @Override
        public Activation getInputActivation(int i) {
            assert (i == 0);
            return this.input.input;
        }
    }
}

