/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import network.aika.Document;
import network.aika.Utils;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Candidate;
import network.aika.neuron.activation.Linker;
import network.aika.neuron.activation.Range;
import network.aika.neuron.activation.SearchNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Activation
extends OrNode.OrActivation {
    public static final Comparator<Activation> ACTIVATION_ID_COMP = Comparator.comparingInt(act -> act.id);
    public static int MAX_SELF_REFERENCING_DEPTH = 5;
    private static final Logger log = LoggerFactory.getLogger(Activation.class);
    public Range range;
    public TreeSet<Link> selectedNeuronInputs = new TreeSet<Link>(Link.INPUT_COMP);
    public TreeMap<Link, Link> neuronInputs = new TreeMap(Link.INPUT_COMP);
    public TreeSet<Link> neuronOutputs = new TreeSet<Link>(Link.OUTPUT_COMP);
    public Integer sequence;
    public double upperBound;
    public double lowerBound;
    public Rounds rounds;
    public Rounds finalRounds = this.rounds = new Rounds();
    public boolean ubQueued = false;
    public boolean isQueued = false;
    public long queueId;
    public long markedHasCandidate;
    public long currentStateV;
    public StateChange currentStateChange;
    public long markedDirty;
    public long markedPredecessor;
    public double errorSignal;
    public Double targetValue;
    public Double inputValue;
    public SearchNode.Decision inputDecision = SearchNode.Decision.UNKNOWN;
    public SearchNode.Decision decision = SearchNode.Decision.UNKNOWN;
    public SearchNode.Decision finalDecision = SearchNode.Decision.UNKNOWN;
    public Candidate candidate;
    private long visitedState;
    public long markedAncestor;
    private List<Activation> conflicts;

    public Activation(int id, Document doc, OrNode n) {
        super(id, doc, n);
    }

    public Activation(int id, Document doc, Range r, OrNode n) {
        super(id, doc, n);
        this.range = r;
    }

    public void setTargetValue(Double targetValue) {
        this.targetValue = targetValue;
        if (targetValue != null) {
            this.doc.supervisedTraining.targetActivations.add(this);
        } else {
            this.doc.supervisedTraining.targetActivations.remove(this);
        }
    }

    public String getLabel() {
        return this.getINeuron().label;
    }

    public String getText() {
        return this.doc.getText(this.range);
    }

    public INeuron getINeuron() {
        return (INeuron)this.getNeuron().get(this.doc);
    }

    public Neuron getNeuron() {
        return ((OrNode)this.node).neuron;
    }

    public void addSynapseActivation(Linker.Direction dir, Link sa) {
        switch (dir) {
            case INPUT: {
                this.neuronOutputs.add(sa);
                break;
            }
            case OUTPUT: {
                if (sa.input.decision == SearchNode.Decision.SELECTED) {
                    this.selectedNeuronInputs.add(sa);
                }
                this.neuronInputs.put(sa, sa);
            }
        }
    }

    public double process(SearchNode sn, int round, long v) {
        double delta = 0.0;
        State s = this.inputValue != null ? new State(this.inputValue, 0.0, 0, 0.0) : this.computeValueAndWeight(round);
        if (round == 0 || !this.rounds.get(round).equalsWithWeights(s)) {
            this.saveOldState(sn.modifiedActs, v);
            State oldState = this.rounds.get(round);
            boolean propagate = this.rounds.set(round, s) && (oldState == null || !oldState.equals(s));
            this.saveNewState();
            if (propagate) {
                if (round > Document.MAX_ROUND) {
                    log.error("Error: Maximum number of rounds reached. The network might be oscillating.");
                    log.info(this.doc.activationsToString(false, true, true));
                    this.doc.dumpOscillatingActivations();
                    throw new RuntimeException("Maximum number of rounds reached. The network might be oscillating.");
                }
                this.doc.vQueue.propagateActivationValue(round, this);
            }
            if (round == 0) {
                this.doc.vQueue.add(1, this);
            }
            if (this.rounds.getLastRound() != null && round >= this.rounds.getLastRound()) {
                delta += s.weight - oldState.weight;
            }
        }
        return delta;
    }

    public State computeValueAndWeight(int round) {
        double newWeight;
        INeuron n = this.getINeuron();
        double net = n.biasSum;
        int fired = -1;
        long v = this.doc.visitedCounter++;
        this.markPredecessor(v);
        for (InputState is : this.getInputStates(round, v)) {
            Synapse s = is.l.synapse;
            Activation iAct = is.l.input;
            if (iAct == this) continue;
            double x = is.s.value * s.weight;
            if (s.distanceFunction != null) {
                x *= s.distanceFunction.f(iAct, this);
            }
            net += x;
            if (s.key.isRecurrent || s.isNegative() || !(net >= 0.0) || fired >= 0) continue;
            fired = iAct.rounds.get((int)round).fired + 1;
        }
        double currentActValue = n.activationFunction.f(net);
        double w = Math.min(-n.negRecSum, net);
        double d = newWeight = this.decision == SearchNode.Decision.SELECTED ? Math.max(0.0, w) : 0.0;
        if (this.decision == SearchNode.Decision.SELECTED || INeuron.ALLOW_WEAK_NEGATIVE_WEIGHTS) {
            return new State(currentActValue, net, -1, newWeight);
        }
        return new State(0.0, 0.0, -1, newWeight);
    }

    public void processBounds() {
        double oldUpperBound = this.upperBound;
        this.computeBounds();
        if (Math.abs(this.upperBound - oldUpperBound) > 0.01) {
            for (Link l : this.neuronOutputs) {
                this.doc.ubQueue.add(l.output);
            }
        }
        if (oldUpperBound <= 0.0 && this.upperBound > 0.0) {
            this.getINeuron().propagate(this);
        }
    }

    public void computeBounds() {
        INeuron n = this.getINeuron();
        double ub = n.biasSum + n.posRecSum;
        double lb = n.biasSum + n.posRecSum;
        long v = this.doc.visitedCounter++;
        this.markPredecessor(v);
        for (Link l : this.neuronInputs.values()) {
            Activation iAct;
            Synapse s = l.synapse;
            if (s.inactive || (iAct = l.input) == this) continue;
            double x = s.weight;
            if (s.distanceFunction != null) {
                x *= s.distanceFunction.f(iAct, this);
            }
            if (s.isNegative()) {
                if (!s.key.isRecurrent && !iAct.checkSelfReferencing(false, 0, v)) {
                    ub += iAct.lowerBound * x;
                }
                lb += x;
                continue;
            }
            ub += iAct.upperBound * x;
            lb += iAct.lowerBound * x;
        }
        this.upperBound = n.activationFunction.f(ub);
        this.lowerBound = n.activationFunction.f(lb);
    }

    private static State getInitialState(SearchNode.Decision c) {
        return new State(c == SearchNode.Decision.SELECTED ? 1.0 : 0.0, 0.0, 0, 0.0);
    }

    private List<InputState> getInputStates(int round, long v) {
        ArrayList<InputState> tmp = new ArrayList<InputState>();
        Synapse lastSynapse = null;
        InputState maxInputState = null;
        for (Link l : this.neuronInputs.values()) {
            if (l.synapse.inactive) continue;
            if (lastSynapse != null && lastSynapse != l.synapse) {
                tmp.add(maxInputState);
                maxInputState = null;
            }
            State s = l.input.getInputState(round, l.synapse, v);
            if (maxInputState == null || maxInputState.s.value < s.value) {
                maxInputState = new InputState(l, s);
            }
            lastSynapse = l.synapse;
        }
        if (maxInputState != null) {
            tmp.add(maxInputState);
        }
        return tmp;
    }

    private State getInputState(int round, Synapse s, long v) {
        State is = State.ZERO;
        if (s.key.isRecurrent) {
            if (!s.isNegative() || !this.checkSelfReferencing(true, 0, v)) {
                is = round == 0 ? Activation.getInitialState(this.decision) : this.rounds.get(round - 1);
            }
        } else {
            is = this.rounds.get(round);
        }
        return is;
    }

    public List<Link> getFinalInputActivationLinks() {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link l : this.neuronInputs.values()) {
            if (!l.input.isFinalActivation()) continue;
            results.add(l);
        }
        return results;
    }

    public List<Link> getFinalOutputActivationLinks() {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link l : this.neuronOutputs) {
            if (!l.output.isFinalActivation()) continue;
            results.add(l);
        }
        return results;
    }

    public Collection<Activation> getConflicts() {
        if (this.conflicts != null) {
            return this.conflicts;
        }
        long v = this.doc.visitedCounter++;
        this.markPredecessor(v);
        this.conflicts = new ArrayList<Activation>();
        for (Link l : this.neuronInputs.values()) {
            if (!l.synapse.isNegative() || !l.synapse.key.isRecurrent) continue;
            l.input.collectIncomingConflicts(this.conflicts, v);
        }
        this.collectOutgoingConflicts(this.conflicts, v);
        return this.conflicts;
    }

    private void collectIncomingConflicts(List<Activation> conflicts, long v) {
        if (this.markedPredecessor == v) {
            return;
        }
        if (this.getINeuron().type != INeuron.Type.INHIBITORY) {
            conflicts.add(this);
        } else {
            for (Link l : this.neuronInputs.values()) {
                if (l.synapse.isNegative() || l.synapse.key.isRecurrent) continue;
                l.input.collectIncomingConflicts(conflicts, v);
            }
        }
    }

    private void collectOutgoingConflicts(List<Activation> conflicts, long v) {
        if (this.markedPredecessor == v) {
            return;
        }
        for (Link l : this.neuronOutputs) {
            if (l.output.getINeuron().type != INeuron.Type.INHIBITORY) {
                if (!l.synapse.isNegative() || !l.synapse.key.isRecurrent) continue;
                conflicts.add(l.output);
                continue;
            }
            if (l.synapse.isNegative() || l.synapse.key.isRecurrent) continue;
            l.output.collectOutgoingConflicts(conflicts, v);
        }
    }

    public void adjustSelectedNeuronInputs(SearchNode.Decision d) {
        for (Link l : this.neuronOutputs) {
            if (d == SearchNode.Decision.SELECTED) {
                l.output.selectedNeuronInputs.add(l);
                continue;
            }
            l.output.selectedNeuronInputs.remove(l);
        }
    }

    public boolean checkSelfReferencing(boolean onlySelected, int depth, long v) {
        if (this.markedPredecessor == v) {
            return true;
        }
        if (depth > MAX_SELF_REFERENCING_DEPTH) {
            return false;
        }
        for (Link l : onlySelected ? this.selectedNeuronInputs : this.neuronInputs.values()) {
            if (l.synapse.key.isRecurrent || !l.input.checkSelfReferencing(onlySelected, depth + 1, v)) continue;
            return true;
        }
        return false;
    }

    public void setDecision(SearchNode.Decision newDecision, long v) {
        if (this.inputDecision != SearchNode.Decision.UNKNOWN && newDecision != this.inputDecision) {
            return;
        }
        if (newDecision == SearchNode.Decision.UNKNOWN && v != this.visitedState) {
            return;
        }
        if (this.decision == SearchNode.Decision.SELECTED != (newDecision == SearchNode.Decision.SELECTED)) {
            this.adjustSelectedNeuronInputs(newDecision);
        }
        this.decision = newDecision;
        this.visitedState = v;
    }

    public boolean isFinalActivation() {
        return this.getFinalState().value > 0.0;
    }

    public State getFinalState() {
        return this.finalRounds.getLast();
    }

    public Integer getSequence() {
        if (this.sequence != null) {
            return this.sequence;
        }
        this.sequence = 0;
        this.neuronInputs.values().stream().filter(sa -> !sa.synapse.key.isRecurrent).forEach(sa -> {
            this.sequence = Math.max(this.sequence, sa.input.getSequence() + 1);
        });
        return this.sequence;
    }

    public void markDirty(long v) {
        this.markedDirty = Math.max(this.markedDirty, v);
    }

    public void markPredecessor(long v) {
        this.markedPredecessor = v;
        for (Link l : this.neuronInputs.values()) {
            if (l.synapse.isNegative() || l.synapse.key.isRecurrent) continue;
            l.input.markPredecessor(v);
        }
    }

    public String toString() {
        return this.range + " - " + this.node + " -" + " UB:" + Utils.round(this.upperBound) + (this.inputValue != null ? " IV:" + Utils.round(this.inputValue) : "") + (this.targetValue != null ? " TV:" + Utils.round(this.targetValue) : "") + " V:" + Utils.round(this.rounds.getLast().value) + " FV:" + Utils.round(this.finalRounds.getLast().value);
    }

    public String toString(boolean finalOnly, boolean withTextSnippet, boolean withLogic) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id + " - ");
        sb.append((Object)((Object)(finalOnly ? this.finalDecision : this.decision)) + " - ");
        sb.append(this.range);
        if (withTextSnippet) {
            sb.append(" \"");
            if (((INeuron)((OrNode)this.node).neuron.get()).outputText != null) {
                sb.append(Utils.collapseText(((INeuron)((OrNode)this.node).neuron.get()).outputText, 7));
            } else {
                sb.append(Utils.collapseText(this.doc.getText(this.range), 7));
            }
            sb.append("\"");
        }
        sb.append(" (");
        boolean first = true;
        for (Link link : this.neuronInputs.values()) {
            if (!link.synapse.key.identity) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(link.input.id);
            first = false;
        }
        sb.append(") - ");
        sb.append(withLogic ? ((OrNode)this.node).toString() : ((OrNode)this.node).getNeuronLabel());
        sb.append(" - UB:");
        sb.append(Utils.round(this.upperBound));
        sb.append(" - ");
        if (finalOnly) {
            if (this.isFinalActivation()) {
                State fs = this.getFinalState();
                sb.append(fs);
            }
        } else {
            for (Map.Entry entry : this.rounds.rounds.entrySet()) {
                State s = (State)entry.getValue();
                sb.append("[R: " + entry.getKey() + " " + s + "]");
            }
        }
        if (this.inputValue != null) {
            sb.append(" - IV:" + Utils.round(this.inputValue));
        }
        if (this.targetValue != null) {
            sb.append(" - TV:" + Utils.round(this.targetValue));
        }
        return sb.toString();
    }

    public String linksToString() {
        StringBuilder sb = new StringBuilder();
        for (Link l : this.neuronInputs.values()) {
            sb.append("  " + l.input.getLabel() + "  W:" + l.synapse.weight + "\n");
        }
        return sb.toString();
    }

    public void saveOldState(Map<Activation, StateChange> changes, long v) {
        StateChange sc = this.currentStateChange;
        if (sc == null || this.currentStateV != v) {
            sc = new StateChange();
            sc.oldRounds = this.rounds.copy();
            this.currentStateChange = sc;
            this.currentStateV = v;
            if (changes != null) {
                changes.put(sc.getActivation(), sc);
            }
        }
    }

    public void saveNewState() {
        StateChange sc = this.currentStateChange;
        sc.newRounds = this.rounds.copy();
        sc.newState = this.decision;
    }

    public static class Builder {
        public Range range;
        public double value = 1.0;
        public Double targetValue;
        public int fired;

        public Builder setRange(int begin, int end) {
            this.range = new Range(begin, end);
            return this;
        }

        public Builder setRange(Range range) {
            this.range = range;
            return this;
        }

        public Builder setValue(double value) {
            this.value = value;
            return this;
        }

        public Builder setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public Builder setFired(int fired) {
            this.fired = fired;
            return this;
        }
    }

    public static class Link {
        public final Synapse synapse;
        public final Activation input;
        public final Activation output;
        public static Comparator<Link> INPUT_COMP = (sa1, sa2) -> {
            int r = Synapse.INPUT_SYNAPSE_COMP.compare(sa1.synapse, sa2.synapse);
            if (r != 0) {
                return r;
            }
            return Integer.compare(sa1.input.id, sa2.input.id);
        };
        public static Comparator<Link> OUTPUT_COMP = (sa1, sa2) -> {
            int r = Synapse.OUTPUT_SYNAPSE_COMP.compare(sa1.synapse, sa2.synapse);
            if (r != 0) {
                return r;
            }
            return Integer.compare(sa1.output.id, sa2.output.id);
        };

        public Link(Synapse s, Activation input, Activation output) {
            this.synapse = s;
            this.input = input;
            this.output = output;
        }

        public String toString() {
            return this.synapse + ": " + this.input + " --> " + this.output;
        }
    }

    public class StateChange {
        public Rounds oldRounds;
        public Rounds newRounds;
        public SearchNode.Decision newState;

        public void restoreState(Mode m) {
            Activation.this.rounds = (m == Mode.OLD ? this.oldRounds : this.newRounds).copy();
        }

        public Activation getActivation() {
            return Activation.this;
        }
    }

    public static enum Mode {
        OLD,
        NEW;

    }

    public static class State {
        public static final int DIR = 0;
        public static final int REC = 1;
        public final double value;
        public final double net;
        public final int fired;
        public final double weight;
        public static final State ZERO = new State(0.0, 0.0, -1, 0.0);

        public State(double value, double net, int fired, double weight) {
            assert (!Double.isNaN(value));
            this.value = value;
            this.net = net;
            this.fired = fired;
            this.weight = weight;
        }

        public boolean equals(State s) {
            return Math.abs(this.value - s.value) <= INeuron.WEIGHT_TOLERANCE;
        }

        public boolean equalsWithWeights(State s) {
            return this.equals(s) && Math.abs(this.weight - s.weight) <= INeuron.WEIGHT_TOLERANCE;
        }

        public String toString() {
            return "V:" + Utils.round(this.value) + " " + this.weight;
        }
    }

    public static class Rounds {
        private boolean[] isQueued = new boolean[3];
        public TreeMap<Integer, State> rounds = new TreeMap();

        public Rounds() {
            this.rounds.put(0, State.ZERO);
        }

        public boolean set(int r, State s) {
            State lr = this.get(r - 1);
            if (lr != null && lr.equalsWithWeights(s)) {
                State or = this.rounds.get(r);
                if (or != null) {
                    this.rounds.remove(r);
                    return !or.equalsWithWeights(s);
                }
                return false;
            }
            State or = this.rounds.put(r, s);
            Iterator<Map.Entry<Integer, State>> it = this.rounds.tailMap(r + 1).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, State> me = it.next();
                if (!me.getValue().equalsWithWeights(s)) continue;
                it.remove();
            }
            return or == null || !or.equalsWithWeights(s);
        }

        public State get(int r) {
            Map.Entry<Integer, State> me = this.rounds.floorEntry(r);
            return me != null ? me.getValue() : null;
        }

        public Rounds copy() {
            Rounds nr = new Rounds();
            nr.rounds.putAll(this.rounds);
            return nr;
        }

        public Integer getLastRound() {
            return !this.rounds.isEmpty() ? this.rounds.lastKey() : null;
        }

        public State getLast() {
            return !this.rounds.isEmpty() ? this.rounds.lastEntry().getValue() : State.ZERO;
        }

        public void setQueued(int r, boolean v) {
            if (r >= this.isQueued.length) {
                this.isQueued = Arrays.copyOf(this.isQueued, this.isQueued.length * 2);
            }
            this.isQueued[r] = v;
        }

        public boolean isQueued(int r) {
            return r < this.isQueued.length ? this.isQueued[r] : false;
        }

        public void reset() {
            this.rounds.clear();
            this.rounds.put(0, State.ZERO);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.rounds.forEach((r, s) -> sb.append(r + ":" + s.value + " "));
            return sb.toString();
        }

        public boolean compare(Rounds r) {
            if (this.rounds.size() != r.rounds.size()) {
                return false;
            }
            for (Map.Entry<Integer, State> me : this.rounds.entrySet()) {
                State sa = me.getValue();
                State sb = r.rounds.get(me.getKey());
                if (sb != null && !(Math.abs(sa.value - sb.value) > 1.0E-7)) continue;
                return false;
            }
            return true;
        }

        public boolean isActive() {
            return this.rounds.size() <= 1 && this.getLast().value > 0.0;
        }
    }

    private static class InputState {
        Link l;
        State s;

        public InputState(Link l, State s) {
            this.l = l;
            this.s = s;
        }
    }
}

