/*
 * Decompiled with CFR 0.152.
 */
package network.aika.training;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import network.aika.Document;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.relation.Relation;
import network.aika.training.MetaSynapse;
import network.aika.training.NeuronStatistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaNetwork {
    private static final Logger log = LoggerFactory.getLogger(MetaNetwork.class);

    public static void train(Document doc) {
        TreeMap<Activation, List<Target>> metaActivations = new TreeMap<Activation, List<Target>>();
        List inhibitoryNeurons = doc.finallyActivatedNeurons.stream().filter(n -> n.type == INeuron.Type.INHIBITORY).collect(Collectors.toList());
        for (INeuron iNeuron : inhibitoryNeurons) {
            for (Activation inhibAct : iNeuron.getActivations(doc, true)) {
                for (Activation.Link l : inhibAct.getFinalInputActivationLinks()) {
                    Activation metaNeuronAct;
                    Activation act = l.input;
                    Neuron targetNeuron = act.getNeuron();
                    ++doc.visitedCounter;
                    doc.createV = doc.createV;
                    boolean newNeuron = false;
                    if (((INeuron)targetNeuron.get()).type == INeuron.Type.META) {
                        newNeuron = true;
                        targetNeuron = doc.model.createNeuron(iNeuron.label.substring(2) + "-" + doc.getText(act.range));
                        INeuron.update(doc.threadId, doc, targetNeuron, iNeuron.bias, Collections.emptySet());
                    }
                    if ((metaNeuronAct = MetaNetwork.getMetaNeuronAct(inhibAct)) == null) continue;
                    ArrayList<Target> targets = (ArrayList<Target>)metaActivations.get(metaNeuronAct);
                    if (targets == null) {
                        targets = new ArrayList<Target>();
                        metaActivations.put(metaNeuronAct, targets);
                    }
                    targets.add(new Target(targetNeuron, newNeuron, (Neuron)iNeuron.provider));
                }
            }
        }
        for (Map.Entry entry : metaActivations.entrySet()) {
            for (Target t : (List)entry.getValue()) {
                MetaNetwork.transferMetaSynapses(doc, metaActivations, (Activation)entry.getKey(), t);
            }
        }
    }

    private static Activation getMetaNeuronAct(Activation inhibAct) {
        for (Activation.Link l : inhibAct.getFinalInputActivationLinks()) {
            if (l.input.getINeuron().type != INeuron.Type.META) continue;
            return l.input;
        }
        return null;
    }

    private static void transferMetaSynapses(Document doc, Map<Activation, List<Target>> metaActivations, Activation metaAct, Target t) {
        TreeSet<Synapse> inputSynapses = new TreeSet<Synapse>((s1, s2) -> Integer.compare(s1.id, s2.id));
        for (Activation.Link l : metaAct.getFinalInputActivationLinks()) {
            MetaSynapse inputMetaSynapse = l.synapse.meta;
            Synapse os = l.synapse;
            if (inputMetaSynapse == null || inputMetaSynapse.metaWeight == 0.0 && inputMetaSynapse.metaBias == 0.0) continue;
            Neuron ina = ((OrNode)l.input.node).neuron;
            List<Activation.Link> inputs = ((INeuron)ina.get()).type == INeuron.Type.INHIBITORY && inputMetaSynapse.metaWeight >= 0.0 ? l.input.getFinalInputActivationLinks() : Collections.singletonList(l);
            for (Activation.Link isa : inputs) {
                Neuron in = isa.input.getNeuron();
                if (((INeuron)in.get((Document)doc)).type == INeuron.Type.META) {
                    List<Target> inputTargets = metaActivations.get(isa.input);
                    if (inputTargets == null) continue;
                    for (Target it : metaActivations.get(isa.input)) {
                        MetaNetwork.createOrLookupSynapse(doc, t, inputSynapses, inputMetaSynapse, os, it.targetNeuron, metaAct);
                    }
                    continue;
                }
                MetaNetwork.createOrLookupSynapse(doc, t, inputSynapses, inputMetaSynapse, os, in, metaAct);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(MetaNetwork.showDelta((INeuron)t.targetNeuron.get(), inputSynapses));
        }
        INeuron.update(doc.threadId, doc, t.targetNeuron, t.isNewNeuron ? metaAct.getINeuron().metaBias : 0.0, inputSynapses);
        if (t.isNewNeuron) {
            Activation.Link inhibMetaLink = metaAct.getFinalOutputActivationLinks().get(0);
            Synapse.Key inhibSynKey = inhibMetaLink.synapse.key;
            MetaSynapse inhibSS = inhibMetaLink.synapse.meta;
            t.inhibNeuron.addSynapse(new Synapse.Builder().setNeuron(t.targetNeuron).setWeight(inhibSS.metaWeight).setBias(inhibSS.metaBias).addRelations(inhibMetaLink.synapse.relations).setRangeOutput(inhibSynKey.rangeOutput));
        }
        doc.propagate();
    }

    private static void createOrLookupSynapse(Document doc, Target t, Collection<Synapse> inputSynapses, MetaSynapse inputMetaSynapse, Synapse os, Neuron in, Activation metaAct) {
        Neuron metaN = metaAct.getNeuron();
        TreeMap<Integer, Relation> nRels = new TreeMap<Integer, Relation>();
        for (Map.Entry<Integer, Relation> me : os.relations.entrySet()) {
            Integer relId = me.getKey();
            if (relId >= 0) {
                Synapse s = metaN.getSynapseById(me.getKey());
                if (s.meta == null) continue;
                nRels.put(relId, me.getValue());
                continue;
            }
            nRels.put(relId, me.getValue());
        }
        Synapse ns = new Synapse(in, t.targetNeuron, os.id, os.key, nRels, os.distanceFunction);
        if (!ns.exists()) {
            ns.updateDelta(doc, inputMetaSynapse.metaWeight, inputMetaSynapse.metaBias);
            inputSynapses.add(ns);
        }
    }

    public static String showDelta(INeuron n, Collection<Synapse> synapses) {
        StringBuilder sb = new StringBuilder();
        sb.append("N: " + n.label + " ob:" + n.biasSum + " nb:" + (n.biasSum + n.biasSumDelta) + "\n");
        for (Synapse s : synapses) {
            if (s.weightDelta == 0.0) continue;
            Integer f = null;
            if (((INeuron)s.input.get()).statistic != null) {
                f = ((NeuronStatistic)((INeuron)s.input.get()).statistic).frequency;
            }
            sb.append("    S:" + s.input.getLabel() + " ow:" + s.weight + " nw:" + s.getNewWeight() + (f != null ? " f:" + f : "") + " " + (s.isConjunction(false, false) ? "CONJ" : "DISJ") + "\n");
        }
        return sb.toString();
    }

    public static Neuron initMetaNeuron(Neuron n, double bias, double metaBias, Synapse.Builder ... inputs) {
        ((INeuron)n.get()).metaBias = metaBias;
        return Neuron.init(n, bias, INeuron.Type.META, inputs);
    }

    private static class Target {
        Neuron targetNeuron;
        boolean isNewNeuron;
        Neuron inhibNeuron;

        public Target(Neuron targetNeuron, boolean isNewNeuron, Neuron inhibNeuron) {
            this.targetNeuron = targetNeuron;
            this.isNewNeuron = isNewNeuron;
            this.inhibNeuron = inhibNeuron;
        }
    }
}

