/*
 * Decompiled with CFR 0.152.
 */
package network.aika.training;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;

public class MetaSynapse
implements Writable {
    public double metaWeight;
    public double metaBias;

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.metaWeight);
        out.writeDouble(this.metaBias);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.metaWeight = in.readDouble();
        this.metaBias = in.readDouble();
    }

    public static class Builder
    extends Synapse.Builder {
        public double metaWeight;
        public double metaBias;

        public Builder setMetaWeight(double metaWeight) {
            this.metaWeight = metaWeight;
            return this;
        }

        public Builder setMetaBias(double metaBias) {
            this.metaBias = metaBias;
            return this;
        }

        @Override
        public Synapse getSynapse(Neuron outputNeuron) {
            Synapse s = super.getSynapse(outputNeuron);
            MetaSynapse ss = new MetaSynapse();
            ss.metaWeight = this.metaWeight;
            ss.metaBias = this.metaBias;
            s.meta = ss;
            return s;
        }
    }
}

