/*
 * Decompiled with CFR 0.152.
 */
package network.aika.training;

import java.util.Map;
import network.aika.DistanceFunction;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.relation.Relation;

public interface SynapseEvaluation {
    public Result evaluate(Synapse var1, Activation var2, Activation var3);

    public static class Result {
        public Synapse.Key synapseKey;
        public Map<Integer, Relation> relations;
        public DistanceFunction distanceFunction;
        public double significance;
        public DeleteMode deleteMode;

        public Result(Synapse.Key synapseKey, Map<Integer, Relation> relations, DistanceFunction distanceFunction, double significance, DeleteMode deleteMode) {
            this.synapseKey = synapseKey;
            this.relations = relations;
            this.distanceFunction = distanceFunction;
            this.significance = significance;
            this.deleteMode = deleteMode;
        }
    }

    public static enum DeleteMode {
        NONE,
        DELETE,
        DELETE_IF_SIGN_CHANGES,
        DELETE_NEGATIVES,
        DELETE_POSITIVES;


        public void checkIfDelete(Synapse s, boolean delete) {
            double ow = s.weight;
            double nw = s.getNewWeight();
            switch (this) {
                case DELETE: {
                    this.deleteOrInactivate(s, delete);
                    break;
                }
                case DELETE_IF_SIGN_CHANGES: {
                    if (nw != 0.0 && (ow == 0.0 || nw > 0.0 == ow > 0.0)) break;
                    this.deleteOrInactivate(s, delete);
                    break;
                }
                case DELETE_NEGATIVES: {
                    if (!(nw <= 0.0)) break;
                    this.deleteOrInactivate(s, delete);
                    break;
                }
                case DELETE_POSITIVES: {
                    if (!(nw >= 0.0)) break;
                    this.deleteOrInactivate(s, delete);
                }
            }
        }

        private void deleteOrInactivate(Synapse s, boolean delete) {
            if (delete) {
                s.toBeDeleted = true;
            } else {
                s.inactive = true;
            }
        }
    }
}

