/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import network.aika.AbstractNode;
import network.aika.ActivationFunction;
import network.aika.Converter;
import network.aika.Document;
import network.aika.Model;
import network.aika.PassiveInputFunction;
import network.aika.Provider;
import network.aika.ReadWriteLock;
import network.aika.Utils;
import network.aika.Writable;
import network.aika.lattice.InputNode;
import network.aika.lattice.OrNode;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Range;
import network.aika.neuron.activation.SearchNode;
import network.aika.neuron.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INeuron
extends AbstractNode<Neuron, Activation>
implements Comparable<INeuron> {
    public static boolean ALLOW_WEAK_NEGATIVE_WEIGHTS = false;
    private static final Logger log = LoggerFactory.getLogger(INeuron.class);
    public static double WEIGHT_TOLERANCE = 0.001;
    public static double TOLERANCE = 1.0E-6;
    public String label;
    public Type type;
    public LogicType logicType;
    public String outputText;
    public volatile double bias;
    public volatile double biasDelta;
    public volatile double biasSum;
    public volatile double biasSumDelta;
    public volatile double posDirSum;
    public volatile double negDirSum;
    public volatile double negRecSum;
    public volatile double posRecSum;
    public volatile double posPassiveSum;
    public volatile double requiredSum;
    public volatile double metaBias = 0.0;
    public volatile boolean isMeta = false;
    public volatile int numDisjunctiveSynapses = 0;
    public Writable statistic;
    public ActivationFunction activationFunction = ActivationFunction.RECTIFIED_SCALED_LOGISTIC_SIGMOID;
    public int numberOfInputSynapses = 0;
    public Map<Integer, Relation> outputRelations;
    public TreeMap<Synapse, Synapse> inputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
    public TreeMap<Synapse, Synapse> outputSynapses = new TreeMap(Synapse.OUTPUT_SYNAPSE_COMP);
    public TreeMap<Synapse, Synapse> passiveInputSynapses = null;
    public Provider<InputNode> outputNode;
    public Provider<OrNode> node;
    public ReadWriteLock lock = new ReadWriteLock();
    public PassiveInputFunction passiveInputFunction = null;
    public ThreadState[] threads;
    public static final Comparator<ActKey> BEGIN_COMP = (ak1, ak2) -> {
        int r = Range.BEGIN_COMP.compare(ak1.r, ak2.r);
        if (r != 0) {
            return r;
        }
        return Integer.compare(ak1.actId, ak2.actId);
    };
    public static final Comparator<ActKey> END_COMP = (ak1, ak2) -> {
        int r = Range.END_COMP.compare(ak1.r, ak2.r);
        if (r != 0) {
            return r;
        }
        return Integer.compare(ak1.actId, ak2.actId);
    };

    public ThreadState getThreadState(int threadId, boolean create) {
        ThreadState th = this.threads[threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[threadId] = th = new ThreadState();
        }
        th.lastUsed = ((Neuron)this.provider).model.docIdCounter.get();
        return th;
    }

    private INeuron() {
    }

    public INeuron(Model m) {
        this(m, null);
    }

    public INeuron(Model m, String label) {
        this(m, label, null);
    }

    public INeuron(Model m, String label, String outputText) {
        this.label = label;
        this.outputText = outputText;
        if (m.neuronStatisticFactory != null) {
            this.statistic = m.neuronStatisticFactory.createObject();
        }
        this.threads = new ThreadState[m.numberOfThreads];
        this.provider = new Neuron(m, this);
        OrNode node = new OrNode(m);
        node.neuron = (Neuron)this.provider;
        this.node = node.provider;
        this.setModified();
    }

    public Activation addInput(Document doc, Activation.Builder input) {
        Activation act;
        assert (input.range.begin <= input.range.end);
        Map.Entry<ActKey, Activation> me = this.getThreadState((int)doc.threadId, (boolean)true).activations.higherEntry(new ActKey(input.range, Integer.MIN_VALUE));
        if (me != null && me.getValue().range.equals(input.range)) {
            act = me.getValue();
        } else {
            act = new Activation(doc.activationIdCounter++, doc, this.node.get(doc));
            act.range = input.range;
        }
        this.register(act);
        Activation.State s = new Activation.State(input.value, input.value, 1.0, 0.0, 0.0, input.fired, 0.0);
        act.rounds.set(0, s);
        act.avgState = s;
        act.inputValue = input.value;
        act.upperBound = input.value;
        act.lowerBound = input.value;
        act.finalDecision = act.inputDecision = SearchNode.Decision.SELECTED;
        act.setDecision(act.inputDecision, doc.visitedCounter++);
        act.setTargetValue(input.targetValue);
        doc.inputNeuronActivations.add(act);
        doc.finallyActivatedNeurons.add(act.getINeuron());
        this.propagate(act);
        doc.propagate();
        return act;
    }

    public void remove() {
        this.clearActivations();
        for (Synapse s : this.inputSynapses.values()) {
            INeuron in = (INeuron)s.input.get();
            ((Neuron)in.provider).lock.acquireWriteLock();
            ((Neuron)in.provider).inMemoryOutputSynapses.remove(s);
            ((Neuron)in.provider).lock.releaseWriteLock();
        }
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            INeuron out = (INeuron)s.output.get();
            out.lock.acquireWriteLock();
            out.inputSynapses.remove(s);
            out.lock.releaseWriteLock();
        }
        ((Neuron)this.provider).lock.releaseReadLock();
    }

    @Override
    public void propagate(Activation act) {
        Document doc = act.doc;
        this.outputNode.get(doc).addActivation(act);
    }

    public Collection<Activation> getActivations(Document doc, boolean onlyFinal) {
        ThreadState th = this.getThreadState(doc.threadId, false);
        if (th == null) {
            return Collections.EMPTY_LIST;
        }
        return onlyFinal ? (Collection)th.activations.values().stream().filter(act -> act.isFinalActivation()).collect(Collectors.toList()) : th.activations.values();
    }

    public Activation getActivation(Document doc, Range r, boolean onlyFinal) {
        ThreadState th = this.getThreadState(doc.threadId, false);
        if (th == null) {
            return null;
        }
        for (Map.Entry<ActKey, Activation> me : th.activations.subMap(new ActKey(r, Integer.MIN_VALUE), new ActKey(r, Integer.MAX_VALUE)).entrySet()) {
            if (onlyFinal && !me.getValue().isFinalActivation()) continue;
            return me.getValue();
        }
        return null;
    }

    public void clearActivations() {
        for (int i = 0; i < ((Neuron)this.provider).model.numberOfThreads; ++i) {
            this.clearActivations(i);
        }
    }

    public void clearActivations(Document doc) {
        this.clearActivations(doc.threadId);
    }

    public void clearActivations(int threadId) {
        ThreadState th = this.getThreadState(threadId, false);
        if (th == null) {
            return;
        }
        th.activations.clear();
        if (th.activationsEnd != null) {
            th.activationsEnd.clear();
        }
    }

    @Override
    public int compareTo(INeuron n) {
        if (((Neuron)this.provider).id < ((Neuron)n.provider).id) {
            return -1;
        }
        if (((Neuron)this.provider).id > ((Neuron)n.provider).id) {
            return 1;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(true);
        out.writeBoolean(this.label != null);
        if (this.label != null) {
            out.writeUTF(this.label);
        }
        out.writeBoolean(this.type != null);
        if (this.type != null) {
            out.writeUTF(this.type.name());
        }
        out.writeBoolean(this.logicType != null);
        if (this.logicType != null) {
            out.writeUTF(this.logicType.name());
        }
        out.writeBoolean(this.outputText != null);
        if (this.outputText != null) {
            out.writeUTF(this.outputText);
        }
        out.writeBoolean(this.statistic != null);
        if (this.statistic != null) {
            this.statistic.write(out);
        }
        out.writeDouble(this.bias);
        out.writeDouble(this.biasSum);
        out.writeDouble(this.posDirSum);
        out.writeDouble(this.negDirSum);
        out.writeDouble(this.negRecSum);
        out.writeDouble(this.posRecSum);
        out.writeDouble(this.posPassiveSum);
        out.writeDouble(this.requiredSum);
        out.writeDouble(this.metaBias);
        out.writeBoolean(this.isMeta);
        out.writeInt(this.numDisjunctiveSynapses);
        out.writeUTF(this.activationFunction.name());
        out.writeInt(this.outputNode.id);
        out.writeBoolean(this.node != null);
        if (this.node != null) {
            out.writeInt(this.node.id);
        }
        out.writeInt(this.numberOfInputSynapses);
        for (Synapse synapse : this.inputSynapses.values()) {
            if (synapse.input == null) continue;
            out.writeBoolean(true);
            synapse.write(out);
        }
        out.writeBoolean(false);
        for (Synapse synapse : this.outputSynapses.values()) {
            if (synapse.output == null) continue;
            out.writeBoolean(true);
            synapse.write(out);
        }
        out.writeBoolean(false);
        if (this.outputRelations != null) {
            out.writeInt(this.outputRelations.size());
            for (Map.Entry entry : this.outputRelations.entrySet()) {
                out.writeInt((Integer)entry.getKey());
                ((Relation)entry.getValue()).write(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        Synapse syn;
        if (in.readBoolean()) {
            this.label = in.readUTF();
        }
        if (in.readBoolean()) {
            this.type = Type.valueOf(in.readUTF());
        }
        if (in.readBoolean()) {
            this.logicType = LogicType.valueOf(in.readUTF());
        }
        if (in.readBoolean()) {
            this.outputText = in.readUTF();
        }
        if (in.readBoolean()) {
            this.statistic = m.neuronStatisticFactory.createObject();
            this.statistic.readFields(in, m);
        }
        this.bias = in.readDouble();
        this.biasSum = in.readDouble();
        this.posDirSum = in.readDouble();
        this.negDirSum = in.readDouble();
        this.negRecSum = in.readDouble();
        this.posRecSum = in.readDouble();
        this.posPassiveSum = in.readDouble();
        this.requiredSum = in.readDouble();
        this.metaBias = in.readDouble();
        this.isMeta = in.readBoolean();
        this.numDisjunctiveSynapses = in.readInt();
        this.activationFunction = ActivationFunction.valueOf(in.readUTF());
        this.outputNode = m.lookupNodeProvider(in.readInt());
        if (in.readBoolean()) {
            Integer nId = in.readInt();
            this.node = m.lookupNodeProvider(nId);
        }
        this.numberOfInputSynapses = in.readInt();
        while (in.readBoolean()) {
            syn = Synapse.read(in, m);
            this.inputSynapses.put(syn, syn);
        }
        while (in.readBoolean()) {
            syn = Synapse.read(in, m);
            this.outputSynapses.put(syn, syn);
        }
        int l = in.readInt();
        if (l > 0) {
            this.outputRelations = new TreeMap<Integer, Relation>();
            for (int i = 0; i < l; ++i) {
                int synId = in.readInt();
                Relation r = Relation.read(in, m);
                this.outputRelations.put(synId, r);
            }
        }
        this.passiveInputFunction = m.passiveActivationFunctions.get(((Neuron)this.provider).id);
    }

    @Override
    public void suspend() {
        for (Synapse s : this.inputSynapses.values()) {
            s.input.removeInMemoryOutputSynapse(s);
        }
        for (Synapse s : this.outputSynapses.values()) {
            s.output.removeInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryInputSynapses.values()) {
            if (s.isConjunction) continue;
            s.input.removeInMemoryOutputSynapse(s);
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            if (!s.isConjunction) continue;
            s.output.removeInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.releaseReadLock();
    }

    @Override
    public void reactivate() {
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryInputSynapses.values()) {
            if (s.isConjunction) continue;
            s.input.addInMemoryOutputSynapse(s);
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            if (!s.isConjunction) continue;
            s.output.addInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.releaseReadLock();
        for (Synapse s : this.inputSynapses.values()) {
            s.input.addInMemoryOutputSynapse(s);
            if (s.input.isSuspended()) continue;
            s.output.addInMemoryInputSynapse(s);
        }
        for (Synapse s : this.outputSynapses.values()) {
            s.output.addInMemoryInputSynapse(s);
            if (s.output.isSuspended()) continue;
            s.input.addInMemoryOutputSynapse(s);
        }
    }

    public void setBias(double b) {
        double newBiasDelta = b - this.bias;
        this.biasSumDelta += newBiasDelta - this.biasDelta;
        this.biasDelta = newBiasDelta;
    }

    public void changeBias(double bd) {
        this.biasDelta += bd;
        this.biasSumDelta += bd;
    }

    public double getNewBiasSum() {
        return this.biasSum + this.biasSumDelta;
    }

    public void register(Activation act) {
        Document doc = act.doc;
        ThreadState th = ((INeuron)((OrNode)act.node).neuron.get()).getThreadState(doc.threadId, true);
        if (th.activations.isEmpty()) {
            doc.activatedNeurons.add((INeuron)((OrNode)act.node).neuron.get());
        }
        th.minLength = Math.min(th.minLength, act.range.length());
        th.maxLength = Math.max(th.maxLength, act.range.length());
        ActKey ak = new ActKey(act.range, act.id);
        th.activations.put(ak, act);
        TreeMap<ActKey, Activation> actEnd = th.activationsEnd;
        if (actEnd != null) {
            actEnd.put(ak, act);
        }
        Document.ActKey dak = new Document.ActKey(act.range, act.node, act.id);
        if (act.range.begin != null) {
            doc.activationsByRangeBegin.put(dak, act);
        }
        if (act.range.end != null) {
            doc.activationsByRangeEnd.put(dak, act);
        }
        doc.addedActivations.add(act);
    }

    public static boolean update(int threadId, Document doc, Neuron pn, Double bias, Collection<Synapse> modifiedSynapses) {
        INeuron n = (INeuron)pn.get();
        if (bias != null) {
            n.setBias(bias);
        }
        modifiedSynapses.forEach(s -> s.link());
        return Converter.convert(threadId, doc, n, modifiedSynapses);
    }

    public static INeuron readNeuron(DataInput in, Neuron p) throws IOException {
        INeuron n = new INeuron();
        n.provider = p;
        n.threads = new ThreadState[p.model.numberOfThreads];
        n.readFields(in, p.model);
        return n;
    }

    public boolean isPassiveInputNeuron() {
        return this.passiveInputFunction != null;
    }

    public void registerPassiveInputSynapse(Synapse s) {
        if (this.passiveInputSynapses == null) {
            this.passiveInputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
        }
        this.passiveInputSynapses.put(s, s);
    }

    public String toString() {
        return this.label;
    }

    public String toStringWithSynapses() {
        TreeSet<Synapse> is = new TreeSet<Synapse>((s1, s2) -> {
            int r = Double.compare(s2.weight, s1.weight);
            if (r != 0) {
                return r;
            }
            return Integer.compare(s1.input.id, s2.input.id);
        });
        is.addAll(this.inputSynapses.values());
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("<");
        sb.append("B:");
        sb.append(Utils.round(this.biasSum));
        for (Synapse s : is) {
            sb.append(", ");
            sb.append(Utils.round(s.weight));
            sb.append(":");
            sb.append(s.input.toString());
        }
        sb.append(">");
        return sb.toString();
    }

    public static class ActKey {
        Range r;
        int actId;

        public ActKey(Range r, int actId) {
            this.r = r;
            this.actId = actId;
        }
    }

    public static class ThreadState {
        public long lastUsed;
        public TreeMap<ActKey, Activation> activations;
        public TreeMap<ActKey, Activation> activationsEnd;
        public int minLength = Integer.MAX_VALUE;
        public int maxLength = 0;

        public ThreadState() {
            this.activations = new TreeMap(BEGIN_COMP);
            this.activationsEnd = new TreeMap(END_COMP);
        }
    }

    public static enum LogicType {
        CONJUNCTIVE,
        DISJUNCTIVE;

    }

    public static enum Type {
        EXCITATORY,
        INHIBITORY;

    }
}

