/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import network.aika.ActivationFunction;
import network.aika.Document;
import network.aika.Model;
import network.aika.PassiveInputFunction;
import network.aika.Provider;
import network.aika.ReadWriteLock;
import network.aika.neuron.INeuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Range;
import network.aika.neuron.relation.Relation;

public class Neuron
extends Provider<INeuron> {
    public static final Neuron MIN_NEURON = new Neuron(null, Integer.MIN_VALUE);
    public static final Neuron MAX_NEURON = new Neuron(null, Integer.MAX_VALUE);
    public ReadWriteLock lock = new ReadWriteLock();
    public NavigableMap<Integer, Synapse> inputSynapsesById = new TreeMap<Integer, Synapse>();
    public NavigableMap<Synapse, Synapse> inMemoryInputSynapses = new TreeMap<Synapse, Synapse>(Synapse.INPUT_SYNAPSE_COMP);
    public NavigableMap<Synapse, Synapse> inMemoryOutputSynapses = new TreeMap<Synapse, Synapse>(Synapse.OUTPUT_SYNAPSE_COMP);

    public Neuron(Model m, int id) {
        super(m, id);
    }

    public Neuron(Model m, INeuron n) {
        super(m, n);
    }

    public String getLabel() {
        return ((INeuron)this.get()).label;
    }

    public Activation addInput(Document doc, int begin, int end) {
        return this.addInput(doc, new Activation.Builder().setRange(begin, end));
    }

    public Activation addInput(Document doc, Range r) {
        return this.addInput(doc, new Activation.Builder().setRange(r));
    }

    public Activation addInput(Document doc, Activation.Builder inputAct) {
        return ((INeuron)this.get(doc)).addInput(doc, inputAct);
    }

    public static Neuron init(Neuron n, double bias, INeuron.Type type, INeuron.LogicType logicType, Synapse.Builder ... inputs) {
        return Neuron.init(n, bias, type, logicType, new ArrayList<Synapse.Builder>(Arrays.asList(inputs)));
    }

    public static Neuron init(Document doc, Neuron n, double bias, INeuron.Type type, INeuron.LogicType logicType, Synapse.Builder ... inputs) {
        return Neuron.init(doc, n, bias, null, type, logicType, new ArrayList<Synapse.Builder>(Arrays.asList(inputs)));
    }

    public static Neuron init(Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, INeuron.LogicType logicType, Synapse.Builder ... inputs) {
        return Neuron.init(n, bias, activationFunction, type, logicType, new ArrayList<Synapse.Builder>(Arrays.asList(inputs)));
    }

    public static Neuron init(Document doc, Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, INeuron.LogicType logicType, Synapse.Builder ... inputs) {
        return Neuron.init(doc, n, bias, activationFunction, type, logicType, new ArrayList<Synapse.Builder>(Arrays.asList(inputs)));
    }

    public static Neuron init(Neuron n, double bias, INeuron.Type type, INeuron.LogicType logicType, List<Synapse.Builder> inputs) {
        return Neuron.init(n, bias, null, type, logicType, inputs);
    }

    public static Neuron init(Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, INeuron.LogicType logicType, List<Synapse.Builder> inputs) {
        if (n.init(bias, activationFunction, type, logicType, inputs)) {
            return n;
        }
        return null;
    }

    public static Neuron init(Document doc, Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, INeuron.LogicType logicType, List<Synapse.Builder> inputs) {
        if (n.init(doc, bias, activationFunction, type, logicType, inputs)) {
            return n;
        }
        return null;
    }

    public boolean init(double bias, ActivationFunction activationFunction, INeuron.Type type, INeuron.LogicType logicType, List<Synapse.Builder> inputs) {
        return this.init(null, bias, activationFunction, type, logicType, inputs);
    }

    public boolean init(Document doc, double bias, ActivationFunction activationFunction, INeuron.Type type, INeuron.LogicType logicType, List<Synapse.Builder> inputs) {
        int maxSynapseId = -1;
        for (Synapse.Builder builder : inputs) {
            if (builder.synapseId == null) continue;
            maxSynapseId = Math.max(builder.synapseId, maxSynapseId);
        }
        TreeMap<Integer, Synapse.Builder> synapseInputs = new TreeMap<Integer, Synapse.Builder>();
        for (Synapse.Builder builder : inputs) {
            if (builder.synapseId == null) {
                builder.synapseId = ++maxSynapseId;
            }
            synapseInputs.put(builder.synapseId, builder);
        }
        for (Synapse.Builder builder : inputs) {
            Iterator<Map.Entry<Integer, Relation>> it = builder.relations.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Relation> me = it.next();
                assert (me.getKey() != builder.synapseId);
                if (me.getKey() <= builder.synapseId) continue;
                ((Synapse.Builder)synapseInputs.get((Object)me.getKey())).relations.put(builder.synapseId, me.getValue().invert());
                it.remove();
            }
        }
        ArrayList<Synapse> arrayList = new ArrayList<Synapse>();
        for (Synapse.Builder input : synapseInputs.values()) {
            Synapse s = input.getSynapse(this);
            s.update(doc, input.weight, input.bias);
            arrayList.add(s);
        }
        if (activationFunction != null) {
            INeuron iNeuron = (INeuron)this.get();
            iNeuron.activationFunction = activationFunction;
        }
        if (type != null) {
            INeuron iNeuron = (INeuron)this.get();
            iNeuron.type = type;
        }
        if (logicType != null) {
            INeuron iNeuron = (INeuron)this.get();
            iNeuron.logicType = logicType;
        }
        return INeuron.update(this.model.defaultThreadId, doc, this, bias, arrayList);
    }

    public void addSynapse(Synapse.Builder input) {
        this.addSynapse(null, input);
    }

    public void addSynapse(Document doc, Synapse.Builder input) {
        Synapse s = input.getSynapse(this);
        s.update(doc, input.weight, input.bias);
        INeuron.update(doc != null ? doc.threadId : this.model.defaultThreadId, doc, this, 0.0, Collections.singletonList(s));
    }

    public static void registerPassiveInputNeuron(Neuron n, PassiveInputFunction f) {
        ((INeuron)n.get()).passiveInputFunction = f;
        n.model.passiveActivationFunctions.put(n.id, f);
        for (Synapse s : ((INeuron)n.get()).outputSynapses.values()) {
            ((INeuron)s.output.get()).registerPassiveInputSynapse(s);
        }
    }

    public Synapse getSynapseById(int synapseId) {
        return (Synapse)this.inputSynapsesById.get(synapseId);
    }

    public Collection<Activation> getActivations(Document doc, boolean onlyFinal) {
        INeuron n = (INeuron)this.getIfNotSuspended();
        if (n == null) {
            return Collections.emptyList();
        }
        return n.getActivations(doc, onlyFinal);
    }

    public Activation getActivation(Document doc, Range r, boolean onlyFinal) {
        INeuron n = (INeuron)this.getIfNotSuspended();
        if (n == null) {
            return null;
        }
        return n.getActivation(doc, r, onlyFinal);
    }

    public void addInMemoryInputSynapse(Synapse s) {
        this.lock.acquireWriteLock();
        this.inMemoryInputSynapses.put(s, s);
        this.inputSynapsesById.put(s.id, s);
        this.lock.releaseWriteLock();
    }

    public void removeInMemoryInputSynapse(Synapse s) {
        this.lock.acquireWriteLock();
        this.inMemoryInputSynapses.remove(s);
        this.inputSynapsesById.remove(s.id);
        this.lock.releaseWriteLock();
    }

    public void addInMemoryOutputSynapse(Synapse s) {
        this.lock.acquireWriteLock();
        this.inMemoryOutputSynapses.put(s, s);
        this.lock.releaseWriteLock();
    }

    public void removeInMemoryOutputSynapse(Synapse s) {
        this.lock.acquireWriteLock();
        this.inMemoryOutputSynapses.remove(s);
        this.lock.releaseWriteLock();
    }

    @Override
    public String toString() {
        if (this == MIN_NEURON) {
            return "MIN_NEURON";
        }
        if (this == MAX_NEURON) {
            return "MAX_NEURON";
        }
        return super.toString();
    }
}

