/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import network.aika.Model;
import network.aika.Utils;
import network.aika.Writable;

public class Range {
    public static Comparator<Range> BEGIN_COMP = (r1, r2) -> {
        int r = Integer.compare(r1.begin, r2.begin);
        if (r != 0) {
            return r;
        }
        return Integer.compare(r1.end, r2.end);
    };
    public static Comparator<Range> END_COMP = (r1, r2) -> {
        int r = Integer.compare(r1.end, r2.end);
        if (r != 0) {
            return r;
        }
        return Integer.compare(r1.begin, r2.begin);
    };
    public final Integer begin;
    public final Integer end;

    public Range(Integer begin, Integer end) {
        this.begin = begin;
        this.end = end;
    }

    @Deprecated
    public static boolean overlaps(Range ra, Range rb) {
        return Utils.compareInteger(ra.end, rb.begin) > 0 && Utils.compareInteger(rb.end, ra.begin) > 0;
    }

    public int getBegin(boolean invert) {
        return invert ? this.end : this.begin;
    }

    public int getEnd(boolean invert) {
        return invert ? this.begin : this.end;
    }

    public Range invert(boolean inv) {
        return inv ? new Range(this.end, this.begin) : this;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public int length() {
        if (this.begin == null || this.end == null) {
            return Integer.MAX_VALUE;
        }
        return this.end - this.begin;
    }

    public boolean contains(Range r) {
        return this.begin <= r.begin && r.end <= this.end;
    }

    public boolean equals(Range r) {
        return this.begin.intValue() == r.begin.intValue() && this.end.intValue() == r.end.intValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.begin);
        sb.append(",");
        sb.append(this.end);
        sb.append(")");
        return sb.toString();
    }

    public static int compare(Range ra, Range rb, boolean inv) {
        int a = Integer.compare(ra.getBegin(inv), rb.getBegin(inv));
        if (a != 0) {
            return a;
        }
        int b = Integer.compare(ra.getEnd(inv), rb.getEnd(inv));
        return b;
    }

    public static int compare(Range ra, Range rb) {
        int a = Integer.compare(ra.begin, rb.begin);
        if (a != 0) {
            return a;
        }
        int b = Integer.compare(ra.end, rb.end);
        return b;
    }

    public static enum Mapping {
        BEGIN(0),
        END(1),
        NONE(2);

        int id;

        private Mapping(int id) {
            this.id = id;
        }

        public static Mapping getById(int id) {
            for (Mapping m : Mapping.values()) {
                if (m.id != id) continue;
                return m;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public Integer map(Range r) {
            switch (this) {
                case BEGIN: {
                    return r.begin;
                }
                case END: {
                    return r.end;
                }
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case BEGIN: {
                    return "S";
                }
                case END: {
                    return "E";
                }
                case NONE: {
                    return "N";
                }
            }
            return "";
        }
    }

    public static class Output
    implements Writable,
    Comparable<Output> {
        private static SortedMap<Output, Output> map = new TreeMap<Output, Output>();
        public static Output NONE = Output.create(Mapping.NONE, Mapping.NONE);
        public static Output DIRECT = Output.create(Mapping.BEGIN, Mapping.END);
        public static Output BEGIN = Output.create(Mapping.BEGIN, Mapping.NONE);
        public static Output END = Output.create(Mapping.NONE, Mapping.END);
        public Mapping begin = Mapping.NONE;
        public Mapping end = Mapping.NONE;

        private Output() {
        }

        private Output(Mapping begin, Mapping end) {
            this.begin = begin;
            this.end = end;
        }

        public Range map(Range r) {
            return new Range(this.begin.map(r), this.end.map(r));
        }

        public Output invert() {
            return new Output(this.begin == Mapping.BEGIN ? Mapping.BEGIN : (this.end == Mapping.BEGIN ? Mapping.END : Mapping.NONE), this.begin == Mapping.END ? Mapping.BEGIN : (this.end == Mapping.END ? Mapping.END : Mapping.NONE));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("O(");
            sb.append(this.begin.name());
            sb.append(",");
            sb.append(this.end.name());
            sb.append(")");
            return sb.toString();
        }

        public static Output create(Mapping begin, Mapping end) {
            return Output.lookup(new Output(begin, end));
        }

        public static Output lookup(Output r) {
            Output rr = (Output)map.get(r);
            if (rr == null) {
                rr = r;
                map.put(r, r);
            }
            return rr;
        }

        @Override
        public int compareTo(Output ro) {
            int r = Utils.compareInteger(this.begin.ordinal(), ro.begin.ordinal());
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.end.ordinal(), ro.end.ordinal());
            return r;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.begin.getId());
            out.writeByte(this.end.getId());
        }

        public static Output read(DataInput in, Model m) throws IOException {
            Output r = new Output();
            r.readFields(in, m);
            return Output.lookup(r);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.begin = Mapping.getById(in.readByte());
            this.end = Mapping.getById(in.readByte());
        }
    }

    public static enum Operator {
        EQUALS(0),
        LESS_THAN_EQUAL(1),
        GREATER_THAN_EQUAL(2),
        LESS_THAN(3),
        GREATER_THAN(4),
        NONE(5);

        int id;

        private Operator(int id) {
            this.id = (short)id;
        }

        public static Operator getById(int id) {
            for (Operator o : Operator.values()) {
                if (o.id != id) continue;
                return o;
            }
            return null;
        }

        public boolean isGreaterThanOrGreaterThanEqual() {
            return this == GREATER_THAN || this == GREATER_THAN_EQUAL;
        }

        public boolean isLessThanOrLessThanEqual() {
            return this == LESS_THAN || this == LESS_THAN_EQUAL;
        }

        public boolean includesEqual() {
            return this == EQUALS || this == GREATER_THAN_EQUAL || this == LESS_THAN_EQUAL;
        }

        public int getId() {
            return this.id;
        }

        public boolean compare(int a, int b) {
            switch (this) {
                case EQUALS: {
                    return a == b;
                }
                case LESS_THAN_EQUAL: {
                    return a <= b;
                }
                case GREATER_THAN_EQUAL: {
                    return a >= b;
                }
                case LESS_THAN: {
                    return a < b;
                }
                case GREATER_THAN: {
                    return a > b;
                }
            }
            return true;
        }

        public Operator invert() {
            switch (this) {
                case EQUALS: {
                    return EQUALS;
                }
                case LESS_THAN_EQUAL: {
                    return GREATER_THAN_EQUAL;
                }
                case GREATER_THAN_EQUAL: {
                    return LESS_THAN_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
            }
            return NONE;
        }
    }

    public static class Relation
    implements Writable,
    Comparable<Relation> {
        private static SortedMap<Relation, Relation> map = new TreeMap<Relation, Relation>();
        public static Relation EQUALS = Relation.create(Operator.EQUALS, Operator.EQUALS);
        public static Relation BEGIN_EQUALS = Relation.create(Operator.EQUALS, Operator.NONE);
        public static Relation END_EQUALS = Relation.create(Operator.NONE, Operator.EQUALS);
        public static Relation BEGIN_TO_END_EQUALS = Relation.create(Operator.NONE, Operator.EQUALS, Operator.NONE, Operator.NONE);
        public static Relation END_TO_BEGIN_EQUALS = Relation.create(Operator.NONE, Operator.NONE, Operator.NONE, Operator.EQUALS);
        public static Relation CONTAINS = Relation.create(Operator.LESS_THAN_EQUAL, Operator.GREATER_THAN_EQUAL);
        public static Relation CONTAINED_IN = Relation.create(Operator.GREATER_THAN_EQUAL, Operator.LESS_THAN_EQUAL);
        public static Relation OVERLAPS = Relation.create(Operator.NONE, Operator.LESS_THAN, Operator.NONE, Operator.GREATER_THAN);
        public static Relation NONE = Relation.create(Operator.NONE, Operator.NONE);
        public Operator beginToBegin = Operator.NONE;
        public Operator beginToEnd = Operator.NONE;
        public Operator endToEnd = Operator.NONE;
        public Operator endToBegin = Operator.NONE;

        public Relation() {
        }

        private Relation(Operator beginToBegin, Operator beginToEnd, Operator endToEnd, Operator endToBegin) {
            this.beginToBegin = beginToBegin;
            this.beginToEnd = beginToEnd;
            this.endToEnd = endToEnd;
            this.endToBegin = endToBegin;
        }

        public static Relation create(Operator beginToBegin, Operator beginToEnd, Operator endToEnd, Operator endToBegin) {
            return Relation.lookup(new Relation(beginToBegin, beginToEnd, endToEnd, endToBegin));
        }

        public static Relation create(Operator beginToBegin, Operator endToEnd) {
            return Relation.create(beginToBegin, Operator.NONE, endToEnd, Operator.NONE);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("BB:" + this.beginToBegin.name() + ",");
            sb.append("BE:" + this.beginToEnd.name() + ",");
            sb.append("EB:" + this.endToBegin.name() + ",");
            sb.append("EE:" + this.endToEnd.name());
            return sb.toString();
        }

        public boolean compare(Range ra, Range rb) {
            return this.beginToBegin.compare(ra.begin, rb.begin) && this.beginToEnd.compare(ra.begin, rb.end) && this.endToEnd.compare(ra.end, rb.end) && this.endToBegin.compare(ra.end, rb.begin);
        }

        public Relation invert() {
            return new Relation(this.beginToBegin.invert(), this.endToBegin.invert(), this.endToEnd.invert(), this.beginToEnd.invert());
        }

        @Override
        public int compareTo(Relation rr) {
            int r = this.beginToBegin.compareTo(rr.beginToBegin);
            if (r != 0) {
                return r;
            }
            r = this.beginToEnd.compareTo(rr.beginToEnd);
            if (r != 0) {
                return r;
            }
            r = this.endToEnd.compareTo(rr.endToEnd);
            if (r != 0) {
                return r;
            }
            r = this.endToBegin.compareTo(rr.endToBegin);
            return r;
        }

        public static Relation lookup(Relation r) {
            Relation rr = (Relation)map.get(r);
            if (rr == null) {
                rr = r;
                map.put(r, r);
            }
            return rr;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.beginToBegin.getId());
            out.writeByte(this.beginToEnd.getId());
            out.writeByte(this.endToEnd.getId());
            out.writeByte(this.endToBegin.getId());
        }

        public static Relation read(DataInput in, Model m) throws IOException {
            Relation r = new Relation();
            r.readFields(in, m);
            return Relation.lookup(r);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.beginToBegin = Operator.getById(in.readByte());
            this.beginToEnd = Operator.getById(in.readByte());
            this.endToEnd = Operator.getById(in.readByte());
            this.endToBegin = Operator.getById(in.readByte());
        }
    }
}

