/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import network.aika.Document;
import network.aika.Model;
import network.aika.lattice.Node;
import network.aika.neuron.INeuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Range;
import network.aika.neuron.relation.InstanceRelation;
import network.aika.neuron.relation.Relation;

public class RangeRelation
extends Relation {
    public Range.Relation relation;

    RangeRelation() {
    }

    public RangeRelation(Range.Relation relation) {
        this.relation = relation;
    }

    @Override
    public boolean test(Activation act, Activation linkedAct) {
        return this.relation.compare(act.range, linkedAct.range);
    }

    public String toString() {
        return "RR(" + this.relation + ")";
    }

    @Override
    public Relation invert() {
        return new RangeRelation(this.relation.invert());
    }

    @Override
    public int compareTo(Relation rel) {
        if (rel instanceof InstanceRelation) {
            return -1;
        }
        RangeRelation rr = (RangeRelation)rel;
        return this.relation.compareTo(rr.relation);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        this.relation.write(out);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.relation = Range.Relation.read(in, m);
    }

    public static RangeRelation read(DataInput in, Model m) throws IOException {
        RangeRelation rr = new RangeRelation();
        rr.readFields(in, m);
        return rr;
    }

    @Override
    public boolean isExact() {
        return this.relation.beginToBegin == Range.Operator.EQUALS || this.relation.beginToEnd == Range.Operator.EQUALS || this.relation.endToBegin == Range.Operator.EQUALS || this.relation.endToEnd == Range.Operator.EQUALS;
    }

    @Override
    public Collection<Activation> getActivations(INeuron n, Activation linkedAct) {
        INeuron.ThreadState th = n.getThreadState(linkedAct.doc.threadId, false);
        if (th == null || th.activations.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Range r = linkedAct.range;
        Collection<Activation> results = this.isExact() ? RangeRelation.getActivationsByRangeEquals(th, r, this.relation) : ((this.relation.beginToBegin.isGreaterThanOrGreaterThanEqual() || this.relation.beginToEnd.isGreaterThanOrGreaterThanEqual()) && r.begin <= r.end ? RangeRelation.getActivationsByRangeBeginGreaterThan(th, r, this.relation) : ((this.relation.endToEnd.isGreaterThanOrGreaterThanEqual() || this.relation.endToBegin.isGreaterThanOrGreaterThanEqual()) && r.begin >= r.end ? RangeRelation.getActivationsByRangeEndGreaterThan(th, r, this.relation) : ((this.relation.beginToBegin.isLessThanOrLessThanEqual() || this.relation.beginToEnd.isLessThanOrLessThanEqual()) && r.begin <= r.end ? RangeRelation.getActivationsByRangeBeginLessThanEqual(th, r, this.relation) : ((this.relation.endToEnd.isLessThanOrLessThanEqual() || this.relation.endToBegin.isLessThanOrLessThanEqual()) && r.begin >= r.end ? RangeRelation.getActivationsByRangeEndLessThanEqual(th, r, this.relation) : th.activations.values()))));
        return results.stream().filter(act -> this.test((Activation)act, linkedAct)).collect(Collectors.toList());
    }

    private static Collection<Activation> getActivationsByRangeBeginGreaterThan(INeuron.ThreadState th, Range r, Range.Relation rr) {
        boolean toInclusive;
        int toKey;
        boolean fromInclusive;
        int fromKey;
        if (rr.beginToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin;
            fromInclusive = rr.beginToBegin.includesEqual();
        } else {
            fromKey = r.end;
            fromInclusive = rr.beginToEnd.includesEqual();
        }
        if (rr.endToEnd.isLessThanOrLessThanEqual()) {
            toKey = r.end;
            toInclusive = rr.endToEnd.includesEqual();
        } else if (rr.endToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.endToBegin.includesEqual();
        } else {
            toKey = Integer.MAX_VALUE;
            toInclusive = true;
        }
        return th.activations.subMap(new INeuron.ActKey(new Range(fromKey, Integer.MIN_VALUE), Integer.MIN_VALUE), fromInclusive, new INeuron.ActKey(new Range(toKey, Integer.MAX_VALUE), Integer.MAX_VALUE), toInclusive).values();
    }

    private static Collection<Activation> getActivationsByRangeEndGreaterThan(INeuron.ThreadState th, Range r, Range.Relation rr) {
        boolean toInclusive;
        int toKey;
        boolean fromInclusive;
        int fromKey;
        if (rr.endToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end;
            fromInclusive = rr.endToEnd.includesEqual();
        } else {
            fromKey = r.begin;
            fromInclusive = rr.endToBegin.includesEqual();
        }
        if (rr.beginToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.beginToBegin.includesEqual();
        } else if (rr.beginToEnd.isLessThanOrLessThanEqual()) {
            toKey = r.end;
            toInclusive = rr.beginToEnd.includesEqual();
        } else {
            toKey = Integer.MAX_VALUE;
            toInclusive = true;
        }
        return th.activationsEnd.subMap(new INeuron.ActKey(new Range(Integer.MIN_VALUE, fromKey), Integer.MIN_VALUE), fromInclusive, new INeuron.ActKey(new Range(Integer.MAX_VALUE, toKey), Integer.MAX_VALUE), toInclusive).values();
    }

    private static Collection<Activation> getActivationsByRangeBeginLessThanEqual(INeuron.ThreadState th, Range r, Range.Relation rr) {
        boolean toInclusive;
        int toKey;
        boolean fromInclusive;
        int fromKey;
        if (rr.endToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end - th.maxLength;
            fromInclusive = rr.endToEnd.includesEqual();
        } else if (rr.endToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin - th.maxLength;
            fromInclusive = rr.endToBegin.includesEqual();
        } else {
            fromKey = Integer.MIN_VALUE;
            fromInclusive = true;
        }
        if (rr.beginToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.beginToBegin.includesEqual();
        } else {
            toKey = r.end;
            toInclusive = rr.beginToEnd.includesEqual();
        }
        if (fromKey > toKey) {
            return Collections.EMPTY_LIST;
        }
        return th.activations.subMap(new INeuron.ActKey(new Range(fromKey, Integer.MIN_VALUE), Integer.MIN_VALUE), fromInclusive, new INeuron.ActKey(new Range(toKey, Integer.MAX_VALUE), Integer.MAX_VALUE), toInclusive).values();
    }

    private static Collection<Activation> getActivationsByRangeEndLessThanEqual(INeuron.ThreadState th, Range r, Range.Relation rr) {
        boolean toInclusive;
        int toKey;
        boolean fromInclusive;
        int fromKey;
        if (rr.beginToEnd.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.end - th.maxLength;
            fromInclusive = rr.beginToEnd.includesEqual();
        } else if (rr.beginToBegin.isGreaterThanOrGreaterThanEqual()) {
            fromKey = r.begin - th.maxLength;
            fromInclusive = rr.beginToBegin.includesEqual();
        } else {
            fromKey = Integer.MIN_VALUE;
            fromInclusive = true;
        }
        if (rr.endToBegin.isLessThanOrLessThanEqual()) {
            toKey = r.begin;
            toInclusive = rr.endToBegin.includesEqual();
        } else {
            toKey = r.end;
            toInclusive = rr.endToEnd.includesEqual();
        }
        if (fromKey > toKey) {
            return Collections.EMPTY_LIST;
        }
        return th.activationsEnd.subMap(new INeuron.ActKey(new Range(Integer.MIN_VALUE, fromKey), Integer.MIN_VALUE), fromInclusive, new INeuron.ActKey(new Range(Integer.MAX_VALUE, toKey), Integer.MAX_VALUE), toInclusive).values();
    }

    public static Collection<Activation> getActivationsByRangeEquals(INeuron.ThreadState th, Range r, Range.Relation rr) {
        if (rr.beginToBegin == Range.Operator.EQUALS || rr.beginToEnd == Range.Operator.EQUALS) {
            int key = rr.beginToBegin == Range.Operator.EQUALS ? r.begin : r.end;
            return th.activations.subMap(new INeuron.ActKey(new Range(key, Integer.MIN_VALUE), Integer.MIN_VALUE), true, new INeuron.ActKey(new Range(key, Integer.MAX_VALUE), Integer.MAX_VALUE), true).values();
        }
        if (rr.endToEnd == Range.Operator.EQUALS || rr.endToBegin == Range.Operator.EQUALS) {
            int key = rr.endToEnd == Range.Operator.EQUALS ? r.end : r.begin;
            return th.activationsEnd.subMap(new INeuron.ActKey(new Range(Integer.MIN_VALUE, key), Integer.MIN_VALUE), true, new INeuron.ActKey(new Range(Integer.MAX_VALUE, key), Integer.MAX_VALUE), true).values();
        }
        throw new RuntimeException("Invalid Range Relation");
    }

    public static Collection<Activation> getActivationsByRangeEquals(Document doc, Range r, Range.Relation rr) {
        if (rr.beginToBegin == Range.Operator.EQUALS || rr.beginToEnd == Range.Operator.EQUALS) {
            int key = rr.beginToBegin == Range.Operator.EQUALS ? r.begin : r.end;
            return doc.activationsByRangeBegin.subMap(new Document.ActKey(new Range(key, Integer.MIN_VALUE), Node.MIN_NODE, Integer.MIN_VALUE), true, new Document.ActKey(new Range(key, Integer.MAX_VALUE), Node.MAX_NODE, Integer.MAX_VALUE), true).values();
        }
        if (rr.endToEnd == Range.Operator.EQUALS || rr.endToBegin == Range.Operator.EQUALS) {
            int key = rr.endToEnd == Range.Operator.EQUALS ? r.end : r.begin;
            return doc.activationsByRangeEnd.subMap(new Document.ActKey(new Range(Integer.MIN_VALUE, key), Node.MIN_NODE, Integer.MIN_VALUE), true, new Document.ActKey(new Range(Integer.MAX_VALUE, key), Node.MAX_NODE, Integer.MAX_VALUE), true).values();
        }
        throw new RuntimeException("Invalid Range Relation");
    }
}

