/*
 * Decompiled with CFR 0.152.
 */
package network.aika.training;

import java.util.ArrayList;
import network.aika.Document;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;

public class PatternDiscovery {
    public static void discover(Document doc, Config config) {
        doc.createV = doc.visitedCounter++;
        doc.getAllActivationsStream().forEach(act -> config.counter.count((NodeActivation)act));
        ArrayList<NodeActivation> activations = new ArrayList<NodeActivation>(doc.addedNodeActivations);
        doc.addedNodeActivations.clear();
        activations.forEach(act -> ((Node)act.node).discover((NodeActivation)act, config));
        doc.addedNodeActivations.forEach(act -> config.counter.count((NodeActivation)act));
    }

    public static class Config {
        public CandidateCheck candidateCheck;
        public PatternCheck patternCheck;
        public Counter counter;

        public Config setCandidateCheck(CandidateCheck candidateCheck) {
            this.candidateCheck = candidateCheck;
            return this;
        }

        public Config setPatternCheck(PatternCheck patternCheck) {
            this.patternCheck = patternCheck;
            return this;
        }

        public Config setCounter(Counter counter) {
            this.counter = counter;
            return this;
        }
    }

    public static interface Counter {
        public void count(NodeActivation var1);
    }

    public static interface PatternCheck {
        public boolean check(AndNode var1);
    }

    public static interface CandidateCheck {
        public boolean check(NodeActivation var1, NodeActivation var2);
    }
}

