package org.aika.corpus;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


import org.aika.network.Iteration;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.simple.lattice.NegativeInputNode;

import java.util.*;


public class Conflicts {

    public SortedMap<Key, Conflict> primary = new TreeMap<>();
    public Map<Key, Conflict> secondary = new TreeMap<>();


    public static void add(Iteration t, Node n, Option primary, Option secondary) {
        Key ck = new Key(secondary, n);
        Conflict c = primary.conflicts.primary.get(ck);
        if(c == null) {
            c = new Conflict(n, primary, secondary, Option.add(primary.doc, false, primary, secondary));

            primary.countRef();
            secondary.countRef();
            c.conflict.countRef();

            c.conflict.isConflict++;

            primary.conflicts.primary.put(ck, c);
            secondary.conflicts.secondary.put(new Key(primary, n), c);

            c.conflict.removeActivationsRecursiveStep(t, c.conflict, Option.visitedCounter++);
        }
    }


    public static void remove(Iteration t, NegativeInputNode nn, Option primary, Option secondary) {
        Key ck = new Key(secondary, nn);

        Conflict c = primary.conflicts.primary.get(ck);
        if(c == null) return;

        primary.conflicts.primary.remove(ck);
        secondary.conflicts.secondary.remove(new Key(primary, nn));
        c.conflict.isConflict--;

        c.conflict.expandActivationsRecursiveStep(t, c.conflict, Option.visitedCounter++);

        removeInternal(c);
    }


    private static void removeInternal(Conflict c) {
        c.primary.releaseRef();
        c.secondary.releaseRef();
        c.conflict.releaseRef();
    }


    public void removeAll() {
        if(primary != null) {
            for(Conflict c: primary.values()) {
                c.secondary.conflicts.secondary.remove(c.primary);
                removeInternal(c);
            }
        }
        primary.clear();
        if(secondary != null) {
            for(Conflict c: secondary.values()) {
                c.primary.conflicts.primary.remove(c.secondary);
                removeInternal(c);
            }
        }
        secondary.clear();
    }


    public static void copy(Iteration t, Option from, Option to) {
        for (Key ck : from.conflicts.primary.keySet()) {
            add(t, ck.n, to, ck.o);
        }
    }


    public String primaryToString() {
        StringBuilder sb = new StringBuilder();
        for (Conflict c: primary.values()) {
            sb.append(c.n.toString());
            sb.append(" : ");
            sb.append(c.primary.toString());
            sb.append(" : ");
            sb.append(c.secondary.toString());
            sb.append("\n");
        }
        return sb.toString();
    }


    public static class Conflict {
        public Node n;
        public Option primary;
        public Option secondary;
        public Option conflict;


        public Conflict(Node n, Option primary, Option secondary, Option conflict) {
            this.n = n;
            this.primary = primary;
            this.secondary = secondary;
            this.conflict = conflict;
        }
    }


    public static class Key implements Comparable<Key> {
        public Option o;
        public Node n;

        public Key(Option o, Node n) {
            this.o = o;
            this.n = n;
        }

        @Override
        public int compareTo(Key k) {
            int r = o.compareTo(k.o);
            if(r != 0) return r;
            return Node.compare(n, k.n);
        }
    }
}
