package org.aika.network;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.aika.corpus.Document;
import org.aika.corpus.ExpandNode;
import org.aika.corpus.Option;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.Node.Queue;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.LatticeNode;

import java.util.ArrayList;
import java.util.TreeSet;

/**
 *
 * @author Lukas Molzberger
 */
public class Iteration {

    public static final double WEIGHT_TOLERANCE= 0.01;

    public Document doc;
    public Model m;

    public Queue queue = new Queue();

    public TreeSet<AndNode> weightChanged = new TreeSet<>();
    public TreeSet<Node> hasActivations = new TreeSet<>();
    public TreeSet<Node> addedNodes = new TreeSet<>();

    public static int numberOfPositionsDelta;


    Iteration(Document doc, Model m) {
        this.doc = doc;
        this.m = m;
    }


    public void propagate() {
        queue.processChanges(this);
    }


    public void process() {
        double maxDelta;
        do {
            maxDelta = 0;
            for(Node n: hasActivations) {
                for(Activation act : n.getActivations()) {
                    maxDelta = Math.max(maxDelta, act.computeWeight());
                }
            }
        } while(maxDelta > WEIGHT_TOLERANCE);

        doc.top.computeWeights(Option.visitedCounter++);

        ExpandNode.computeSelectedOption(doc);
    }


    public void train() {
        m.numberOfPositions += numberOfPositionsDelta;
        numberOfPositionsDelta = 0;

        doc.selectedOption.count();

        for(Node n: hasActivations) {
            if(n.frequencyHasChanged) {
                if(n instanceof AndNode && m.trainingInterval.contains(n.frequency)) {
                    weightChanged.add((AndNode) n);
                }
                if(n.neuron != null) {
                    n.neuron.propagateInputFrequencyChange(this);
                }
            }
        }

        propagate();
        for(Node n: new ArrayList<>(hasActivations)) {
            if(n instanceof LatticeNode && n.frequencyHasChanged) {
                ((LatticeNode) n).train(this);
            }
            n.frequencyHasChanged = false;
        }

        propagate();

        // TODO: count frequency for the newly created nodes.

        for(AndNode n: weightChanged) {
            n.computeWeight(m);
        }

/*        for(Node n: addedNodes) {
            n.cleanup();
        }
*/
    }


    public void clearActivations() {
        for(Node n: m.allNodes) { // TODO: fix hasActivations
            n.clearActivations();
        }
    }


    public void changeNumberOfPositions(int delta) {
        numberOfPositionsDelta += delta;

        // TODO: Bei größerer Anzahl numberOfPositions nicht jedes mal alle Nodes Updaten. NumberOfPositions abhängig vom Neurontyp.

        if(m.trainingInterval.contains(m.numberOfPositions + numberOfPositionsDelta)) {
            for (Node n : m.allNodes) {
                if (n instanceof AndNode) {
                    weightChanged.add((AndNode) n);
                }
            }
        }
    }
}
