package org.aika.network.neuron;


import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;

public interface Input {


    void addActivation(Iteration t, Activation inputAct, Range addedRange);


    void removeActivation(Iteration t, Activation inputAct, Range removedRange);


    void remove(Model m);


    class InputKey implements Comparable<InputKey> {
        final int inputType;
        final Integer rid;


        public InputKey(int inputType, Integer rid) {
            this.inputType = inputType;
            this.rid = rid;
        }


        @Override
        public int compareTo(InputKey ik) {
            int r = Integer.compare(inputType, ik.inputType);
            if(r != 0) return r;
            if(rid == null && ik.rid == null) return 0;
            if(rid == null && ik.rid != null) return -1;
            if(rid != null && ik.rid == null) return 1;
            return Integer.compare(rid, ik.rid);
        }
    }
}
