package org.aika.network.neuron;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.aika.network.neuron.recurrent.RecurrentNode.RecurrentType;
import org.aika.network.neuron.simple.lattice.InputNode;
import org.aika.network.neuron.simple.lattice.NegativeInputNode;
import org.aika.network.neuron.simple.lattice.PositiveInputNode;

/**
 *
 * @author Lukas Molzberger
 */
public class Synapse implements Comparable<Synapse> {

    public Neuron input;
    public Neuron output;

    public boolean relative;
    public int rid;

    public float w;

    public RecurrentType recurrentType;


    public Synapse(Neuron input) {
        this.input = input;
    }


    public Synapse(Neuron input, int rid, boolean relative) {
        this.input = input;
        this.rid = rid;
        this.relative = relative;
    }


    public Synapse(Neuron input, RecurrentType recurrentType) {
        this.input = input;
        this.recurrentType = recurrentType;
    }


    public InputNode getInputNode() {
        return (InputNode) input.outputNodes.get(new Input.InputKey(w >= 0 ? PositiveInputNode.INPUT_TYPE : NegativeInputNode.INPUT_TYPE, relative ? null : rid));
    }


    @Override
    public int compareTo(Synapse s) {
        int r = Integer.compare(rid, s.rid);
        if(r != 0) return r;
        return input.compareTo(s.input);
    }


    public String toString() {
        return "S " + w + " " + rid + ":" +  input.toString();
    }

}
