package org.aika.network.neuron.recurrent;


/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Input;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.PositiveInputNode;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;


/**
 *
 * @author Lukas Molzberger
 */
public class ClockNode extends RecurrentNode implements Input {

    public final static int INPUT_TYPE = 3;

    public Neuron inputNeuron;

    public Map<TerminationNode, ClockTerminationNode> ctNodes = new TreeMap<>();


    public ClockNode(Model m) {
        super(m, 0);
        countingMode = true;
    }


    @Override
    public double computeForwardWeight(Activation act) {
        return 0;
    }


    @Override
    public double getNodeWeight(Activation act) {
        return weight;
    }


    public Collection<ClockTerminationNode> getChildren() {
        return ctNodes.values();
    }


    @Override
    public void remove(Model m) {

    }


    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("C");

        sb.append("[");
        if(inputNeuron != null) {
            sb.append(inputNeuron.id);
            if(inputNeuron.label != null) {
                sb.append(",");
                sb.append(inputNeuron.label);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}
