package org.aika.network.neuron.recurrent;


/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Input;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.simple.lattice.LatticeNode;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;


/**
 *
 * @author Lukas Molzberger
 */
public class InputNode extends RecurrentNode implements Input {

    public final static int INPUT_TYPE = 2;

    public Neuron inputNeuron;

    public Map<ClockTerminationNode, OutputNode> outputNodes = new TreeMap<>();

    public InputNode(Model m) {
        super(m, 0);
    }


    @Override
    public double computeForwardWeight(Activation act) {
//        assert !act.inputs.isEmpty(); // TODO: fix

        return act.computeAverageInputWeight();
    }


    @Override
    public double getNodeWeight(Activation act) {
        return weight;
    }


    public Collection<OutputNode> getChildren() {
        return outputNodes.values();
    }


    @Override
    public void remove(Model m) {

    }


    @Override
    public void initActivation(Iteration t, Activation act) {
        if(activations.isEmpty()) {
            for (OutputNode on : outputNodes.values()) {
                on.ctNode.outputNodesWithinDocument.put(this, on);
            }
        }
    }


    @Override
    public void deleteActivation(Iteration t, Activation act) {
        if(activations.isEmpty()) {
            for (OutputNode on : outputNodes.values()) {
                on.ctNode.outputNodesWithinDocument.remove(this);
            }
        }
    }


    @Override
    public void clearActivations() {
        super.clearActivations();

        for (OutputNode on : outputNodes.values()) {
            on.ctNode.outputNodesWithinDocument.remove(this);
        }
    }


    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I");

        sb.append("[");
        if(inputNeuron != null) {
            sb.append(inputNeuron.id);
            if(inputNeuron.label != null) {
                sb.append(",");
                sb.append(inputNeuron.label);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}
