package org.aika.network.neuron.simple.lattice;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.aika.network.Model;
import org.aika.network.neuron.Activation;

/**
 *
 * @author Lukas Molzberger
 */
public class PositiveInputNode extends InputNode {

    public final static int INPUT_TYPE = 0;

    public PositiveInputNode(Model m, Integer rid) {
        super(m, rid);
    }


    @Override
    public boolean isNegative() {
        return false;
    }


    @Override
    public boolean containsNegative() {
        return false;
    }



    @Override
    public double computeForwardWeight(Activation act) {
        if(!act.inputs.isEmpty()) {
            return act.computeAverageInputWeight();
        } else {
            return 1.0;
        }
    }


    public double getNodeWeight(Activation act) {
        return weight;
    }


    @Override
    public int getSign() {
        return -1;
    }


    @Override
    public void cleanup(Model m) {

    }


    @Override
    public void remove(Model m) {
        inputNeuron.outputNodes.remove(new InputKey(INPUT_TYPE, rid));
        super.remove(m);
    }

}
