package org.aika.predefinedrules;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.aika.network.Model;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.recurrent.RecurrentNeuron;
import org.aika.network.neuron.simple.SimpleNeuron;
import org.aika.network.neuron.simple.SimpleNeuron.Input;
import org.aika.utils.SetUtils;

import java.util.HashMap;
import java.util.Map;


/**
 *
 * @author Lukas Molzberger
 */
public class PredefinedRules {

    public Map<Character, SimpleNeuron[]> lpWordCharN = new HashMap<>();

    public SimpleNeuron earlySE = new SimpleNeuron("earlySE");
    public SimpleNeuron lateSE = new SimpleNeuron("lateSE", true);

    public SimpleNeuron charClock;
    public SimpleNeuron wordSep;

    public final int NUMBER_OF_CPS = 4;

    public void addRules(Model m) {
/*
        charClock = m.createOrLookupInputSignal("CHAR-CLOCK", true);
        charClock.node.countingMode = true;

        wordSep = m.createOrLookupInputSignal("WORD-SEP", true);
        wordSep.node.countingMode = true;

        SimpleNeuron spaceN = m.createOrLookupInputSignal("SPACE", true);


        Neuron SB_PRE = m.createOrNeuron(new SimpleNeuron("SB-PRE"), SetUtils.asSortedSet(new Input(false, lateSE), new Input(false, spaceN)));
        RecurrentNeuron SB = m.createRecurrentNeuron(new RecurrentNeuron("SB"), SB_PRE, charClock, wordSep, true, 1);

        Neuron WS = m.createRecurrentNeuron(new RecurrentNeuron("WS"), lateSE, charClock, SB, true, 20);
        m.createNegationNeuron(earlySE, WS);


        String chars = "abcdefghijklmnopqrstuvwxyzäöüß";
        for(int i = 0; i < chars.length(); i++) {
            char c = chars.charAt(i);
            SimpleNeuron ciLetterN = m.createOrLookupInputSignal("CI_LETTER." + c, false);

            SimpleNeuron[] lpwcN = new SimpleNeuron[NUMBER_OF_CPS];
            lpWordCharN.put(c, lpwcN);

            lpwcN[0] = ciLetterN;
            for(int j = 1; j < lpwcN.length; j++) {
                lpwcN[j] = m.createAndNeuron(new SimpleNeuron("lp-" + c + "-" + j), true, SetUtils.asSortedSet(new Input(false, lpwcN[j - 1]), new Input(true, lateSE)));
            }
        }



        Neuron SB = Neuron.createOrNeuron(new Neuron(), "SB", SetUtils.asSortedSet(new Input(false, -1, lateSE), new Input(false, -1, spaceN)), false);
        Neuron WS = Neuron.createRecurrentNeuron(new Neuron(), "WS", lateSE, SB, 0, false, Neuron.MAX_RECURRENT_ACTIVATIONS, true, true);
        Neuron.createNegationNeuron(earlySE, "earlySE", WS, 1, false);


        String chars = "abcdefghijklmnopqrstuvwxyzäöüß";
        for(int i = 0; i < chars.length(); i++) {
            char c = chars.charAt(i);
            Neuron ciLetterN = Neuron.createOrLookupInputSignal("CI_LETTER." + c, true);

            Neuron[] lpwcN = new Neuron[NUMBER_OF_CPS];
            lpWordCharN.put(c, lpwcN);

            lpwcN[0] = ciLetterN;
            for(int j = 1; j < lpwcN.length; j++) {
                lpwcN[j] = Neuron.createAndNeuron(new Neuron(), "lp-" + c + "-" + j, SetUtils.asSortedSet(new Input(false, -1, lpwcN[j - 1]), new Input(true, -1, lateSE)), false);
            }
        }
*/
    }

}
