package org.aika.utils;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.AndNode.Refinement;

import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author Lukas Molzberger
 */
public class StringUtils {

    public static String extractSyllable(AndNode p) {
        int maxPos = 0;
        Map<Integer, Character> syl = new TreeMap<>();
        for(Refinement ref: p.parents.keySet()) {
            Neuron in = ref.input.inputNeuron;
            if(in != null && in.label != null && in.label.startsWith("lp-")) {
                int pos = Integer.parseInt(in.label.substring(5));
                syl.put(pos, in.label.charAt(3));
                if(pos >= maxPos) {
                    maxPos = pos;
                }
            }
            if(in != null && in.label != null && in.label.startsWith("CI_LETTER.")) {
                syl.put(0, in.label.charAt(10));
            }
        }

        char[] sylCharArr = new char[maxPos + 1];
        for(int i = 0; i < sylCharArr.length; i++) {
            sylCharArr[i] = ' ';
        }

        for(Map.Entry<Integer, Character> me: syl.entrySet()) {
            sylCharArr[maxPos - me.getKey()] = me.getValue();
        }
        return new String(sylCharArr);
    }
}
