/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.aika.corpus.Option;
import org.aika.network.Iteration;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.simple.lattice.NegativeInputNode;

public class Conflicts {
    public SortedMap<Key, Conflict> primary = new TreeMap<Key, Conflict>();
    public Map<Key, Conflict> secondary = new TreeMap<Key, Conflict>();

    public static void add(Iteration t, Node n, Option primary, Option secondary) {
        Key ck = new Key(secondary, n);
        Conflict c = (Conflict)primary.conflicts.primary.get(ck);
        if (c == null) {
            c = new Conflict(n, primary, secondary, Option.add(primary.doc, false, primary, secondary));
            primary.countRef();
            secondary.countRef();
            c.conflict.countRef();
            ++c.conflict.isConflict;
            primary.conflicts.primary.put(ck, c);
            secondary.conflicts.secondary.put(new Key(primary, n), c);
            c.conflict.removeActivationsRecursiveStep(t, c.conflict, Option.visitedCounter++);
        }
    }

    public static void remove(Iteration t, NegativeInputNode nn, Option primary, Option secondary) {
        Key ck = new Key(secondary, nn);
        Conflict c = (Conflict)primary.conflicts.primary.get(ck);
        if (c == null) {
            return;
        }
        primary.conflicts.primary.remove(ck);
        secondary.conflicts.secondary.remove(new Key(primary, nn));
        --c.conflict.isConflict;
        c.conflict.expandActivationsRecursiveStep(t, c.conflict, Option.visitedCounter++);
        Conflicts.removeInternal(c);
    }

    private static void removeInternal(Conflict c) {
        c.primary.releaseRef();
        c.secondary.releaseRef();
        c.conflict.releaseRef();
    }

    public void removeAll() {
        if (this.primary != null) {
            for (Conflict c : this.primary.values()) {
                c.secondary.conflicts.secondary.remove(c.primary);
                Conflicts.removeInternal(c);
            }
        }
        this.primary.clear();
        if (this.secondary != null) {
            for (Conflict c : this.secondary.values()) {
                c.primary.conflicts.primary.remove(c.secondary);
                Conflicts.removeInternal(c);
            }
        }
        this.secondary.clear();
    }

    public static void copy(Iteration t, Option from, Option to) {
        for (Key ck : from.conflicts.primary.keySet()) {
            Conflicts.add(t, ck.n, to, ck.o);
        }
    }

    public String primaryToString() {
        StringBuilder sb = new StringBuilder();
        for (Conflict c : this.primary.values()) {
            sb.append(c.n.toString());
            sb.append(" : ");
            sb.append(c.primary.toString());
            sb.append(" : ");
            sb.append(c.secondary.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class Key
    implements Comparable<Key> {
        public Option o;
        public Node n;

        public Key(Option o, Node n) {
            this.o = o;
            this.n = n;
        }

        @Override
        public int compareTo(Key k) {
            int r = this.o.compareTo(k.o);
            if (r != 0) {
                return r;
            }
            return Node.compare(this.n, k.n);
        }
    }

    public static class Conflict {
        public Node n;
        public Option primary;
        public Option secondary;
        public Option conflict;

        public Conflict(Node n, Option primary, Option secondary, Option conflict) {
            this.n = n;
            this.primary = primary;
            this.secondary = secondary;
            this.conflict = conflict;
        }
    }
}

