/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.aika.corpus.ExpandNode;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.neuron.Activation;

public class Document {
    private String content;
    public int primOptionIdCounter = 0;
    public int optionIdCounter = 1;
    public Option top = new Option(this, true, -1, Integer.MAX_VALUE, -1, -1, Integer.MAX_VALUE);
    public Option bottom = new Option(this, false, -1, 0, -1, -1, 0);
    public ExpandNode selectedExpandNode = null;
    public Option selectedOption = null;
    public long selectedMark = -1L;
    public Range topRange = new Range(this, true, Range.toSeg(0, Integer.MAX_VALUE));
    public Range bottomRange = new Range(this, false, new ArrayList<int[]>());
    public Map<List<int[]>, Range> ranges = new TreeMap<List<int[]>, Range>(Range.SEGMENT_COMPARATOR);

    public Document(String content) {
        this.content = content;
        this.top.negation = this.bottom;
        this.bottom.negation = this.top;
        Option.addLink(this.bottom, this.top);
        this.topRange.negation = this.bottomRange;
        this.bottomRange.negation = this.topRange;
        Range.initLattice(this);
    }

    public static Document create(String content) {
        return new Document(content);
    }

    public boolean isSelected(Activation act) {
        if (!this.selectedOption.contains(act.key.o)) {
            return false;
        }
        return act.newOption == null || this.selectedOption.contains(act.newOption);
    }

    public String getContent() {
        return this.content;
    }

    public int length() {
        return this.content.length();
    }

    public String toString() {
        return this.content;
    }

    public String conflictsToString() {
        HashSet<Option> conflicts = new HashSet<Option>();
        this.top.collectConflicts(conflicts, Option.visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("Conflicts:\n");
        for (Option n : conflicts) {
            sb.append(n.conflicts.primaryToString());
        }
        sb.append("\n");
        return sb.toString();
    }

    public String selectedOptionsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Selected Options:\n");
        sb.append(this.selectedOption.toString());
        sb.append("\n");
        return sb.toString();
    }

    public boolean contains(Range r) {
        return r.getBegin() >= 0 && r.getEnd() <= this.length();
    }
}

