/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.Option;

public class ExpandNode {
    public static int MAX_SEARCH_STEPS = 10000;
    ExpandNode excludedParent;
    ExpandNode selectedParent;
    ExpandNode parent;
    ExpandNode nonConflictingBranch;
    ExpandNode conflictingBranch;
    long visited;
    Option refinement;
    double upperBound;
    double accumulatedWeight;
    HashSet<Option> conflicts = new HashSet();
    long debugId = debugIdCounter++;
    static long debugIdCounter = 0L;

    public ExpandNode(ExpandNode parent, ExpandNode selectedParent, ExpandNode excludedParent) {
        this.parent = parent;
        this.selectedParent = selectedParent;
        this.excludedParent = excludedParent;
    }

    public static void computeSelectedOption(Document doc) {
        ArrayList<Option> results = new ArrayList<Option>();
        results.add(doc.bottom);
        int numClusters = ExpandNode.computeClusters(doc);
        for (int clusterId = 0; clusterId < numClusters; ++clusterId) {
            try {
                doc.selectedExpandNode = null;
                ExpandNode root = new ExpandNode(null, null, null);
                root.refinement = doc.bottom;
                root.accumulatedWeight = 0.0;
                root.nonConflictingBranch = new ExpandNode(root, root, null);
                int[] searchSteps = new int[1];
                root.nonConflictingBranch.search(doc, true, clusterId, searchSteps);
                if (doc.selectedExpandNode == null) continue;
                doc.selectedExpandNode.collectResults(results);
                continue;
            }
            catch (ExpandNodeException e) {
                System.err.println("Too many search steps!");
            }
        }
        doc.selectedOption = Option.add(doc, true, results.toArray(new Option[results.size()]));
    }

    private static int computeClusters(Document doc) {
        long v = Option.visitedCounter++;
        for (Option n : doc.bottom.children) {
            n.clusterId = -1;
        }
        int clusterIdCounter = 0;
        for (Option n : doc.bottom.children) {
            if (n.clusterId >= 0) continue;
            ExpandNode.markClusterUp(n, clusterIdCounter++, v);
        }
        return clusterIdCounter;
    }

    private static void markClusterUp(Option n, int clusterId, long v) {
        if (n.clusterVisitedUp == v) {
            return;
        }
        n.clusterVisitedUp = v;
        for (Option cn : n.children) {
            if (cn.inv) continue;
            ExpandNode.markClusterUp(cn, clusterId, v);
        }
        ExpandNode.markClusterDown(n, clusterId, v);
    }

    private static void markClusterDown(Option n, int clusterId, long v) {
        if (n.isBottom() || n.clusterVisitedDown == v) {
            return;
        }
        n.clusterVisitedDown = v;
        assert (n.clusterId < 0 || n.clusterId == clusterId);
        n.clusterId = clusterId;
        for (Option pn : n.parents) {
            ExpandNode.markClusterDown(pn, clusterId, v);
        }
        ExpandNode.markClusterUp(n, clusterId, v);
    }

    private void collectResults(Collection<Option> results) {
        results.add(this.refinement);
        if (this.selectedParent != null) {
            this.selectedParent.collectResults(results);
        }
    }

    private void markSelected(long v) {
        this.refinement.markSelected(v);
        if (this.selectedParent != null) {
            this.selectedParent.markSelected(v);
        }
    }

    private void search(Document doc, boolean branch, int clusterId, int[] searchSteps) {
        if (searchSteps[0] > MAX_SEARCH_STEPS) {
            throw new ExpandNodeException();
        }
        searchSteps[0] = searchSteps[0] + 1;
        this.generateCandidate(doc, branch, clusterId);
        if (this.refinement == null) {
            return;
        }
        boolean f = doc.selectedMark == -1L || this.refinement.markedSelected != doc.selectedMark;
        this.nonConflictingBranch = new ExpandNode(this, this, this.excludedParent);
        this.nonConflictingBranch.search(doc, true, clusterId, searchSteps);
        if (f) {
            this.conflictingBranch = new ExpandNode(this, this.selectedParent, this);
            this.conflictingBranch.search(doc, false, clusterId, searchSteps);
        }
    }

    private void generateCandidate(Document doc, boolean branch, int clusterId) {
        long ubVisited;
        this.upperBound = 0.0;
        this.accumulatedWeight = 0.0;
        TreeSet<Option> queue = new TreeSet<Option>(Option.SMALLEST_FIRST_COMPARATOR);
        doc.bottom.containedInUpperBound = ubVisited = Option.visitedCounter++;
        queue.add(doc.bottom);
        while (!queue.isEmpty()) {
            Option n = queue.pollFirst();
            if (!n.containedInUpperBound(ubVisited) || this.coveredConflicting(n)) continue;
            n.containedInUpperBound = ubVisited;
            if (n.weight > 0.0) {
                long v;
                ++Option.visitedCounter;
                Double naw = this.markCovered(v, n);
                if (naw == null) {
                    this.parent.conflicts.add(n);
                    continue;
                }
                double aw = (this.selectedParent != null ? this.selectedParent.accumulatedWeight : 0.0) + naw;
                this.upperBound += n.weight;
                if (this.accumulatedWeight < aw && (branch || this.isConflicting(n)) && !this.isCovered(n.markedCovered)) {
                    this.accumulatedWeight = aw;
                    this.refinement = n;
                }
            }
            for (Option c : n.children) {
                if (c.inv || c.clusterId != clusterId || c.isConflict >= 0) continue;
                queue.add(c);
            }
        }
        if (doc.selectedExpandNode != null && this.upperBound < doc.selectedExpandNode.accumulatedWeight) {
            this.refinement = null;
        }
        if (this.refinement == null) {
            return;
        }
        this.visited = Option.visitedCounter++;
        this.accumulatedWeight = (this.selectedParent != null ? this.selectedParent.accumulatedWeight : 0.0) + this.markCovered(this.visited, this.refinement);
        if (doc.selectedExpandNode == null || this.accumulatedWeight > doc.selectedExpandNode.accumulatedWeight) {
            doc.selectedExpandNode = this;
            doc.selectedMark = Option.visitedCounter++;
            this.markSelected(doc.selectedMark);
        }
    }

    public boolean coveredConflicting(Option n) {
        return this.excludedParent != null && (this.excludedParent.refinement == n || this.excludedParent.coveredConflicting(n));
    }

    private boolean isCovered(long g) {
        return this.selectedParent != null && (g == this.selectedParent.visited || this.selectedParent.isCovered(g));
    }

    private Double markCovered(long v, Option n) {
        Double r;
        if (n.visitedMarkCovered == v) {
            return 0.0;
        }
        n.visitedMarkCovered = v;
        if (this.isCovered(n.markedCovered)) {
            return 0.0;
        }
        n.markedCovered = v;
        if (n.isBottom()) {
            return n.weight;
        }
        double result = n.weight;
        for (Option p : n.parents) {
            r = this.markCovered(v, p);
            if (r == null) {
                return null;
            }
            result += r.doubleValue();
        }
        for (Option c : n.children) {
            if (c.inv || c.visitedMarkCovered == v || !this.containedInSelectedBranch(v, c)) continue;
            if (c.isConflict >= 0) {
                return null;
            }
            c.markedCovered = v;
            r = this.markCovered(v, c);
            if (r == null) {
                return null;
            }
            result += r.doubleValue();
        }
        return result;
    }

    public boolean containedInSelectedBranch(long v, Option n) {
        for (Option p : n.parents) {
            if (p.markedCovered == v || this.isCovered(p.markedCovered)) continue;
            return false;
        }
        return true;
    }

    private boolean isConflicting(Option n) {
        return this.parent != null && (this.parent.checkForConflict(n) || this == this.parent.conflictingBranch && this.parent.isConflicting(n));
    }

    public boolean checkForConflict(Option n) {
        return this.conflicts.contains(n) || this.selectedParent != null && this.selectedParent.checkForConflict(n);
    }

    public static class ExpandNodeException
    extends RuntimeException {
    }
}

