/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.network.Iteration;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Node;
import org.aika.utils.SetUtils;

public class Option
implements Comparable<Option> {
    public static final Option MIN = new Option(null, false, 0, 0, 0, 0, 0);
    public static final Option MAX = new Option(null, true, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0, Integer.MAX_VALUE);
    public static final Comparator<Option> SIZE_COMPARATOR = new Comparator<Option>(){

        @Override
        public int compare(Option n1, Option n2) {
            int r = Integer.compare(n2.length, n1.length);
            if (r != 0) {
                return r;
            }
            return Integer.compare(n1.id, n2.id);
        }
    };
    public static final Comparator<Option> SMALLEST_FIRST_COMPARATOR = new Comparator<Option>(){

        @Override
        public int compare(Option n1, Option n2) {
            int r = Integer.compare(n1.length, n2.length);
            if (r != 0) {
                return r;
            }
            return Integer.compare(n1.id, n2.id);
        }
    };
    public final boolean inv;
    public final int primId;
    public final int id;
    public final int length;
    public final int minPos;
    public final int maxPos;
    public Option negation;
    private long visitedComputeRelations = -1L;
    private long visitedOptimize = -1L;
    private long visitedLinkRelations = -1L;
    private long visitedLinkPrimitive = -1L;
    private long visitedContains = -1L;
    private long visitedCollect = -1L;
    private long visitedCount = -1L;
    public long visitedAccumulatedWeight = -1L;
    private long visitedComputeWeights = -1L;
    private long visitedCollectConflicts = -1L;
    private long visitedExpandActivations = -1L;
    private long visitedRemoveActivations = -1L;
    public long visitedMarkCovered = -1L;
    public long markedCovered = -1L;
    public long containedInUpperBound = -1L;
    public long markedSelected = -1L;
    public int clusterId = -1;
    public long clusterVisitedUp = -1L;
    public long clusterVisitedDown = -1L;
    public static long visitedCounter = 0L;
    public final Document doc;
    public boolean isRemoved;
    public int removedId;
    public static int removedIdCounter = 1;
    public ArrayList<Option> parents;
    public ArrayList<Option> children;
    public Map<Option, Boolean> cache = new HashMap<Option, Boolean>();
    public int isConflict = -1;
    public Conflicts conflicts = new Conflicts();
    public NavigableMap<Activation.Key, Activation> activations;
    public NavigableSet<Activation> activationsComplete;
    public double weight;
    public double accumulatedWeight;
    public int refCount = 0;

    public Option(Document doc, boolean inv, int primId, int id, int minPos, int maxPos, int length) {
        this.doc = doc;
        this.inv = inv;
        this.primId = primId;
        this.id = id;
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.length = length;
        this.parents = new ArrayList();
        this.children = new ArrayList();
    }

    public void countRef() {
        if (this.isBottom() || this.isTop()) {
            return;
        }
        ++this.refCount;
    }

    public void releaseRef() {
        if (this.isBottom() || this.isTop()) {
            return;
        }
        assert (this.refCount > 0);
        --this.refCount;
        if (this.refCount == 0) {
            this.remove();
        }
    }

    public List<Option> select(Relation or) {
        ArrayList<Option> results = new ArrayList<Option>();
        switch (or) {
            case EQUALS: {
                results.add(this);
                break;
            }
            case CONTAINS: {
                this.collect(results, false, true, visitedCounter++);
                break;
            }
            case CONTAINED_IN: {
                this.collect(results, true, true, visitedCounter++);
                break;
            }
        }
        return results;
    }

    public void collect(List<Option> results, boolean dir, boolean includeFirst, long v) {
        if (this.visitedCollect == v) {
            return;
        }
        this.visitedCollect = v;
        if (includeFirst) {
            results.add(this);
        }
        for (Option r : dir ? this.parents : this.children) {
            r.collect(results, dir, true, v);
        }
    }

    public Option clonePrimitive(Iteration t) {
        assert (this.primId != -1);
        Option no = Option.addPrimitive(this.doc, this.minPos);
        Conflicts.copy(t, this, no);
        return no;
    }

    public void removePrimitive(Iteration t) {
        assert (this.primId >= 0);
        this.conflicts.removeAll();
    }

    void expandActivationsRecursiveStep(Iteration t, Option conflict, long v) {
        if (v == this.visitedExpandActivations) {
            return;
        }
        this.visitedExpandActivations = v;
        for (Activation act : this.getActivationsComplete()) {
            act.key.n.propagateAddedActivation(t, act, act.key.pos, conflict);
        }
        for (Option p : this.parents) {
            p.expandActivationsRecursiveStep(t, conflict, v);
        }
    }

    void removeActivationsRecursiveStep(Iteration t, Option conflict, long v) {
        if (v == this.visitedRemoveActivations) {
            return;
        }
        this.visitedRemoveActivations = v;
        for (Activation act : this.getActivationsComplete()) {
            if (!act.key.o.contains(conflict)) continue;
            Node cfr_ignored_0 = act.key.n;
            Node.removeActivationAndPropagate(t, false, act, act.key.pos);
        }
        if (this.children != null) {
            for (Option c : this.children) {
                if (c.isRemoved) continue;
                c.removeActivationsRecursiveStep(t, conflict, v);
            }
        }
    }

    public Collection<Activation> getActivationsComplete() {
        return this.activationsComplete != null ? this.activationsComplete : SetUtils.EMPTY_SET;
    }

    public static Option add(Document doc, boolean nonConflicting, Option ... input) {
        Option nn;
        Option n;
        if (input.length == 0) {
            return doc.bottom;
        }
        ArrayList<Option> in = new ArrayList<Option>();
        int minPos = Integer.MAX_VALUE;
        int maxPos = 0;
        for (int i = 0; i < input.length; ++i) {
            n = input[i];
            if (n == null) continue;
            assert (doc == n.doc);
            assert (!n.inv);
            assert (!n.isRemoved);
            boolean f = true;
            for (int j = 0; j < input.length; ++j) {
                Option x = input[j];
                if (x == null || i == j || !x.contains(n) || x == n && i >= j) continue;
                f = false;
                break;
            }
            if (!f) continue;
            in.add(n);
            minPos = Math.min(minPos, n.minPos);
            maxPos = Math.max(maxPos, n.maxPos);
        }
        if (in.size() == 1) {
            Option n2 = (Option)in.get(0);
            if (nonConflicting && n2.isConflict >= 0) {
                return null;
            }
            n2.countRef();
            return n2;
        }
        ArrayList<Option> children = new ArrayList<Option>();
        Option.computeRelations(children, false, in, in, visitedCounter++);
        if (children.size() == 1) {
            n = children.get(0);
            if (!n.inv) {
                if (nonConflicting && n.isConflict >= 0) {
                    return null;
                }
                n.countRef();
                return n;
            }
        } else if (children.size() == 0) {
            children.add(doc.top);
        }
        ArrayList<Option> parents = new ArrayList<Option>();
        Option.computeRelations(parents, true, in, children, visitedCounter++);
        if (nonConflicting) {
            for (Option p : parents) {
                if (p.isConflict < 0) continue;
                return null;
            }
        }
        Option n3 = new Option(doc, false, -1, doc.optionIdCounter++, minPos, maxPos, Option.computeLength(parents));
        n3.negation = nn = new Option(doc, true, -1, doc.optionIdCounter++, n3.minPos, n3.maxPos, Integer.MAX_VALUE - n3.length);
        nn.negation = n3;
        n3.linkRelations(parents, children, visitedCounter++);
        n3.countRef();
        return n3;
    }

    public static int computeLength(List<Option> parents) {
        ArrayList<Option> count = new ArrayList<Option>();
        Option.computeLengthRecursiveStep(count, new ArrayList<Option>(), parents);
        int l = 0;
        for (Option n : count) {
            l += n.length;
        }
        return l;
    }

    private static void computeLengthRecursiveStep(List<Option> count, List<Option> parentOverlapping, List<Option> parents) {
        Option[] sortedParents = new Option[parents.size()];
        parents.toArray(sortedParents);
        Arrays.sort(sortedParents, SIZE_COMPARATOR);
        ArrayList<Option> overlapping = new ArrayList<Option>(parentOverlapping);
        for (Option p : sortedParents) {
            if (p.containedIn(parentOverlapping)) continue;
            List<Option> no = p.filterOutside(overlapping);
            if (no.isEmpty()) {
                count.add(p);
            } else {
                Option.computeLengthRecursiveStep(count, no, p.parents);
            }
            overlapping.add(p);
        }
    }

    public List<Option> filterOutside(List<Option> options) {
        ArrayList<Option> results = new ArrayList<Option>();
        for (Option n : options) {
            if (this.negation.contains(n)) continue;
            results.add(n);
        }
        return results;
    }

    private void computePrimitiveRelations(List<Option> results, long v) {
        if (v == this.visitedLinkPrimitive) {
            return;
        }
        this.visitedLinkPrimitive = v;
        boolean f = false;
        for (Option p : this.parents) {
            if (!p.inv) continue;
            f = true;
            p.computePrimitiveRelations(results, v);
        }
        if (!f) {
            results.add(this);
        }
    }

    private static void computeRelations(List<Option> results, boolean dir, List<Option> input, List<Option> start, long v) {
        Option bestN = null;
        int bestLength = dir ? Integer.MAX_VALUE : 0;
        for (Option s : start) {
            if (dir != bestLength >= s.length) continue;
            bestN = s;
            bestLength = s.length;
        }
        super.computeRelationsRecursiveStep(results, dir, input, v);
    }

    private void computeRelationsRecursiveStep(List<Option> results, boolean dir, List<Option> input, long v) {
        if (v == this.visitedComputeRelations) {
            return;
        }
        this.visitedComputeRelations = v;
        for (Option r : dir ? this.parents : this.children) {
            if (!dir && r.containsAll(input) || dir && r.containedIn(input)) {
                r.optimize(results, dir, input, v);
                continue;
            }
            if ((dir || r.negation.containedIn(input)) && (!dir || r.outsideOfAll(input))) continue;
            r.computeRelationsRecursiveStep(results, dir, input, v);
        }
    }

    private void optimize(List<Option> results, boolean dir, List<Option> input, long v) {
        if (v == this.visitedOptimize) {
            return;
        }
        this.visitedOptimize = v;
        boolean f = false;
        for (Option r : dir ? this.children : this.parents) {
            if (v == r.visitedComputeRelations || (dir || !r.containsAll(input)) && (!dir || !r.containedIn(input))) continue;
            f = true;
            r.optimize(results, dir, input, v);
        }
        if (!f) {
            results.add(this);
        }
    }

    private void linkRelations(List<Option> pSet, List<Option> cSet, long v) {
        for (Option p : pSet) {
            Option.addLink(p, this);
        }
        for (Option c : cSet) {
            c.visitedLinkRelations = v;
            Option.addLink(this, c);
        }
        for (Option p : pSet) {
            ArrayList<Option> tmp = new ArrayList<Option>();
            for (Option c : p.children) {
                if (c.visitedLinkRelations != v) continue;
                tmp.add(c);
            }
            for (Option c : tmp) {
                Option.removeLink(p, c);
            }
        }
    }

    public boolean containedIn(Collection<Option> input) {
        if (this.inv) {
            return false;
        }
        if (this.containedInAny(input)) {
            return true;
        }
        if (this.outsideOfAll(input)) {
            return false;
        }
        for (Option p : this.parents) {
            if (p.containedIn(input)) continue;
            return false;
        }
        return true;
    }

    public static void addLink(Option a, Option b) {
        a.children.add(b);
        b.parents.add(a);
        if (a != b.negation) {
            b.negation.children.add(a.negation);
            a.negation.parents.add(b.negation);
        }
    }

    public static void removeLink(Option a, Option b) {
        a.children.remove(b);
        b.parents.remove(a);
        if (a != b.negation) {
            b.negation.children.remove(a.negation);
            a.negation.parents.remove(b.negation);
        }
    }

    public static Option addPrimitive(Document doc, int pos) {
        int primId = doc.primOptionIdCounter++;
        Option n = new Option(doc, false, primId, doc.optionIdCounter++, pos, pos, 1);
        Option nn = new Option(doc, true, primId, doc.optionIdCounter++, pos, pos, 0x7FFFFFFE);
        nn.negation = n;
        n.negation = nn;
        ArrayList<Option> children = new ArrayList<Option>();
        doc.top.computePrimitiveRelations(children, visitedCounter++);
        n.linkRelations(Arrays.asList(doc.bottom), children, visitedCounter++);
        n.countRef();
        return n;
    }

    private void remove() {
        assert (!this.inv);
        assert (!this.isRemoved);
        this.isRemoved = true;
        this.removedId = removedIdCounter++;
        for (Option p : this.parents) {
            p.children.remove(this);
            if (p == this.negation) continue;
            p.negation.parents.remove(this.negation);
        }
        for (Option c : this.children) {
            c.parents.remove(this);
            if (this == c.negation) continue;
            c.negation.children.remove(this.negation);
        }
        for (Option p : this.parents) {
            for (Option c : this.children) {
                if (c.isLinked(p, visitedCounter++)) continue;
                Option.addLink(p, c);
            }
        }
        this.parents = null;
        this.children = null;
        this.conflicts = null;
        this.negation.negation = null;
        this.negation = null;
    }

    public void count() {
        this.countRecursiveStep(this, visitedCounter++);
    }

    private void countRecursiveStep(Option so, long v) {
        if (v == this.visitedCount) {
            return;
        }
        this.visitedCount = v;
        for (Activation act : this.getActivationsComplete()) {
            act.key.n.countActivation(act.key, so);
        }
        for (Option p : this.parents) {
            p.countRecursiveStep(so, v);
        }
    }

    public void computeWeights(long v) {
        if (v == this.visitedComputeWeights) {
            return;
        }
        this.visitedComputeWeights = v;
        this.weight = 0.0;
        for (Activation act : this.getActivationsComplete()) {
            if (act.key.n.neuron == null) continue;
            this.weight += act.weight;
        }
        for (Option p : this.parents) {
            p.computeWeights(v);
        }
    }

    public boolean isTop() {
        return this.length == Integer.MAX_VALUE;
    }

    public boolean isBottom() {
        return this.length == 0;
    }

    public boolean outsideOfAll(Collection<Option> input) {
        for (Option n : input) {
            if (n.negation.contains(this)) continue;
            return false;
        }
        return true;
    }

    public boolean containedInAny(Collection<Option> input) {
        for (Option n : input) {
            if (!n.contains(this)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(List<Option> input) {
        for (Option n : input) {
            if (this.contains(n)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Option n) {
        return this.contains(n, true, visitedCounter++);
    }

    public boolean contains(boolean dir, Option n) {
        boolean r = !dir ? this.contains(n, true, visitedCounter++) : n.contains(this, true, visitedCounter++);
        return r;
    }

    private boolean contains(Option n, boolean start, long v) {
        assert (this.visitedContains <= v);
        assert (!this.isRemoved);
        assert (!n.isRemoved);
        if (!this.inv && n.inv) {
            return false;
        }
        if (this == n || this.isTop() || n.isBottom()) {
            return true;
        }
        this.visitedContains = v;
        if (this.length < n.length) {
            return false;
        }
        if (this.maxPos < n.minPos || n.maxPos < this.minPos) {
            return this.inv != n.inv;
        }
        Boolean cv = this.cache.get(n);
        if (cv != null) {
            return cv;
        }
        boolean result = false;
        for (Option p : this.parents) {
            if (p.visitedContains == v || !p.contains(n, false, v)) continue;
            result = true;
            break;
        }
        if (start) {
            this.cache.put(n, result);
        }
        return result;
    }

    private boolean isLinked(Option n, long v) {
        assert (this.visitedContains <= v);
        assert (!this.isRemoved);
        assert (!n.isRemoved);
        if (this == n) {
            return true;
        }
        this.visitedContains = v;
        if (this.length < n.length) {
            return false;
        }
        for (Option p : this.parents) {
            if (p.visitedContains == v || !p.isLinked(n, v)) continue;
            return true;
        }
        return false;
    }

    private void collectPrimitiveIds(Set<Integer> results, long v) {
        if (v == this.visitedCollect) {
            return;
        }
        this.visitedCollect = v;
        if (this.primId >= 0) {
            results.add(this.primId);
        } else {
            for (Option n : this.inv ? this.children : this.parents) {
                n.collectPrimitiveIds(results, v);
            }
        }
    }

    public boolean containedInUpperBound(long v) {
        for (Option p : this.parents) {
            if (p.containedInUpperBound == v) continue;
            return false;
        }
        return true;
    }

    public void collectConflicts(Set<Option> conflicts, long v) {
        if (this.visitedCollectConflicts == v) {
            return;
        }
        this.visitedCollectConflicts = v;
        for (Option n : this.parents) {
            if (this.isConflict >= 0) {
                conflicts.add(n);
            }
            n.collectConflicts(conflicts, v);
        }
    }

    public static Option create(Document doc, Integer ... ids) {
        HashSet<Integer> tmp = new HashSet<Integer>(Arrays.asList(ids));
        ArrayList<Option> primOptions = new ArrayList<Option>();
        for (Option p : doc.bottom.children) {
            if (!tmp.contains(p.primId)) continue;
            primOptions.add(p);
        }
        return Option.add(doc, false, primOptions.toArray(new Option[primOptions.size()]));
    }

    public double computeAccumulatedWeight(long v) {
        if (v == this.visitedAccumulatedWeight) {
            return 0.0;
        }
        this.visitedAccumulatedWeight = v;
        double accWeight = this.weight;
        for (Option p : this.parents) {
            accWeight += p.computeAccumulatedWeight(v);
        }
        return accWeight;
    }

    public void markSelected(long v) {
        if (this.markedSelected == v) {
            return;
        }
        this.markedSelected = v;
        for (Option p : this.parents) {
            p.markSelected(v);
        }
    }

    public String toString() {
        TreeSet<Integer> ids = new TreeSet<Integer>();
        this.collectPrimitiveIds(ids, visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (this.inv) {
            sb.append("!");
        }
        boolean first = true;
        for (Integer id : ids) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(id);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(Option n) {
        int r = Integer.compare(this.length, n.length);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, n.id);
    }

    public static int compare(Option oa, Option ob) {
        if (oa == ob) {
            return 0;
        }
        if (oa == null && ob != null) {
            return -1;
        }
        if (oa != null && ob == null) {
            return 1;
        }
        return oa.compareTo(ob);
    }

    public static enum Relation {
        EQUALS,
        CONTAINS,
        CONTAINED_IN;


        public boolean compare(Option a, Option b) {
            switch (this) {
                case EQUALS: {
                    return a == b;
                }
                case CONTAINS: {
                    return a.contains(b);
                }
                case CONTAINED_IN: {
                    return b.contains(a);
                }
            }
            return false;
        }
    }
}

