/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.aika.corpus.Document;
import org.aika.network.neuron.Activation;

public class Range
implements Comparable<Range> {
    public static final Range MIN = new Range(null, false, Range.toSeg(0, 0));
    public static final Range MAX = new Range(null, true, Range.toSeg(Integer.MAX_VALUE, Integer.MAX_VALUE));
    public final boolean inv;
    List<int[]> segments;
    public final int length;
    public boolean isPrimitive;
    public final Document doc;
    public boolean isRemoved;
    public int removedId;
    public static int removedIdCounter = 1;
    public ArrayList<Range> parents = new ArrayList();
    public ArrayList<Range> children = new ArrayList();
    int allParents = 0;
    int allChildren = 0;
    public Range negation;
    private static final Comparator<Activation.Key> COMP = new Comparator<Activation.Key>(){

        @Override
        public int compare(Activation.Key k1, Activation.Key k2) {
            int r = k1.n.compareTo(k2.n);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            r = k1.o.compareTo(k2.o);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(k1.fired, k2.fired);
            if (r != 0) {
                return r;
            }
            return Integer.compare(k1.id, k2.id);
        }
    };
    public static final Comparator<List<int[]>> SEGMENT_COMPARATOR = new Comparator<List<int[]>>(){

        @Override
        public int compare(List<int[]> r1, List<int[]> r2) {
            for (int i = 0; i < Math.max(r1.size(), r2.size()); ++i) {
                int[] sb;
                if (i >= r1.size()) {
                    return -1;
                }
                if (i >= r2.size()) {
                    return 1;
                }
                int[] sa = r1.get(i);
                int r = Integer.compare(sa[0], (sb = r2.get(i))[0]);
                if (r != 0) {
                    return r;
                }
                r = Integer.compare(sa[1], sb[1]);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }
    };
    public NavigableMap<Activation.Key, Activation> inputActivations = new TreeMap<Activation.Key, Activation>(COMP);
    public NavigableMap<Activation.Key, Activation> activations = new TreeMap<Activation.Key, Activation>(COMP);
    private long visitedContains = -1L;
    private long visitedLinkRelations = -1L;
    private long visitedComputeRelations = -1L;
    private long visitedOptimize = -1L;
    private long visitedCollect = -1L;
    private long visitedCountNode = -1L;
    public static long visitedCounter = 0L;
    public int refCount = 0;

    private boolean isBefore(Range b) {
        return this.getEnd() <= b.getBegin();
    }

    private static boolean isBefore(List<int[]> a, List<int[]> b) {
        return a.get(a.size() - 1)[1] <= b.get(0)[0];
    }

    static List<int[]> toSeg(int begin, int end) {
        ArrayList<int[]> tmp = new ArrayList<int[]>(1);
        tmp.add(new int[]{begin, end});
        return tmp;
    }

    Range(Document doc, boolean inv, List<int[]> segments) {
        this.doc = doc;
        this.inv = inv;
        this.segments = segments;
        int l = 0;
        for (int i = 0; i < segments.size(); ++i) {
            int[] seg = segments.get(i);
            l += seg[1] - seg[0];
        }
        this.length = l;
    }

    public static Range create(Document doc, int a, int b) {
        int[] nArray;
        assert (a >= 0 && a <= doc.length() && b >= 0 && b <= doc.length());
        if (a == b) {
            return doc.bottomRange;
        }
        if (a <= b) {
            int[] nArray2 = new int[2];
            nArray2[0] = a;
            nArray = nArray2;
            nArray2[1] = b;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = b;
            nArray = nArray3;
            nArray3[1] = a;
        }
        int[] seg = nArray;
        ArrayList<int[]> tmp = new ArrayList<int[]>();
        tmp.add(seg);
        return Range.createInternal(doc, tmp);
    }

    public static Range create(Document doc, int[] pos) {
        if (pos.length == 0) {
            return doc.bottomRange;
        }
        if (pos[0] == 0 && pos[1] >= Integer.MAX_VALUE) {
            return doc.topRange;
        }
        assert (pos.length % 2 == 0);
        ArrayList<int[]> r = new ArrayList<int[]>();
        int i = 0;
        while (i < pos.length) {
            r.add(new int[]{pos[i++], pos[i++]});
        }
        return Range.createInternal(doc, Range.mergeAdjoined(r));
    }

    public static Range create(Document doc, List<int[]> r) {
        if (r.size() == 0) {
            return doc.bottomRange;
        }
        if (r.get(0)[0] == 0 && r.get(0)[1] == Integer.MAX_VALUE) {
            return doc.topRange;
        }
        return Range.createInternal(doc, Range.mergeAdjoined(r));
    }

    static Range createInternal(Document doc, List<int[]> pos) {
        Range r = doc.ranges.get(pos);
        if (r != null) {
            return r;
        }
        ArrayList<Range> tmp = new ArrayList<Range>();
        List<int[]> uncovered = pos;
        while (uncovered.size() != 0) {
            ArrayList<Range> collected = new ArrayList<Range>();
            int start = uncovered.get(0)[0];
            Range startRange = doc.ranges.get(Range.toSeg(start, start + 1));
            startRange.collectMaxCovering(collected, pos, visitedCounter++);
            for (Range tr : collected) {
                uncovered = Range.complement(uncovered, tr.segments);
                tmp.add(tr);
            }
        }
        r = Range.add(doc, tmp.toArray(new Range[tmp.size()]));
        doc.ranges.put(pos, r);
        return r;
    }

    private boolean collectMaxCovering(ArrayList<Range> results, List<int[]> pos, long v) {
        if (this.visitedCollect == v) {
            return false;
        }
        this.visitedCollect = v;
        if (this.inv) {
            return true;
        }
        if (!Range.contains(pos, this.segments)) {
            return true;
        }
        boolean flag = true;
        for (Range c : this.children) {
            if (c.collectMaxCovering(results, pos, v)) continue;
            flag = false;
        }
        if (flag) {
            results.add(this);
        }
        return false;
    }

    static void initLattice(Document doc) {
        Range nr;
        Range r = new Range(doc, false, Range.toSeg(0, doc.length()));
        doc.ranges.put(r.segments, r);
        r.negation = nr = new Range(doc, true, Range.invert(r.segments));
        nr.negation = r;
        r.initLatticeRecursiveStep();
    }

    private void initLatticeRecursiveStep() {
        if (this.length > 1) {
            int l = 1;
            while (l * 10 < this.getEnd() - this.getBegin()) {
                l *= 10;
            }
            for (int i = this.getBegin(); i < this.getEnd(); i += l) {
                Range nr;
                Range r = new Range(this.doc, false, Range.toSeg(i, Math.min(i + l, this.getBegin() + this.getEnd())));
                this.doc.ranges.put(r.segments, r);
                r.negation = nr = new Range(this.doc, true, Range.invert(r.segments));
                nr.negation = r;
                this.parents.add(r);
                r.children.add(this);
                this.negation.children.add(nr);
                nr.parents.add(this.negation);
                r.initLatticeRecursiveStep();
            }
        } else {
            this.isPrimitive = true;
            this.parents.add(this.doc.bottomRange);
            this.doc.bottomRange.children.add(this);
            this.negation.children.add(this.doc.bottomRange);
            this.doc.topRange.parents.add(this.negation);
        }
        this.countNode(false, true, visitedCounter++);
        this.countNode(true, true, visitedCounter++);
    }

    private void countNode(boolean dir, boolean addOrDelete, long v) {
        if (this.inv || this.visitedCountNode == v) {
            return;
        }
        this.visitedCountNode = v;
        if (dir) {
            this.allParents += addOrDelete ? 1 : -1;
        } else {
            this.allChildren += addOrDelete ? 1 : -1;
        }
        for (Range r : dir ? this.parents : this.children) {
            r.countNode(dir, addOrDelete, v);
        }
    }

    private static List<int[]> mergeAdjoined(List<int[]> r) {
        if (r.size() <= 1) {
            return r;
        }
        ArrayList<int[]> results = new ArrayList<int[]>();
        int[] last = null;
        for (int[] s : r) {
            if (last != null && last[1] > s[0]) {
                s[0] = results.get(results.size() - 1)[0];
                results.remove(results.size() - 1);
            }
            results.add(s);
            last = s;
        }
        return results;
    }

    public static Range add(Document doc, Range ... input) {
        Range nn;
        Range n;
        if (input.length == 0) {
            return doc.bottomRange;
        }
        List<int[]> segs = Range.union(input);
        Range r = doc.ranges.get(segs);
        if (r != null) {
            return r;
        }
        ArrayList<Range> in = new ArrayList<Range>();
        int minPos = Integer.MAX_VALUE;
        int maxPos = 0;
        for (int i = 0; i < input.length; ++i) {
            n = input[i];
            if (n == null) continue;
            assert (doc == n.doc);
            assert (!n.inv);
            assert (!n.isRemoved);
            boolean f = true;
            for (int j = 0; j < input.length; ++j) {
                Range x = input[j];
                if (x == null || i == j || !x.contains(n) || x == n && i >= j) continue;
                f = false;
                break;
            }
            if (!f) continue;
            in.add(n);
            minPos = Math.min(minPos, n.getBegin());
            maxPos = Math.max(maxPos, n.getEnd());
        }
        ArrayList<Range> children = new ArrayList<Range>();
        Range.computeRelations(children, false, in, in, visitedCounter++);
        if (children.size() == 1) {
            n = children.get(0);
            if (!n.inv && SEGMENT_COMPARATOR.compare(segs, n.segments) == 0) {
                n.countRef();
                return n;
            }
        } else if (children.size() == 0) {
            children.add(doc.topRange);
        }
        ArrayList<Range> parents = new ArrayList<Range>();
        Range.computeRelations(parents, true, in, children, visitedCounter++);
        Range n2 = new Range(doc, false, segs);
        doc.ranges.put(segs, n2);
        n2.negation = nn = new Range(doc, true, Range.invert(n2.segments));
        nn.negation = n2;
        n2.linkRelations(parents, children, visitedCounter++);
        n2.countRef();
        n2.countNode(false, true, visitedCounter++);
        n2.countNode(true, true, visitedCounter++);
        return n2;
    }

    private static void computeRelations(List<Range> results, boolean dir, List<Range> input, List<Range> start, long v) {
        Range bestN = null;
        int bestLength = dir ? Integer.MAX_VALUE : 0;
        for (Range s : start) {
            if (dir != bestLength >= s.length) continue;
            bestN = s;
            bestLength = s.length;
        }
        super.computeRelationsRecursiveStep(results, dir, input, v);
    }

    private void computeRelationsRecursiveStep(List<Range> results, boolean dir, List<Range> input, long v) {
        if (v == this.visitedComputeRelations) {
            return;
        }
        this.visitedComputeRelations = v;
        for (Range r : dir ? this.parents : this.children) {
            if (!dir && r.containsAll(input) || dir && r.containedIn(input)) {
                r.optimize(results, dir, input, v);
                continue;
            }
            if ((dir || r.negation.containedIn(input)) && (!dir || r.outsideOfAll(input))) continue;
            r.computeRelationsRecursiveStep(results, dir, input, v);
        }
    }

    private void linkRelations(List<Range> pSet, List<Range> cSet, long v) {
        for (Range p : pSet) {
            Range.addLink(p, this);
        }
        for (Range c : cSet) {
            c.visitedLinkRelations = v;
            Range.addLink(this, c);
        }
        for (Range p : pSet) {
            ArrayList<Range> tmp = new ArrayList<Range>();
            for (Range c : p.children) {
                if (c.visitedLinkRelations != v) continue;
                tmp.add(c);
            }
            for (Range c : tmp) {
                Range.removeLink(p, c);
            }
        }
    }

    private void optimize(List<Range> results, boolean dir, List<Range> input, long v) {
        if (v == this.visitedOptimize) {
            return;
        }
        this.visitedOptimize = v;
        boolean f = false;
        for (Range r : dir ? this.children : this.parents) {
            if (v == r.visitedComputeRelations || (dir || !r.containsAll(input)) && (!dir || !r.containedIn(input))) continue;
            f = true;
            r.optimize(results, dir, input, v);
        }
        if (!f) {
            results.add(this);
        }
    }

    private void remove() {
        assert (!this.inv);
        assert (!this.isRemoved);
        this.isRemoved = true;
        this.removedId = removedIdCounter++;
        for (Range p : this.parents) {
            p.children.remove(this);
            if (p == this.negation) continue;
            p.negation.parents.remove(this.negation);
        }
        for (Range c : this.children) {
            c.parents.remove(this);
            if (this == c.negation) continue;
            c.negation.children.remove(this.negation);
        }
        for (Range p : this.parents) {
            for (Range c : this.children) {
                if (c.isLinked(p, visitedCounter++)) continue;
                Range.addLink(p, c);
            }
        }
        this.parents = null;
        this.children = null;
        this.negation.negation = null;
        this.negation = null;
    }

    public static void addLink(Range a, Range b) {
        a.children.add(b);
        b.parents.add(a);
        if (a != b.negation) {
            b.negation.children.add(a.negation);
            a.negation.parents.add(b.negation);
        }
    }

    public static void removeLink(Range a, Range b) {
        a.children.remove(b);
        b.parents.remove(a);
        if (a != b.negation) {
            b.negation.children.remove(a.negation);
            a.negation.parents.remove(b.negation);
        }
    }

    private boolean isLinked(Range n, long v) {
        assert (this.visitedContains <= v);
        assert (!this.isRemoved);
        assert (!n.isRemoved);
        if (this == n) {
            return true;
        }
        this.visitedContains = v;
        if (this.length < n.length) {
            return false;
        }
        for (Range p : this.parents) {
            if (p.visitedContains == v || !p.isLinked(n, v)) continue;
            return true;
        }
        return false;
    }

    public boolean containedIn(Collection<Range> input) {
        if (this.inv) {
            return false;
        }
        if (this.containedInAny(input)) {
            return true;
        }
        if (this.outsideOfAll(input)) {
            return false;
        }
        for (Range p : this.parents) {
            if (p.containedIn(input)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(List<Range> input) {
        for (Range n : input) {
            if (this.contains(n)) continue;
            return false;
        }
        return true;
    }

    public boolean outsideOfAll(Collection<Range> input) {
        for (Range n : input) {
            if (n.negation.contains(this)) continue;
            return false;
        }
        return true;
    }

    public boolean containedInAny(Collection<Range> input) {
        for (Range n : input) {
            if (!n.contains(this)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int p) {
        for (int[] seg : this.segments) {
            if (seg[0] > p || p >= seg[1]) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List<int[]> r, int p) {
        for (int[] seg : r) {
            if (seg[0] > p || p >= seg[1]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Range r) {
        return Range.contains(this.segments, r.segments);
    }

    public static boolean contains(List<int[]> ra, List<int[]> rb) {
        int i = 0;
        int j = 0;
        while (i < ra.size() && j < rb.size()) {
            int[] segB;
            int[] segA = ra.get(i);
            if (segA[1] <= (segB = rb.get(j))[0]) {
                ++i;
                continue;
            }
            if (segA[0] > segB[0] || segA[1] < segB[1]) {
                return false;
            }
            ++j;
        }
        return j == rb.size();
    }

    public static boolean overlaps(Range ra, Range rb, boolean includeAdjoined, boolean onlyAfter) {
        return Range.overlaps(ra.segments, rb.segments, includeAdjoined, onlyAfter);
    }

    public static boolean overlaps(List<int[]> ra, List<int[]> rb, boolean includeAdjoined, boolean onlyAfter) {
        if (ra.size() == 1 && rb.size() == 1) {
            return Range.simpleOverlaps(ra.get(0), rb.get(0), includeAdjoined, onlyAfter);
        }
        List<int[]> intersect = Range.intersection(includeAdjoined ? Range.extend(ra, onlyAfter ? 0 : 1, 1) : ra, rb);
        if (!onlyAfter) {
            return intersect.size() != 0;
        }
        return intersect.size() != 0 && !Range.isAnySegmentBefore(intersect, Range.complement(ra, intersect));
    }

    private static boolean simpleOverlaps(int[] sa, int[] sb, boolean includeAdjoined, boolean onlyAfter) {
        int bs = includeAdjoined && !onlyAfter ? 1 : 0;
        int es = includeAdjoined ? 1 : 0;
        return sa[1] + es > sb[0] && sb[1] > sa[0] - bs && (!onlyAfter || sb[0] >= sa[0]);
    }

    static boolean isAnySegmentBefore(List<int[]> ra, List<int[]> rb) {
        int i = 0;
        int j = 0;
        while (i < ra.size() && j < rb.size()) {
            int[] sb;
            int[] sa = ra.get(i);
            if (sa[1] == (sb = rb.get(j))[0]) {
                return true;
            }
            int a = Integer.compare(sa[1], sb[1]);
            if (a <= 0) {
                ++i;
            }
            if (a < 0) continue;
            ++j;
        }
        return false;
    }

    public static List<int[]> extend(List<int[]> r, int before, int after) {
        ArrayList<int[]> results = new ArrayList<int[]>();
        for (int[] s : r) {
            int begin = s[0] > before ? s[0] - before : 0;
            int end = Integer.MAX_VALUE - s[1] < after ? Integer.MAX_VALUE : s[1] + after;
            results.add(new int[]{begin, end});
        }
        return Range.mergeAdjoined(results);
    }

    private static List<int[]> union(Range[] r) {
        List<int[]> tmp = Range.invert(r[0].segments);
        for (int i = 1; i < r.length; ++i) {
            tmp = Range.intersection(tmp, Range.invert(r[i].segments));
        }
        return Range.invert(tmp);
    }

    public static List<int[]> union(List<List<int[]>> r) {
        boolean s = false;
        if (!s) {
            return new ArrayList<int[]>();
        }
        if (s) {
            return r.get(0);
        }
        List<int[]> tmp = Range.invert(r.get(0));
        for (int i = 1; i < r.size(); ++i) {
            tmp = Range.intersection(tmp, Range.invert(r.get(i)));
        }
        return Range.invert(tmp);
    }

    public static List<int[]> intersection(List<int[]> segA, List<int[]> segB) {
        int i = 0;
        int j = 0;
        ArrayList<int[]> results = new ArrayList<int[]>();
        while (i < segA.size() && j < segB.size()) {
            int a;
            int end;
            int[] sb;
            int[] sa = segA.get(i);
            int begin = Math.max(sa[0], (sb = segB.get(j))[0]);
            if (begin < (end = Math.min(sa[1], sb[1]))) {
                results.add(new int[]{begin, end});
            }
            if ((a = Integer.compare(sa[1], sb[1])) <= 0) {
                ++i;
            }
            if (a < 0) continue;
            ++j;
        }
        return Range.mergeAdjoined(results);
    }

    public Range intersection(Range r) {
        return Range.createInternal(this.doc, Range.intersection(this.segments, r.segments));
    }

    public Range complement(Range r) {
        return this.intersection(r.negation);
    }

    public static List<int[]> complement(List<int[]> ra, List<int[]> rb) {
        return Range.intersection(ra, Range.invert(rb));
    }

    private static List<int[]> invert(List<int[]> segments) {
        ArrayList<int[]> results = new ArrayList<int[]>();
        int pos = 0;
        for (int[] seg : segments) {
            if (pos < seg[0]) {
                results.add(new int[]{pos, seg[0]});
            }
            pos = seg[1];
        }
        if (pos < Integer.MAX_VALUE) {
            results.add(new int[]{pos, Integer.MAX_VALUE});
        }
        return Range.mergeAdjoined(results);
    }

    public boolean isGapLess() {
        return this.segments.size() == 1;
    }

    public int[] getSegment(int i) {
        return this.segments.get(i);
    }

    public List<int[]> getSegments() {
        return this.segments;
    }

    public int getBegin() {
        return this.segments.get(0)[0];
    }

    public int getEnd() {
        return this.segments.get(this.segments.size() - 1)[1];
    }

    public int getBegin(boolean invert) {
        return invert ? this.getEnd() : this.getBegin();
    }

    public int getEnd(boolean invert) {
        return invert ? this.getBegin() : this.getEnd();
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public boolean isTop() {
        return this.doc.topRange == this;
    }

    public boolean isBottom() {
        return this.doc.bottomRange == this;
    }

    public boolean contains(boolean dir, Range n) {
        boolean r = !dir ? this.contains(n, visitedCounter++) : n.contains(this, visitedCounter++);
        return r;
    }

    private boolean contains(Range n, long v) {
        assert (this.visitedContains <= v);
        assert (!this.isRemoved);
        assert (!n.isRemoved);
        if (!this.inv && n.inv) {
            return false;
        }
        if (this == n || this.isTop() || n.isBottom()) {
            return true;
        }
        this.visitedContains = v;
        if (this.length < n.length) {
            return false;
        }
        if (this.getEnd() < n.getBegin() || n.getEnd() < this.getBegin()) {
            return this.inv != n.inv;
        }
        boolean result = false;
        for (Range p : this.parents) {
            if (p.visitedContains == v || !p.contains(n, v)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void countRef() {
        if (this.isBottom() || this.isTop()) {
            return;
        }
        ++this.refCount;
    }

    public void releaseRef() {
        if (this.isBottom() || this.isTop()) {
            return;
        }
        assert (this.refCount > 0);
        --this.refCount;
        if (this.refCount == 0) {
            this.remove();
        }
    }

    public Collection<Activation> getOverlappingInputActivations() {
        ArrayList<Activation> results = new ArrayList<Activation>();
        ArrayList<Range> tmp = new ArrayList<Range>();
        this.collectOverlapping(tmp, this, true, false, false, visitedCounter++);
        for (Range r : tmp) {
            results.addAll(r.inputActivations.values());
        }
        return results;
    }

    public void collect(List<Range> results, boolean dir, boolean includeFirst, long v) {
        if (this.inv) {
            return;
        }
        if (this.visitedCollect == v) {
            return;
        }
        this.visitedCollect = v;
        if (includeFirst && !this.inv) {
            results.add(this);
        }
        for (Range r : dir ? this.parents : this.children) {
            r.collect(results, dir, true, v);
        }
    }

    public void collectOverlapping(List<Range> results, Range r, boolean test, boolean includeAdjoined, boolean onlyAfter, long v) {
        this.visitedCollect = v;
        if (test && !Range.overlaps(this, r, includeAdjoined, onlyAfter)) {
            return;
        }
        results.add(this);
        for (Range c : this.children) {
            if (c.inv || c.visitedCollect == v) continue;
            c.collectOverlapping(results, r, false, includeAdjoined, onlyAfter, v);
        }
        for (Range p : this.parents) {
            if (p.inv || p.visitedCollect == v) continue;
            p.collectOverlapping(results, r, true, includeAdjoined, onlyAfter, v);
        }
    }

    public List<Range> select(Relation rr) {
        ArrayList<Range> results = new ArrayList<Range>();
        switch (rr) {
            case EQUALS: {
                results.add(this);
                break;
            }
            case CONTAINS: {
                this.collect(results, false, true, visitedCounter++);
                break;
            }
            case CONTAINED_IN: {
                this.collect(results, true, true, visitedCounter++);
                break;
            }
            case OVERLAPS: {
                this.collectOverlapping(results, this, true, false, false, visitedCounter++);
                break;
            }
            case OVERLAPS_INCLUDE_ADJOINED: {
                this.collectOverlapping(results, this, true, true, false, visitedCounter++);
                break;
            }
            case OVERLAPS_AFTER: {
                this.collectOverlapping(results, this, true, true, true, visitedCounter++);
                break;
            }
        }
        return results;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (int[] s : this.segments) {
            sb.append(this.doc.getContent().substring(Math.min(s[0], this.doc.length()), Math.min(s[1], this.doc.length())));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.segments.size() > 1) {
            sb.append("(");
        }
        for (int i = 0; i < this.segments.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("(");
            sb.append(this.segments.get(i)[0]);
            sb.append(",");
            sb.append(this.segments.get(i)[1]);
            sb.append(")");
        }
        if (this.segments.size() > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Range r) {
        for (int i = 0; i < this.segments.size() && i < r.segments.size(); ++i) {
            int[] sb;
            int[] sa = this.segments.get(i);
            int a = Integer.compare(sa[0], (sb = r.segments.get(i))[0]);
            if (a != 0) {
                return a;
            }
            int b = Integer.compare(sa[1], sb[1]);
            if (b == 0) continue;
            return b;
        }
        int c = Integer.compare(this.segments.size(), r.segments.size());
        return c;
    }

    public static enum Relation {
        EQUALS(true),
        CONTAINS(true),
        CONTAINED_IN(true),
        OVERLAPS(false),
        OVERLAPS_INCLUDE_ADJOINED(false),
        OVERLAPS_AFTER(false),
        BEFORE(false),
        AFTER(false),
        END_EQUALS(false),
        END_BEFORE(false),
        END_AFTER(false),
        BEGIN_EQUALS(false),
        BEGIN_BEFORE(false),
        BEGIN_AFTER(false);

        public final boolean supportsCollect;

        private Relation(boolean supportsCollect) {
            this.supportsCollect = supportsCollect;
        }

        public boolean compare(List<int[]> a, List<int[]> b) {
            switch (this) {
                case EQUALS: {
                    return SEGMENT_COMPARATOR.compare(a, b) == 0;
                }
                case CONTAINS: {
                    return Range.contains(a, b);
                }
                case CONTAINED_IN: {
                    return Range.contains(b, a);
                }
                case OVERLAPS: {
                    return Range.overlaps(a, b, false, false);
                }
                case OVERLAPS_INCLUDE_ADJOINED: {
                    return Range.overlaps(a, b, true, false);
                }
                case OVERLAPS_AFTER: {
                    return Range.overlaps(a, b, true, true);
                }
                case BEFORE: {
                    return Range.isBefore(a, b);
                }
                case AFTER: {
                    return Range.isBefore(b, a);
                }
                case END_BEFORE: {
                    return a.get(a.size() - 1)[1] < b.get(a.size() - 1)[1];
                }
                case END_AFTER: {
                    return a.get(a.size() - 1)[1] > b.get(a.size() - 1)[1];
                }
                case END_EQUALS: {
                    return a.get(a.size() - 1)[1] == b.get(a.size() - 1)[1];
                }
                case BEGIN_BEFORE: {
                    return a.get(0)[0] < b.get(0)[0];
                }
                case BEGIN_AFTER: {
                    return a.get(0)[0] > b.get(0)[0];
                }
                case BEGIN_EQUALS: {
                    return a.get(0)[0] == b.get(0)[0];
                }
            }
            return false;
        }

        public int estimateNodeCount(Range r) {
            switch (this) {
                case EQUALS: {
                    return 1;
                }
                case CONTAINS: {
                    return r.allParents;
                }
                case CONTAINED_IN: {
                    return r.allChildren;
                }
                case OVERLAPS: {
                    return r.allParents + r.allChildren;
                }
                case OVERLAPS_INCLUDE_ADJOINED: {
                    return r.allParents + r.allChildren;
                }
                case OVERLAPS_AFTER: {
                    return r.allParents + r.allChildren;
                }
            }
            return Integer.MAX_VALUE;
        }
    }
}

