/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network;

import java.util.ArrayList;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.ExpandNode;
import org.aika.corpus.Option;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.LatticeNode;

public class Iteration {
    public static final double WEIGHT_TOLERANCE = 0.01;
    public Document doc;
    public Model m;
    public Node.Queue queue = new Node.Queue();
    public TreeSet<AndNode> weightChanged = new TreeSet();
    public TreeSet<Node> hasActivations = new TreeSet();
    public TreeSet<Node> addedNodes = new TreeSet();
    public static int numberOfPositionsDelta;

    Iteration(Document doc, Model m) {
        this.doc = doc;
        this.m = m;
    }

    public void propagate() {
        this.queue.processChanges(this);
    }

    public void process() {
        double maxDelta;
        do {
            maxDelta = 0.0;
            for (Node n : this.hasActivations) {
                for (Activation act : n.getActivations()) {
                    maxDelta = Math.max(maxDelta, act.computeWeight());
                }
            }
        } while (maxDelta > 0.01);
        this.doc.top.computeWeights(Option.visitedCounter++);
        ExpandNode.computeSelectedOption(this.doc);
    }

    public void train() {
        this.m.numberOfPositions += numberOfPositionsDelta;
        numberOfPositionsDelta = 0;
        this.doc.selectedOption.count();
        for (Node node : this.hasActivations) {
            if (!node.frequencyHasChanged) continue;
            if (node instanceof AndNode && this.m.trainingInterval.contains(node.frequency)) {
                this.weightChanged.add((AndNode)node);
            }
            if (node.neuron == null) continue;
            node.neuron.propagateInputFrequencyChange(this);
        }
        this.propagate();
        for (Node node : new ArrayList<Node>(this.hasActivations)) {
            if (node instanceof LatticeNode && node.frequencyHasChanged) {
                ((LatticeNode)node).train(this);
            }
            node.frequencyHasChanged = false;
        }
        this.propagate();
        for (AndNode andNode : this.weightChanged) {
            andNode.computeWeight(this.m);
        }
    }

    public void clearActivations() {
        for (Node n : this.m.allNodes) {
            n.clearActivations();
        }
    }

    public void changeNumberOfPositions(int delta) {
        if (this.m.trainingInterval.contains(this.m.numberOfPositions + (numberOfPositionsDelta += delta))) {
            for (Node n : this.m.allNodes) {
                if (!(n instanceof AndNode)) continue;
                this.weightChanged.add((AndNode)n);
            }
        }
    }
}

