/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.Option;
import org.aika.network.Iteration;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.recurrent.ClockTerminationNode;
import org.aika.network.neuron.recurrent.RecurrentNeuron;
import org.aika.network.neuron.recurrent.RecurrentNode;
import org.aika.network.neuron.simple.SimpleNeuron;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.NegativeInputNode;
import org.aika.utils.StringUtils;

public class Model {
    public Set<Integer> trainingInterval;
    public Map<String, SimpleNeuron> labeledNeurons = new LinkedHashMap<String, SimpleNeuron>();
    public List<NegativeInputNode> negationNodes = new ArrayList<NegativeInputNode>();
    public List<ClockTerminationNode> clockTerminationNodes = new ArrayList<ClockTerminationNode>();
    public Set<Neuron> publishedNeurons = new TreeSet<Neuron>();
    public Set<Node> allNodes = new TreeSet<Node>();
    public int numberOfPositions;
    public static Comparator<Activation> ACTIVATIONS_OUTPUT_COMPARATOR = new Comparator<Activation>(){

        @Override
        public int compare(Activation act1, Activation act2) {
            int r = act1.key.pos.compareTo(act2.key.pos);
            if (r != 0) {
                return r;
            }
            r = act1.key.o.compareTo(act2.key.o);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(act1.key.fired, act2.key.fired);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(act1.key.n.id, act2.key.n.id);
            return r;
        }
    };

    public Model() {
        this.trainingInterval = new HashSet<Integer>();
        for (int i = 0; i < 10000; ++i) {
            double x = i;
            double y = Math.pow(x, 1.3);
            this.trainingInterval.add((int)Math.floor(y));
            if (i >= 10) continue;
            this.trainingInterval.add(i);
        }
    }

    public Iteration startIteration(Document doc) {
        Iteration t = new Iteration(doc, this);
        t.changeNumberOfPositions(1);
        ClockTerminationNode.addInitialActivations(t);
        return t;
    }

    public void dump() {
        System.out.println();
        System.out.println("Network Weights:");
        System.out.println(this.networkWeightsToString());
        System.out.println();
        System.out.println();
        System.out.println("Pattern Lattice:");
        System.out.println(this.patternLatticeToString());
        System.out.println();
        System.out.println("Publication Candidates:");
        ArrayList<AndNode> results = new ArrayList<AndNode>();
        for (Node n : this.allNodes) {
            if (!(n instanceof AndNode)) continue;
            AndNode an = (AndNode)n;
            if (!(an.weight > 0.99)) continue;
            results.add(an);
        }
        for (int i = 0; i < results.size(); ++i) {
            Node n;
            n = (AndNode)results.get(i);
            String syl = StringUtils.extractSyllable((AndNode)n);
            System.out.println(i + " \"" + syl + "\"  " + n.toString() + " ShouldBePublished:" + ((AndNode)n).shouldBePublished + (!((AndNode)n).shouldBePublished && ((AndNode)n).directSignificantAncestor != null ? " ( \"" + StringUtils.extractSyllable(((AndNode)n).directSignificantAncestor) + "\"  " + ((AndNode)n).directSignificantAncestor.toString() + ")" : ""));
        }
        System.out.println();
    }

    public static boolean hasSignificantChildren(AndNode n) {
        for (AndNode cn : n.andChildren.values()) {
            if (cn.weight > 0.99) {
                return true;
            }
            if (!Model.hasSignificantChildren(cn)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.labeledNeurons = new LinkedHashMap<String, SimpleNeuron>();
        this.negationNodes = new ArrayList<NegativeInputNode>();
        this.publishedNeurons = new HashSet<Neuron>();
    }

    public void resetFrequency() {
        for (Node n : this.allNodes) {
            n.frequency = 0;
        }
    }

    public String networkStateToString(Document doc, boolean allOrOnlySelectedOptions, boolean withWeights) {
        TreeSet<Activation> acts = new TreeSet<Activation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        for (Neuron n : this.publishedNeurons) {
            acts.addAll(Activation.select(n.node, null, null, null, allOrOnlySelectedOptions ? null : doc.selectedOption, Option.Relation.CONTAINED_IN, null, null, null, false));
        }
        StringBuilder sb = new StringBuilder();
        double weightSum = 0.0;
        for (Activation act : acts) {
            if (!allOrOnlySelectedOptions && act.newOption != null && !doc.selectedOption.contains(act.newOption) || act.key.n.neuron != null && "SPACE".equals(act.key.n.neuron.label)) continue;
            sb.append(act.key.pos);
            sb.append(" - ");
            if (allOrOnlySelectedOptions) {
                sb.append(act.key.o.toString());
                if (act.newOption != null) {
                    sb.append(act.newOption.toString());
                }
                sb.append(" - ");
            }
            sb.append(act.key.n.toString());
            sb.append(" - Rid:");
            sb.append(act.key.rid);
            sb.append(" - Fired:");
            sb.append(act.key.fired);
            if (withWeights) {
                sb.append(" - W:");
                sb.append(act.weight);
            }
            weightSum += act.weight;
            sb.append("\n");
        }
        sb.append("\nWeightSum:" + weightSum + "\n");
        return sb.toString();
    }

    public String networkWeightsToString() {
        StringBuilder sb = new StringBuilder();
        for (Neuron n : this.publishedNeurons) {
            if (n.node.frequency <= 0) continue;
            sb.append(n.toStringWithSynapses());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String patternLatticeToString() {
        StringBuilder sb = new StringBuilder();
        for (Node p : this.allNodes) {
            sb.append(p.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public SimpleNeuron createOrLookupInputSignal(String label) {
        return this.createOrLookupInputSignal(label, false);
    }

    public SimpleNeuron createOrLookupInputSignal(String label, boolean isBlocked) {
        SimpleNeuron n = this.labeledNeurons.get(label);
        if (n == null) {
            n = SimpleNeuron.create(this, new SimpleNeuron(label, isBlocked), -0.5, new TreeSet<Synapse>(), true, false);
            this.labeledNeurons.put(label, n);
        }
        return n;
    }

    public SimpleNeuron createAndNeuron(SimpleNeuron n, boolean inferenceMode, SimpleNeuron.Input ... inputs) {
        return this.createAndNeuron(n, inferenceMode, new TreeSet<SimpleNeuron.Input>(Arrays.asList(inputs)));
    }

    public SimpleNeuron createAndNeuron(SimpleNeuron n, boolean inferenceMode, Set<SimpleNeuron.Input> inputs) {
        n.m = this;
        TreeSet<Synapse> is = new TreeSet<Synapse>();
        double bias = 0.5;
        for (SimpleNeuron.Input ni : inputs) {
            Synapse s = new Synapse(ni.inputNeuron, ni.rid, ni.relative);
            if (!ni.isOptional) {
                s.w = ni.isNeg ? -1.0f : 1.0f;
                bias -= 1.0;
            }
            is.add(s);
        }
        return SimpleNeuron.create(this, n, bias, is, true, inferenceMode);
    }

    public SimpleNeuron createOrNeuron(SimpleNeuron n, SimpleNeuron.Input ... inputs) {
        return this.createOrNeuron(n, new TreeSet<SimpleNeuron.Input>(Arrays.asList(inputs)));
    }

    public SimpleNeuron createOrNeuron(SimpleNeuron n, Set<SimpleNeuron.Input> inputs) {
        n.m = this;
        n.isPredefined = true;
        TreeSet<Synapse> is = new TreeSet<Synapse>();
        double bias = -0.5;
        for (SimpleNeuron.Input ni : inputs) {
            Synapse s = new Synapse(ni.inputNeuron, ni.rid, ni.relative);
            s.w = ni.isNeg ? -1.0f : 1.0f;
            is.add(s);
        }
        SimpleNeuron.create(this, n, bias, is, true, false);
        return n;
    }

    public RecurrentNeuron createRecurrentNeuron(RecurrentNeuron n, Neuron inputSignal, Neuron clockSignal, Neuron terminationSignal, boolean direction, int maxLength) {
        n.m = this;
        n.isPredefined = true;
        Synapse is = null;
        if (inputSignal != null) {
            is = new Synapse(inputSignal, RecurrentNode.RecurrentType.INPUT_SIGNAL);
            is.w = 1.0f;
        }
        Synapse csSynapse = null;
        if (clockSignal != null) {
            csSynapse = new Synapse(clockSignal, RecurrentNode.RecurrentType.CLOCK_SIGNAL);
            csSynapse.w = 1.0f;
        }
        Synapse tsSynapse = null;
        if (terminationSignal != null) {
            tsSynapse = new Synapse(terminationSignal, RecurrentNode.RecurrentType.TERMINATION_SIGNAL);
            tsSynapse.w = 1.0f;
        }
        RecurrentNeuron.create(this, n, is, csSynapse, tsSynapse, direction, maxLength, true);
        return n;
    }
}

