/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.simple.lattice.InputNode;

public class Activation
implements Comparable<Activation> {
    public static double NEURON_WEIGHT = 0.4;
    public static double FORWARD_WEIGHT = 0.3;
    public static double BACKWARD_WEIGHT = 0.3;
    public final Key key;
    public boolean isRemoved;
    public int removedId;
    public static int removedIdCounter = 1;
    public double weight;
    public Option initialOption;
    public Option newOption;
    public Option completeOption;
    public Map<Key, Activation> shadows = new TreeMap<Key, Activation>();
    public Map<Key, Activation> shadowedBy = new TreeMap<Key, Activation>();
    public TreeSet<Activation> inputs = new TreeSet();
    public TreeSet<Activation> directInputs = new TreeSet();
    public Set<Activation> outputs = new TreeSet<Activation>();
    public TreeSet<Activation> directOutputs = new TreeSet();

    public Activation(Key key) {
        this.key = key;
    }

    public Activation(Node n, Range pos, int rid, Option o, int fired) {
        this.key = new Key(n, pos, rid, o, fired);
    }

    public Activation(Node n, Range pos, int rid, Option o, int fired, int id) {
        this.key = new Key(n, pos, rid, o, fired, id);
    }

    public boolean shadows(Activation act) {
        return act.completeOption.contains(this.completeOption) && this.key.fired <= act.key.fired && (act.completeOption.length != this.completeOption.length || this.key.fired != act.key.fired || this.key.id <= act.key.id);
    }

    public void addShadows(Activation act) {
        this.shadows.put(act.key, act);
        act.shadowedBy.put(this.key, this);
    }

    public List<int[]> getShadowedRange() {
        ArrayList<List<int[]>> r = new ArrayList<List<int[]>>();
        for (Key shadActKey : this.shadowedBy.keySet()) {
            r.add(shadActKey.pos.getSegments());
        }
        return Range.union(r);
    }

    public List<int[]> getNonShadowedRange() {
        return Range.complement(this.key.pos.getSegments(), this.getShadowedRange());
    }

    public void link(Collection<Activation> inputActs, Set<Activation> directInputActs, Set<Activation> outputActs, Set<Activation> directOutputActs) {
        for (Activation inputAct : inputActs) {
            inputAct.outputs.add(this);
        }
        for (Activation outputAct : outputActs) {
            outputAct.inputs.add(this);
        }
        for (Activation directInputAct : directInputActs) {
            directInputAct.directOutputs.add(this);
        }
        for (Activation directOutputAct : directOutputActs) {
            directOutputAct.directInputs.add(this);
        }
        this.inputs.addAll(inputActs);
        this.directInputs.addAll(directInputActs);
        this.outputs.addAll(outputActs);
        directOutputActs.addAll(directOutputActs);
    }

    public void unlink() {
        for (Activation act : this.inputs) {
            act.outputs.remove(this);
        }
        for (Activation act : this.outputs) {
            act.inputs.remove(this);
        }
        for (Activation act : this.directInputs) {
            act.directOutputs.remove(this);
        }
        for (Activation act : this.directOutputs) {
            act.directInputs.remove(this);
        }
    }

    public double computeWeight() {
        double forwardsWeight = this.key.n.computeForwardWeight(this);
        double maxBackwardsWeight = 0.0;
        for (Activation act : this.outputs) {
            if (!(maxBackwardsWeight < act.weight)) continue;
            maxBackwardsWeight = act.weight;
        }
        double newWeight = maxBackwardsWeight * BACKWARD_WEIGHT + forwardsWeight * FORWARD_WEIGHT + NEURON_WEIGHT * (this.key.n != null ? this.key.n.getNodeWeight(this) : 0.0);
        double delta = newWeight - this.weight;
        this.weight = newWeight;
        return delta;
    }

    public void register(Iteration t) {
        if (this.key.n.activations.isEmpty()) {
            t.hasActivations.add(this.key.n);
        }
        this.key.n.activations.put(this.key, this);
        if (this.key.o.activations == null) {
            this.key.o.activations = new TreeMap<Key, Activation>();
        }
        this.key.o.activations.put(this.key, this);
        if (this.completeOption.activationsComplete == null) {
            this.completeOption.activationsComplete = new TreeSet<Activation>();
        }
        this.completeOption.activationsComplete.add(this);
        if (this.key.n instanceof InputNode) {
            this.key.pos.inputActivations.put(this.key, this);
        }
        this.key.pos.activations.put(this.key, this);
    }

    public void unregister(Iteration t) {
        assert (!this.completeOption.activationsComplete.isEmpty());
        this.key.n.activations.remove(this.key);
        if (this.key.n.activations.isEmpty()) {
            t.hasActivations.remove(this.key.n);
            this.key.n.clearActivations();
        }
        this.key.o.activations.remove(this.key);
        this.completeOption.activationsComplete.remove(this);
        if (this.key.n instanceof InputNode) {
            this.key.pos.inputActivations.remove(this.key);
        }
        this.key.pos.activations.remove(this.key);
    }

    public double computeAverageInputWeight() {
        if (this.inputs.isEmpty()) {
            return 0.0;
        }
        double avgWeight = 0.0;
        for (Activation uAct : this.inputs) {
            avgWeight += uAct.weight;
        }
        return avgWeight / (double)this.inputs.size();
    }

    public static Activation get(Node n, Range r, Option o) {
        return Activation.get(n, 0, r, Range.Relation.OVERLAPS, o, Option.Relation.EQUALS, null, null, false);
    }

    public static Activation get(Node n, Integer rid, Range r, Range.Relation rr, Option o, Option.Relation or, Integer fired, Integer id, boolean includeShadowed) {
        Iterator<Activation> iterator = Activation.select(n, rid, r, rr, o, or, null, fired, id, includeShadowed).iterator();
        if (iterator.hasNext()) {
            Activation act = iterator.next();
            return act;
        }
        return null;
    }

    public static Activation get(Node n, Key ak) {
        return Activation.get(n, null, ak.pos, Range.Relation.CONTAINS, ak.o, Option.Relation.EQUALS, ak.fired, null, true);
    }

    public static List<Activation> select(Node n, Integer rid, Range r, Range.Relation rr, Option o, Option.Relation or, Option no, Integer fired, Integer id, boolean includeShadowed) {
        Key bk = new Key(n != null ? n : Node.MIN_NODE, rr == Range.Relation.EQUALS ? r : Range.MIN, rid != null ? rid : Integer.MIN_VALUE, or == Option.Relation.EQUALS ? o : Option.MIN, fired != null ? fired : Integer.MIN_VALUE, id != null ? id : Integer.MIN_VALUE);
        Key ek = new Key(n != null ? n : Node.MAX_NODE, rr == Range.Relation.EQUALS ? r : Range.MAX, rid != null ? rid : Integer.MAX_VALUE, or == Option.Relation.EQUALS ? o : Option.MAX, fired != null ? fired : Integer.MAX_VALUE, id != null ? id : Integer.MAX_VALUE);
        ArrayList<Activation> results = new ArrayList<Activation>();
        if (r != null && rr.supportsCollect && rr.estimateNodeCount(r) < n.activations.size()) {
            for (Range rn : r.select(rr)) {
                for (Activation act : rn.activations.subMap(bk, true, ek, true).values()) {
                    if (!act.filter(n, rid, r, rr, o, or, no, fired, id, includeShadowed)) continue;
                    results.add(act);
                }
            }
        } else if (n != null) {
            for (Activation act : n.activations.subMap(bk, true, ek, true).values()) {
                if (!act.filter(n, rid, r, rr, o, or, no, fired, id, includeShadowed)) continue;
                results.add(act);
            }
        } else if (o != null) {
            for (Option on : o.select(or)) {
                for (Activation act : on.activations.subMap(bk, true, ek, true).values()) {
                    if (!act.filter(n, rid, r, rr, o, or, no, fired, id, includeShadowed)) continue;
                    results.add(act);
                }
            }
        } else assert (false);
        return results;
    }

    private boolean filter(Node n, Integer rid, Range r, Range.Relation rr, Option o, Option.Relation or, Option no, Integer fired, Integer id, boolean includeShadowed) {
        List<int[]> cr = r != null ? (includeShadowed ? this.key.pos.getSegments() : this.getNonShadowedRange()) : null;
        return !(n == null && this.key.n != n || rid != null && this.key.rid != rid || r != null && (cr.isEmpty() || !rr.compare(cr, r.getSegments())) || o != null && !or.compare(this.key.o, o) || no != null && no != this.newOption || fired != null && this.key.fired != fired || id != null && this.key.id != id);
    }

    public String toString(Document doc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ACT ");
        sb.append(",(");
        sb.append(this.key.pos);
        sb.append("),");
        sb.append(doc.getContent().substring(Math.max(0, this.key.pos.getBegin() - 3), Math.min(doc.length(), this.key.pos.getEnd() + 3)));
        sb.append(",");
        sb.append(this.key.n);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(Activation act) {
        int r;
        if (this.key.n == null && act.key.n != null) {
            return -1;
        }
        if (this.key.n != null && act.key.n == null) {
            return 1;
        }
        if (this.key.n != null && act.key.n != null && (r = this.key.n.compareTo(act.key.n)) != 0) {
            return r;
        }
        return this.key.compareTo(act.key);
    }

    public static final class Key
    implements Comparable<Key> {
        public final Node n;
        public final Range pos;
        public final int rid;
        public final Option o;
        public final int fired;
        public final int id;
        private int refCount = 0;

        public Key(Node n, Range pos, int rid, Option o, int fired) {
            this(n, pos, rid, o, fired, 0);
        }

        public Key(Node n, Range pos, int rid, Option o, int fired, int id) {
            assert (pos == null || pos.isGapLess());
            this.n = n;
            this.pos = pos;
            this.rid = rid;
            this.o = o;
            this.fired = fired;
            this.id = id;
            this.countRef();
            if (o != null) {
                o.countRef();
            }
        }

        public void countRef() {
            ++this.refCount;
        }

        public void releaseRef() {
            assert (this.refCount > 0);
            --this.refCount;
            if (this.refCount == 0) {
                this.o.releaseRef();
            }
        }

        @Override
        public int compareTo(Key k) {
            int r = this.n.compareTo(k.n);
            if (r != 0) {
                return r;
            }
            r = this.pos.compareTo(k.pos);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.rid, k.rid);
            if (r != 0) {
                return r;
            }
            r = this.o.compareTo(k.o);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.fired, k.fired);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.id, k.id);
        }

        public String toString() {
            return this.pos + " " + this.rid + " " + this.o + " " + this.fired + " " + this.id;
        }
    }
}

