/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Input;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.InputNode;
import org.aika.network.neuron.simple.lattice.NegativeInputNode;
import org.aika.network.neuron.simple.lattice.PositiveInputNode;

public class Neuron
implements Comparable<Neuron> {
    public Model m;
    public static final int MAX_RECURRENT_ACTIVATIONS = 10;
    public static int currentNeuronId = 0;
    public int id = currentNeuronId++;
    public String label;
    public double bias;
    public SortedMap<Neuron, Synapse> inputSynapses = new TreeMap<Neuron, Synapse>();
    public SortedMap<Neuron, Synapse> outputSynapses = new TreeMap<Neuron, Synapse>();
    public SortedMap<Input.InputKey, Input> outputNodes = new TreeMap<Input.InputKey, Input>();
    public Node node;
    public boolean inferenceMode;
    public boolean isPredefined;
    public boolean isPublished;
    public boolean isBlocked;

    public Neuron() {
    }

    public Neuron(String label) {
        this.label = label;
    }

    public Neuron(String label, boolean isBlocked) {
        this.label = label;
        this.isBlocked = isBlocked;
    }

    public void publish(Model m) {
        m.publishedNeurons.add(this);
        InputNode.add(m, null, this, false);
    }

    public void unpublish() {
        this.m.publishedNeurons.remove(this);
        for (Input out : this.outputNodes.values()) {
            out.remove(this.m);
        }
    }

    public PositiveInputNode getPositiveOutputNode(Integer rid) {
        return (PositiveInputNode)this.outputNodes.get(new Input.InputKey(0, rid));
    }

    public NegativeInputNode getNegativeOutputNode(Integer rid) {
        return (NegativeInputNode)this.outputNodes.get(new Input.InputKey(1, rid));
    }

    public void addInputActivation(Iteration t, int begin, int end) {
        Range r = Range.create(t.doc, begin, end);
        Node.addActivationAndPropagate(t, false, new Activation.Key(this.node, r, 0, t.doc.bottom, 0), r, null, Collections.EMPTY_SET, Collections.EMPTY_SET);
        t.propagate();
    }

    public void addInputActivation(Iteration t, int begin, int end, Option o) {
        Range r = Range.create(t.doc, begin, end);
        Node.addActivationAndPropagate(t, false, new Activation.Key(this.node, r, 0, o, 0), r, null, Collections.EMPTY_SET, Collections.EMPTY_SET);
        t.propagate();
    }

    public void removeInputActivation(Iteration t, int begin, int end) {
        Range r = Range.create(t.doc, begin, end);
        Node.removeActivationAndPropagate(t, false, new Activation(new Activation.Key(this.node, r, 0, t.doc.bottom, 0)), r);
        t.propagate();
    }

    public void removeInputActivation(Iteration t, int begin, int end, Option o) {
        Range r = Range.create(t.doc, begin, end);
        Node.removeActivationAndPropagate(t, false, new Activation(new Activation.Key(this.node, r, 0, o, 0)), r);
        t.propagate();
    }

    public void propagateAddedActivation(Iteration t, Activation act, Range addedRange) {
        for (Input out : this.outputNodes.values()) {
            out.addActivation(t, act, addedRange);
        }
    }

    public void propagateRemovedActivation(Iteration t, Activation act, Range removedRange) {
        for (Input out : this.outputNodes.values()) {
            out.removeActivation(t, act, removedRange);
        }
    }

    public void propagateInputFrequencyChange(Iteration t) {
        for (Input i : this.outputNodes.subMap(new Input.InputKey(0, Integer.MIN_VALUE), new Input.InputKey(1, Integer.MAX_VALUE)).values()) {
            InputNode in = (InputNode)i;
            if (!this.m.trainingInterval.contains(in.frequency)) continue;
            for (AndNode n : in.getAndChildPatterns(new HashSet<AndNode>())) {
                t.weightChanged.add(n);
            }
        }
    }

    public void remove() {
        this.unpublish();
        for (Synapse is : this.inputSynapses.values()) {
            is.input.outputSynapses.remove(is.output);
        }
        for (Synapse is : this.outputSynapses.values()) {
            is.output.inputSynapses.remove(is.input);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("N(");
        sb.append(this.id);
        if (this.label != null) {
            sb.append(",");
            sb.append(this.label);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toStringWithSynapses() {
        TreeSet<Synapse> is = new TreeSet<Synapse>(new Comparator<Synapse>(){

            @Override
            public int compare(Synapse s1, Synapse s2) {
                int r = Float.compare(s2.w, s1.w);
                if (r != 0) {
                    return r;
                }
                return Integer.compare(s1.input.id, s2.input.id);
            }
        });
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("<");
        sb.append("B:");
        sb.append(this.bias);
        sb.append(", ");
        for (Synapse s : is) {
            sb.append(s.w);
            sb.append(":");
            sb.append(s.input.toString());
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(Neuron n) {
        if (this.id < n.id) {
            return -1;
        }
        if (this.id > n.id) {
            return 1;
        }
        return 0;
    }
}

