/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.recurrent.ClockTerminationNode;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.NegativeInputNode;

public abstract class Node
implements Comparable<Node> {
    public static int minFrequency = 5;
    public static final Node MIN_NODE = new DummyNode(0);
    public static final Node MAX_NODE = new DummyNode(Integer.MAX_VALUE);
    public static int currentNodeId = 0;
    public int id;
    public int level;
    public double weight = 0.0;
    public int frequency;
    public boolean countingMode;
    public boolean isPredefined;
    public boolean isBlocked;
    public boolean isRemoved;
    public int isRemovedId;
    public static int isRemovedIdCounter = 0;
    public boolean frequencyHasChanged = true;
    public int n;
    public NavigableMap<Activation.Key, Activation> activations = new TreeMap<Activation.Key, Activation>(new Comparator<Activation.Key>(){

        @Override
        public int compare(Activation.Key k1, Activation.Key k2) {
            int r;
            if (k1.pos != k2.pos) {
                if (k1.pos == null) {
                    return -1;
                }
                if (k2.pos == null) {
                    return 1;
                }
                r = k1.pos.compareTo(k2.pos);
                if (r != 0) {
                    return r;
                }
            }
            if ((r = Integer.compare(k1.rid, k2.rid)) != 0) {
                return r;
            }
            if (k1.o != k2.o) {
                if (k1.o == null) {
                    return -1;
                }
                if (k2.o == null) {
                    return 1;
                }
                r = k1.o.compareTo(k2.o);
                if (r != 0) {
                    return r;
                }
            }
            if ((r = Integer.compare(k1.fired, k2.fired)) != 0) {
                return r;
            }
            return Integer.compare(k1.id, k2.id);
        }
    });
    public NavigableMap<ChangeKey, Set<Activation>[]> added = new TreeMap<ChangeKey, Set<Activation>[]>();
    public NavigableMap<ChangeKey, RemovedEntry> removed = new TreeMap<ChangeKey, RemovedEntry>();
    public boolean isQueued = false;
    public Neuron neuron = null;
    public static long visitedCounter = 0L;

    public abstract boolean isAllowedOption(Option var1, Activation var2, long var3);

    public abstract boolean isNegative();

    public abstract boolean containsNegative();

    public abstract void cleanup(Model var1);

    public abstract void initActivation(Iteration var1, Activation var2);

    public abstract void deleteActivation(Iteration var1, Activation var2);

    public abstract double computeForwardWeight(Activation var1);

    public abstract double getNodeWeight(Activation var1);

    public abstract double computeSynapseWeightSum(Neuron var1);

    public abstract String logicToString();

    private Node() {
    }

    public Node(Model m, int level) {
        this.id = currentNodeId++;
        this.level = level;
        m.allNodes.add(this);
    }

    public Option retrieveInitialOption(Range r, Integer rid, Option o) {
        Iterator<ChangeKey> iterator = this.added.subMap(new ChangeKey(rid, o, 0, 0, r, null), new ChangeKey(rid, o, Integer.MAX_VALUE, Integer.MAX_VALUE, r, Option.MAX)).keySet().iterator();
        if (iterator.hasNext()) {
            ChangeKey ck = iterator.next();
            return ck.initOption;
        }
        return null;
    }

    public void countActivation(Activation.Key ak, Option so) {
        int delta = 1;
        if (!this.countingMode) {
            for (Activation secondAct : Activation.select(this, 0, ak.pos, Range.Relation.OVERLAPS_AFTER, so, Option.Relation.CONTAINS, null, null, null, false)) {
                if (secondAct.key == ak) continue;
                --delta;
                break;
            }
        }
        this.frequency += delta;
        this.frequencyHasChanged = true;
    }

    public Activation addActivationInternal(Iteration t, Activation.Key ak, Option initOption, Option newOption, Set<Activation> inputActs, Set<Activation> directInputActs, Set<Activation> outputActs, Set<Activation> directOutputActs) {
        Activation act = new Activation(ak);
        act.initialOption = initOption;
        act.newOption = newOption;
        act.completeOption = newOption != null ? Option.add(t.doc, false, ak.o, newOption) : ak.o;
        act.link(inputActs, directInputActs, outputActs, directOutputActs);
        for (Activation oa : Activation.select(this, ak.rid, ak.pos, Range.Relation.OVERLAPS, null, null, null, null, null, true)) {
            if (oa.shadows(act)) {
                oa.addShadows(act);
            }
            if (!act.shadows(oa)) continue;
            act.addShadows(oa);
        }
        this.initActivation(t, act);
        act.register(t);
        return act;
    }

    private void processChanges(Iteration t) {
        NavigableMap<ChangeKey, Set<Activation>[]> tmpAdded = this.added;
        NavigableMap<ChangeKey, RemovedEntry> tmpRemoved = this.removed;
        this.added = new TreeMap<ChangeKey, Set<Activation>[]>();
        this.removed = new TreeMap<ChangeKey, RemovedEntry>();
        if (!(this instanceof ClockTerminationNode)) {
            Iterator it = tmpRemoved.entrySet().iterator();
            while (it.hasNext()) {
                ChangeKey changeKey = (ChangeKey)it.next().getKey();
                boolean remove = false;
                for (ChangeKey cka : tmpAdded.keySet()) {
                    if (cka.o != changeKey.o || cka.rid != changeKey.rid || cka.fired != changeKey.fired || cka.id != changeKey.id || !cka.r.contains(changeKey.r)) continue;
                    remove = true;
                }
                if (!remove) continue;
                it.remove();
            }
        }
        for (RemovedEntry removedEntry : tmpRemoved.values()) {
            this.processRemovedActivations(t, removedEntry.act, removedEntry.removedRange);
        }
        for (Map.Entry entry : tmpAdded.entrySet()) {
            this.processAddedActivations(t, (ChangeKey)entry.getKey(), ((Set[])entry.getValue())[0], ((Set[])entry.getValue())[1]);
        }
    }

    public static void addActivationAndPropagate(Iteration t, boolean processFirst, Activation.Key ak, Range addedRange, Option initOption, Set<Activation> inputActs, Set<Activation> directInputActs) {
        if (addedRange.isEmpty()) {
            return;
        }
        ChangeKey ck = new ChangeKey(ak.rid, ak.o, ak.fired, ak.id, addedRange, initOption);
        Set[] iActs = (Set[])ak.n.added.get(ck);
        if (iActs == null) {
            iActs = new Set[]{new TreeSet(), new TreeSet()};
            ak.n.added.put(ck, iActs);
        }
        iActs[0].addAll(inputActs);
        iActs[1].addAll(directInputActs);
        t.queue.add(ak.n, processFirst);
    }

    public void processAddedActivations(Iteration t, ChangeKey ck, Set<Activation> inputActs, Set<Activation> directInputActs) {
        TreeSet<Activation> iActs = new TreeSet<Activation>(inputActs);
        TreeSet<Activation> diActs = new TreeSet<Activation>(directInputActs);
        TreeSet<Activation> oActs = new TreeSet<Activation>();
        TreeSet<Activation> doActs = new TreeSet<Activation>();
        Option no = this.computeNewOption(t.doc, ck.initOption, directInputActs);
        List<Activation> oldActs = Activation.select(this, ck.rid, ck.r, this.countingMode ? Range.Relation.OVERLAPS : Range.Relation.OVERLAPS_INCLUDE_ADJOINED, ck.o, Option.Relation.EQUALS, no, ck.fired, ck.id, true);
        for (Activation activation : oldActs) {
            iActs.addAll(activation.inputs);
            diActs.addAll(activation.directInputs);
            oActs.addAll(activation.outputs);
            doActs.addAll(activation.directOutputs);
        }
        Range r = this.extractUncoveredRange(t.doc, ck.r, oldActs);
        for (Activation oldAct : oldActs) {
            this.removeActivationInternal(t, oldAct.key);
        }
        Activation activation = this.addActivationInternal(t, this.computeNewActivationKey(t.doc, ck, oldActs), ck.initOption, no, iActs, diActs, oActs, doActs);
        Range outputRange = Range.create(t.doc, Range.intersection(r.getSegments(), activation.getNonShadowedRange()));
        if (!outputRange.isEmpty()) {
            this.propagateAddedActivation(t, activation, outputRange, null);
        }
        for (Activation shadAct : activation.shadows.values()) {
            Range shadowedRange = shadAct.key.pos.intersection(activation.key.pos);
            for (Activation sbAct : shadAct.shadowedBy.values()) {
                if (sbAct == activation) continue;
                shadowedRange = shadowedRange.complement(sbAct.key.pos);
            }
            this.propagateRemovedActivation(t, shadAct, shadowedRange);
        }
    }

    private Option computeNewOption(Document doc, Option initOption, Set<Activation> directInputActs) {
        if (!(this instanceof AndNode) && !(this instanceof ClockTerminationNode)) {
            return null;
        }
        ArrayList<Option> tmp = new ArrayList<Option>();
        if (initOption != null) {
            tmp.add(initOption);
        }
        for (Activation iAct : directInputActs) {
            if (iAct.newOption == null) continue;
            tmp.add(iAct.newOption);
        }
        return Option.add(doc, false, tmp.toArray(new Option[tmp.size()]));
    }

    private Activation.Key computeNewActivationKey(Document doc, ChangeKey ck, Collection<Activation> acts) {
        int b = Integer.MAX_VALUE;
        int e = 0;
        for (Activation act : acts) {
            b = Math.min(b, act.key.pos.getBegin());
            e = Math.max(e, act.key.pos.getEnd());
        }
        return new Activation.Key(this, Range.create(doc, Math.min(ck.r.getBegin(), b), Math.max(ck.r.getEnd(), e)), ck.rid, ck.o, ck.fired, ck.id);
    }

    private Range extractUncoveredRange(Document doc, Range newRange, Collection<Activation> acts) {
        ArrayList<Range> r = new ArrayList<Range>();
        for (Activation act : acts) {
            r.add(act.key.pos);
        }
        return newRange.complement(Range.add(doc, r.toArray(new Range[r.size()])));
    }

    public Activation removeActivationInternal(Iteration t, Activation.Key ak) {
        Activation act = (Activation)this.activations.get(ak);
        if (act == null) {
            return null;
        }
        act.unlink();
        this.deleteActivation(t, act);
        act.unregister(t);
        act.removedId = Activation.removedIdCounter++;
        act.isRemoved = true;
        if (!(this instanceof NegativeInputNode)) {
            for (Activation shadAct : act.shadowedBy.values()) {
                shadAct.shadows.remove(act.key);
            }
            for (Activation shadAct : act.shadows.values()) {
                shadAct.shadowedBy.remove(act.key);
            }
        }
        return act;
    }

    public static void removeActivationAndPropagate(Iteration t, boolean processFirst, Activation act, Range removedRange) {
        if (removedRange.isEmpty()) {
            return;
        }
        if (act == null) {
            return;
        }
        ChangeKey ck = new ChangeKey(act.key.rid, act.key.o, act.key.fired, act.key.id, act.key.pos, null);
        RemovedEntry re = (RemovedEntry)act.key.n.removed.get(ck);
        if (re == null) {
            re = new RemovedEntry();
            re.act = act;
            re.removedRange = removedRange;
            act.key.n.removed.put(ck, re);
            t.queue.add(act.key.n, processFirst);
        } else {
            assert (re.act == act);
            re.removedRange = Range.add(t.doc, re.removedRange, removedRange);
        }
    }

    public void processRemovedActivations(Iteration t, Activation act, Range removedRange) {
        if (act.isRemoved) {
            return;
        }
        Activation.Key ak = act.key;
        Range remainingRange = ak.pos.complement(removedRange);
        this.removeActivationInternal(t, ak);
        for (int[] seg : remainingRange.getSegments()) {
            Range r = Range.create(t.doc, seg);
            this.addActivationInternal(t, new Activation.Key(this, r, ak.rid, ak.o, ak.fired, ak.id), act.initialOption, act.newOption, this.filterInputsAndOutputs(act, r, act.inputs), this.filterInputsAndOutputs(act, r, act.directInputs), this.filterInputsAndOutputs(act, r, act.outputs), this.filterInputsAndOutputs(act, r, act.directOutputs));
        }
        Range outputRange = Range.create(t.doc, Range.intersection(removedRange.getSegments(), act.getNonShadowedRange()));
        if (!outputRange.isEmpty()) {
            this.propagateRemovedActivation(t, act, outputRange);
        }
        for (Activation shadAct : act.shadows.values()) {
            Range shadowedRange = shadAct.key.pos.intersection(removedRange);
            for (Activation sbAct : shadAct.shadowedBy.values()) {
                if (sbAct == act) continue;
                shadowedRange = shadowedRange.complement(sbAct.key.pos);
            }
            this.propagateAddedActivation(t, shadAct, shadowedRange, null);
        }
        act.key.releaseRef();
    }

    private Set<Activation> filterInputsAndOutputs(Activation act, Range r, Set<Activation> io) {
        TreeSet<Activation> results = new TreeSet<Activation>();
        for (Activation actIO : io) {
            if (actIO.key.rid == act.key.rid && !Range.overlaps(r, actIO.key.pos, false, false)) continue;
            results.add(actIO);
        }
        return results;
    }

    public void propagateAddedActivation(Iteration t, Activation act, Range addedRange, Option conflict) {
        if (this.neuron != null && (conflict == null || act.initialOption != null && act.completeOption.contains(conflict))) {
            this.neuron.propagateAddedActivation(t, act, addedRange);
        }
    }

    public void propagateRemovedActivation(Iteration t, Activation act, Range removedRange) {
        if (this.neuron != null) {
            this.neuron.propagateRemovedActivation(t, act, removedRange);
        }
    }

    public Collection<Activation> getActivations() {
        return this.activations.values();
    }

    public Collection<Activation> getSelectedActivations(Document doc) {
        ArrayList<Activation> results = new ArrayList<Activation>();
        for (Activation act : this.activations.values()) {
            if (!doc.isSelected(act)) continue;
            results.add(act);
        }
        return results;
    }

    public Activation getFirstActivation() {
        if (this.activations.isEmpty()) {
            return null;
        }
        return this.activations.firstEntry().getValue();
    }

    public void clearActivations() {
        for (Activation act : this.activations.values()) {
            act.unlink();
            act.key.releaseRef();
        }
        this.activations.clear();
    }

    public boolean isFrequentOrPredefined(int freq) {
        if (this.isPredefined) {
            return true;
        }
        return freq >= minFrequency;
    }

    public boolean isFrequentOrPredefined() {
        if (this.isPredefined) {
            return true;
        }
        return this.frequency >= minFrequency;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toSimpleString());
        sb.append(" - ");
        sb.append(this.logicToString());
        return sb.toString();
    }

    public String toSimpleString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        if (this.neuron != null && this.neuron.label != null) {
            sb.append(" ");
            sb.append(this.neuron.label);
        }
        sb.append(" (Freq:");
        sb.append(this.frequency);
        sb.append(", W:");
        sb.append(this.weight);
        if (this instanceof AndNode) {
            AndNode an = (AndNode)this;
            sb.append(", MPR:");
            sb.append(an.minPRelevance);
        }
        sb.append(", N:");
        sb.append(this.n);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(Node n) {
        if (this.id < n.id) {
            return -1;
        }
        if (this.id > n.id) {
            return 1;
        }
        return 0;
    }

    public static int compare(Node a, Node b) {
        if (a == b) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    private static class DummyNode
    extends Node {
        public DummyNode(int id) {
            this.id = id;
        }

        @Override
        public boolean isAllowedOption(Option n, Activation act, long v) {
            return false;
        }

        @Override
        public boolean isNegative() {
            return false;
        }

        @Override
        public boolean containsNegative() {
            return false;
        }

        @Override
        public void cleanup(Model m) {
        }

        @Override
        public void initActivation(Iteration t, Activation act) {
        }

        @Override
        public void deleteActivation(Iteration t, Activation act) {
        }

        @Override
        public double computeForwardWeight(Activation act) {
            return 0.0;
        }

        @Override
        public double getNodeWeight(Activation act) {
            return 0.0;
        }

        @Override
        public double computeSynapseWeightSum(Neuron n) {
            return 0.0;
        }

        @Override
        public String logicToString() {
            return null;
        }
    }

    private static class RemovedEntry {
        Activation act;
        Range removedRange;

        private RemovedEntry() {
        }
    }

    private static class ChangeKey
    implements Comparable<ChangeKey> {
        int rid;
        Option o;
        int fired;
        int id;
        Range r;
        Option initOption;

        public ChangeKey(int rid, Option o, int fired, int id, Range r, Option initOption) {
            this.rid = rid;
            this.o = o;
            this.fired = fired;
            this.id = id;
            this.r = r;
            this.initOption = initOption;
        }

        @Override
        public int compareTo(ChangeKey ck) {
            int c = this.r.compareTo(ck.r);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(ck.rid, this.rid);
            if (c != 0) {
                return c;
            }
            c = this.o.compareTo(ck.o);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.fired, ck.fired);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.id, ck.id);
            if (c != 0) {
                return c;
            }
            return Option.compare(this.initOption, ck.initOption);
        }
    }

    public static class Queue {
        public final TreeSet<Entry> queue = new TreeSet();
        private long queueIdCounter = 0L;

        public void add(Node n, boolean processFirst) {
            if (!n.isQueued) {
                long l;
                n.isQueued = true;
                if (processFirst && !this.queue.isEmpty()) {
                    l = this.queue.first().queueId;
                } else {
                    long l2 = this.queueIdCounter;
                    l = l2;
                    this.queueIdCounter = l2 + 1L;
                }
                this.queue.add(new Entry(l, n.level, n));
            }
        }

        public void processChanges(Iteration t) {
            while (!this.queue.isEmpty()) {
                Entry e = this.queue.pollFirst();
                e.n.isQueued = false;
                e.n.processChanges(t);
            }
        }

        private static class Entry
        implements Comparable<Entry> {
            long queueId;
            int level;
            Node n;

            public Entry(long queueId, int level, Node n) {
                this.queueId = queueId;
                this.level = level;
                this.n = n;
            }

            @Override
            public int compareTo(Entry k) {
                int r = Long.compare(this.queueId, k.queueId);
                if (r != 0) {
                    return r;
                }
                r = Integer.compare(this.level, k.level);
                if (r != 0) {
                    return r;
                }
                return this.n.compareTo(k.n);
            }
        }
    }
}

