/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.recurrent;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.recurrent.ClockNode;
import org.aika.network.neuron.recurrent.InputNode;
import org.aika.network.neuron.recurrent.OutputNode;
import org.aika.network.neuron.recurrent.RecurrentNode;
import org.aika.network.neuron.recurrent.TerminationNode;
import org.aika.utils.SetUtils;

public class ClockTerminationNode
extends RecurrentNode {
    public ClockNode clockNode;
    public TerminationNode terminationNode;
    public Map<InputNode, OutputNode> outputNodes = new TreeMap<InputNode, OutputNode>();
    public Map<InputNode, OutputNode> outputNodesWithinDocument = new TreeMap<InputNode, OutputNode>();

    @Override
    public double computeForwardWeight(Activation act) {
        return 0.0;
    }

    @Override
    public double getNodeWeight(Activation act) {
        return this.weight;
    }

    public ClockTerminationNode(Model m, boolean direction) {
        super(m, 1);
        this.countingMode = true;
        this.direction = direction;
    }

    public Collection<OutputNode> getChildren() {
        return this.outputNodes.values();
    }

    private void addActivationFromClockOrTerminationNode(Iteration t, Activation inputAct) {
        TreeSet<Activation> tmp = new TreeSet<Activation>();
        for (Activation act : Activation.select(this, null, inputAct.key.pos, Range.Relation.OVERLAPS, null, null, null, null, null, false)) {
            if (inputAct.key.pos.getEnd(((RecurrentNode)inputAct.key.n).direction) == act.key.pos.getEnd(this.direction)) continue;
            if (act.key.o.contains(inputAct.key.o)) {
                tmp.add(act);
                continue;
            }
            if (!inputAct.key.o.contains(act.key.o)) continue;
            boolean covered = false;
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                Activation tAct = (Activation)it.next();
                if (act.key.o.contains(tAct.key.o)) {
                    it.remove();
                    continue;
                }
                if (!tAct.key.o.contains(act.key.o)) continue;
                covered = true;
            }
            if (covered) continue;
            tmp.add(act);
        }
        for (Activation act : tmp) {
            TreeSet<Activation> inputs = new TreeSet<Activation>();
            ClockTerminationNode.addInput(inputs, this.getBeginSignal(act));
            ClockTerminationNode.addInput(inputs, this.getPreviousAct(act));
            inputs.add(inputAct);
            Range r = Range.create(t.doc, act.key.pos.getBegin(this.direction), inputAct.key.pos.getEnd(((RecurrentNode)inputAct.key.n).direction));
            if (r != t.doc.bottomRange) {
                ClockTerminationNode.addActivationAndPropagate(t, true, new Activation.Key(this, r, act.key.rid, act.key.o, 0), r, act.initialOption, inputs, inputs);
            }
            ClockTerminationNode.removeActivationAndPropagate(t, true, act, act.key.pos);
        }
        if (inputAct.key.n instanceof TerminationNode) {
            this.addNextSegment(t, inputAct.key.pos.getEnd(((RecurrentNode)inputAct.key.n).direction), 0, inputAct.key.o, inputAct.newOption, inputAct);
        }
    }

    private static void addInput(Set<Activation> inputs, Activation iAct) {
        if (iAct != null) {
            inputs.add(iAct);
        }
    }

    private void removeActivationFromClockOrTerminationNode(Iteration t, Activation inputAct) {
        for (Activation act : inputAct.outputs) {
            if (act.key.pos.getEnd(this.direction) == inputAct.key.pos.getEnd(((RecurrentNode)inputAct.key.n).direction)) {
                this.addNextSegment(t, act.key.pos.getBegin(this.direction), act.key.rid, act.key.o, act.newOption, act.inputs.toArray(new Activation[act.inputs.size()]));
                ClockTerminationNode.removeActivationAndPropagate(t, true, act, act.key.pos);
                continue;
            }
            if (act.key.pos.getBegin(this.direction) != inputAct.key.pos.getEnd(((RecurrentNode)inputAct.key.n).direction) || inputAct.key.o != act.key.o || inputAct.key.n != this.terminationNode) continue;
            ClockTerminationNode.removeActivationAndPropagate(t, true, act, act.key.pos);
        }
    }

    private void addActivationCTNode(Iteration t, Activation inputAct) {
        if (this.getTerminationSignal(inputAct) != null) {
            return;
        }
        Activation beginSignal = this.getEndSignal(inputAct);
        if (beginSignal == null) {
            return;
        }
        if (inputAct.key.o.contains(beginSignal.key.o)) {
            this.addNextSegment(t, inputAct.key.pos.getEnd(this.direction), inputAct.key.rid + 1, inputAct.key.o, inputAct.newOption, inputAct, beginSignal);
        } else {
            boolean covered = false;
            for (Activation altPathAct : Activation.select(this, null, inputAct.key.pos, this.direction ? Range.Relation.BEGIN_EQUALS : Range.Relation.END_EQUALS, inputAct.key.o, Option.Relation.CONTAINS, null, null, null, true)) {
                if (inputAct == altPathAct || !beginSignal.key.o.contains(altPathAct.key.o)) continue;
                covered = true;
            }
            Option no = null;
            if (!covered) {
                no = Option.addPrimitive(t.doc, beginSignal.key.pos.getEnd(((RecurrentNode)beginSignal.key.n).direction));
                Conflicts.add(t, this, no, beginSignal.key.o);
                if (beginSignal.key.n instanceof ClockNode) {
                    this.addNextSegment(t, beginSignal.key.pos.getEnd(((RecurrentNode)beginSignal.key.n).direction), inputAct.key.rid + 1, beginSignal.key.o, inputAct.newOption, inputAct, beginSignal);
                }
            }
            this.addNextSegment(t, inputAct.key.pos.getEnd(this.direction), inputAct.key.rid, inputAct.key.o, Option.add(t.doc, true, inputAct.newOption, no), inputAct, beginSignal);
        }
    }

    private void addNextSegment(Iteration t, int signalPos, int rid, Option o, Option no, Activation ... inputs) {
        Signal ns = this.getSignal(t.doc, signalPos, o);
        Range r = Range.create(t.doc, signalPos, ns.pos);
        SortedSet<Activation> inputsSet = SetUtils.asSortedSet(inputs);
        inputsSet.addAll(ns.acts);
        Node.addActivationAndPropagate(t, true, new Activation.Key(this, r, rid, o, 0), r, no, inputsSet, inputsSet);
    }

    private void removeActivationCTNode(Iteration t, Activation inputAct) {
        for (Activation act : inputAct.outputs) {
            if (act.key.n != this) continue;
            ClockTerminationNode.removeActivationAndPropagate(t, true, act, act.key.pos);
        }
    }

    @Override
    public void addActivation(Iteration t, Activation inputAct, Range addedRange) {
        assert (addedRange.compareTo(inputAct.key.pos) == 0);
        if (inputAct.key.n instanceof ClockTerminationNode) {
            this.addActivationCTNode(t, inputAct);
        } else {
            this.addActivationFromClockOrTerminationNode(t, inputAct);
        }
    }

    @Override
    public void removeActivation(Iteration t, Activation inputAct, Range removedRange) {
        assert (removedRange.compareTo(inputAct.key.pos) == 0);
        if (inputAct.key.n instanceof ClockTerminationNode) {
            this.removeActivationCTNode(t, inputAct);
        } else {
            this.removeActivationFromClockOrTerminationNode(t, inputAct);
        }
    }

    private Activation getPreviousAct(Activation act) {
        for (Activation pAct : act.inputs) {
            if (pAct.key.n != this) continue;
            return pAct;
        }
        return null;
    }

    private Activation getBeginSignal(Activation act) {
        assert (act.key.n == this);
        for (Activation nAct : act.inputs) {
            if (!(nAct.key.n instanceof ClockNode) && !(nAct.key.n instanceof TerminationNode) || nAct.key.pos.getEnd(((RecurrentNode)nAct.key.n).direction) != act.key.pos.getBegin(this.direction)) continue;
            return nAct;
        }
        return null;
    }

    private Activation getEndSignal(Activation act) {
        assert (act.key.n == this);
        for (Activation nAct : act.inputs) {
            if (!(nAct.key.n instanceof ClockNode) && !(nAct.key.n instanceof TerminationNode) || nAct.key.pos.getEnd(((RecurrentNode)nAct.key.n).direction) != act.key.pos.getEnd(this.direction)) continue;
            return nAct;
        }
        return null;
    }

    private Activation getTerminationSignal(Activation act) {
        assert (act.key.n == this);
        for (Activation nAct : act.inputs) {
            if (!(nAct.key.n instanceof TerminationNode) || nAct.key.pos.getEnd(((RecurrentNode)nAct.key.n).direction) != act.key.pos.getEnd(this.direction) || !act.key.o.contains(nAct.key.o)) continue;
            return nAct;
        }
        return null;
    }

    private Signal getSignal(Document doc, int currentPos, Option o) {
        if (currentPos < 0 || currentPos >= doc.length()) {
            return null;
        }
        Signal s = null;
        block0: for (RecurrentNode n : new RecurrentNode[]{this.clockNode, this.terminationNode}) {
            Range.Relation rr = n.direction ? (this.direction ? Range.Relation.BEGIN_BEFORE : Range.Relation.BEGIN_AFTER) : (this.direction ? Range.Relation.END_BEFORE : Range.Relation.END_AFTER);
            for (Activation act : Activation.select(n, null, Range.create(doc, currentPos - 1, currentPos), rr, null, null, null, null, null, false)) {
                if (!act.key.o.contains(o) && !o.contains(act.key.o)) continue;
                if (s == null || s.pos > act.key.pos.getEnd(((RecurrentNode)act.key.n).direction)) {
                    s = new Signal();
                    s.pos = act.key.pos.getEnd(((RecurrentNode)act.key.n).direction);
                    s.acts.add(act);
                    continue block0;
                }
                if (s.pos != act.key.pos.getEnd(((RecurrentNode)act.key.n).direction)) continue block0;
                s.acts.add(act);
                continue block0;
            }
        }
        if (s == null) {
            s = new Signal();
            s.pos = this.direction ? 0 : doc.length();
        }
        return s;
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Range addedRange, Option conflict) {
        this.addActivationCTNode(t, act);
        for (RecurrentNode recurrentNode : this.outputNodesWithinDocument.values()) {
            recurrentNode.addActivation(t, act, addedRange);
        }
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act, Range removedRange) {
        this.removeActivationCTNode(t, act);
        for (RecurrentNode recurrentNode : this.outputNodesWithinDocument.values()) {
            recurrentNode.removeActivation(t, act, removedRange);
        }
    }

    public static void addInitialActivations(Iteration t) {
        for (ClockTerminationNode n : t.m.clockTerminationNodes) {
            Activation.Key ak = new Activation.Key(n, Range.create(t.doc, 0, t.doc.length()), 0, t.doc.bottom, 0);
            Node.addActivationAndPropagate(t, false, ak, ak.pos, null, Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CT[");
        sb.append(this.clockNode.logicToString());
        sb.append(",");
        sb.append(this.terminationNode.logicToString());
        sb.append("]");
        return sb.toString();
    }

    public static class Signal {
        int pos;
        Set<Activation> acts = new TreeSet<Activation>();
    }
}

