/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.recurrent;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Input;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.recurrent.ClockTerminationNode;
import org.aika.network.neuron.recurrent.OutputNode;
import org.aika.network.neuron.recurrent.RecurrentNode;

public class InputNode
extends RecurrentNode
implements Input {
    public static final int INPUT_TYPE = 2;
    public Neuron inputNeuron;
    public Map<ClockTerminationNode, OutputNode> outputNodes = new TreeMap<ClockTerminationNode, OutputNode>();

    public InputNode(Model m) {
        super(m, 0);
    }

    @Override
    public double computeForwardWeight(Activation act) {
        return act.computeAverageInputWeight();
    }

    @Override
    public double getNodeWeight(Activation act) {
        return this.weight;
    }

    public Collection<OutputNode> getChildren() {
        return this.outputNodes.values();
    }

    @Override
    public void remove(Model m) {
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
        if (this.activations.isEmpty()) {
            for (OutputNode on : this.outputNodes.values()) {
                on.ctNode.outputNodesWithinDocument.put(this, on);
            }
        }
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
        if (this.activations.isEmpty()) {
            for (OutputNode on : this.outputNodes.values()) {
                on.ctNode.outputNodesWithinDocument.remove(this);
            }
        }
    }

    @Override
    public void clearActivations() {
        super.clearActivations();
        for (OutputNode on : this.outputNodes.values()) {
            on.ctNode.outputNodesWithinDocument.remove(this);
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I");
        sb.append("[");
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (this.inputNeuron.label != null) {
                sb.append(",");
                sb.append(this.inputNeuron.label);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

