/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.recurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.recurrent.ClockTerminationNode;
import org.aika.network.neuron.recurrent.InputNode;
import org.aika.network.neuron.recurrent.RecurrentNode;

public class OutputNode
extends RecurrentNode {
    public InputNode inputNode;
    public ClockTerminationNode ctNode;
    public int maxLength;

    public OutputNode(Model m, int maxLength) {
        super(m, 2);
        this.maxLength = maxLength;
    }

    @Override
    public double computeForwardWeight(Activation act) {
        for (Activation inputAct : act.inputs) {
            if (inputAct.key.n instanceof ClockTerminationNode) continue;
            return inputAct.key.n.computeForwardWeight(inputAct);
        }
        assert (false);
        return 0.0;
    }

    @Override
    public double getNodeWeight(Activation act) {
        return this.weight;
    }

    public Collection<RecurrentNode> getChildren() {
        return null;
    }

    @Override
    public void addActivation(Iteration t, Activation inputAct, Range addedRange) {
        block5: {
            block6: {
                Option o;
                int nRid;
                Activation prevOutAct;
                Activation prevCtAct;
                Option o2;
                block4: {
                    if (inputAct.key.n != this.inputNode) break block4;
                    int end = inputAct.key.pos.getEnd(this.inputNode.direction);
                    Range r = Range.create(t.doc, end - 1, end);
                    for (Activation ctAct : Activation.select(this.ctNode, null, r, Range.Relation.CONTAINS, null, null, null, null, null, false)) {
                        Option o3 = Option.add(t.doc, true, ctAct.completeOption, inputAct.key.o);
                        if (o3 == null) continue;
                        Node.addActivationAndPropagate(t, false, new Activation.Key(this, ctAct.key.pos, 0, o3, Math.max(ctAct.key.fired, inputAct.key.fired)), ctAct.key.pos, null, OutputNode.prepareIActs(inputAct, ctAct), OutputNode.prepareDIActs(inputAct, ctAct));
                    }
                    break block5;
                }
                if (inputAct.key.n != this.ctNode) break block6;
                Activation inputNodeAct = Activation.get(this.inputNode, null, inputAct.key.pos, Range.Relation.CONTAINED_IN, null, null, null, null, false);
                if (inputNodeAct != null && (o2 = Option.add(t.doc, true, inputNodeAct.key.o, inputAct.completeOption)) != null) {
                    Node.addActivationAndPropagate(t, false, new Activation.Key(this, inputAct.key.pos, 0, o2, Math.max(inputNodeAct.key.fired, inputAct.key.fired)), inputAct.key.pos, null, OutputNode.prepareIActs(inputAct, inputNodeAct), OutputNode.prepareDIActs(inputAct, inputNodeAct));
                }
                if ((prevCtAct = this.getPreviousCtActivation(inputAct)) == null || (prevOutAct = this.getOutputActivation(prevCtAct)) == null || (nRid = prevOutAct.key.rid + (inputAct.key.rid - prevCtAct.key.rid)) >= this.maxLength || (o = Option.add(t.doc, true, prevOutAct.key.o, inputAct.completeOption)) == null) break block5;
                Node.addActivationAndPropagate(t, false, new Activation.Key(this, inputAct.key.pos, nRid, o, Math.max(prevOutAct.key.fired, inputAct.key.fired)), inputAct.key.pos, null, OutputNode.prepareIActs(inputAct, prevOutAct), OutputNode.prepareDIActs(inputAct, prevOutAct));
                break block5;
            }
            if (inputAct.key.n == this) {
                Activation currentCtAct = this.getCtActivation(inputAct);
                for (Activation nextCtAct : this.getNextCtActivations(currentCtAct)) {
                    Option o;
                    int nRid = inputAct.key.rid + (nextCtAct.key.rid - currentCtAct.key.rid);
                    if (nRid >= this.maxLength || (o = Option.add(t.doc, true, nextCtAct.completeOption, inputAct.key.o)) == null) continue;
                    Node.addActivationAndPropagate(t, true, new Activation.Key(this, nextCtAct.key.pos, nRid, o, Math.max(nextCtAct.key.fired, inputAct.key.fired)), nextCtAct.key.pos, null, OutputNode.prepareIActs(inputAct, nextCtAct), OutputNode.prepareDIActs(inputAct, nextCtAct));
                }
            }
        }
    }

    @Override
    public void removeActivation(Iteration t, Activation inputAct, Range removedRange) {
        Activation act = this.getOutputActivation(inputAct);
        if (act != null) {
            Node.removeActivationAndPropagate(t, true, act, act.key.pos);
        }
    }

    private static Set<Activation> prepareIActs(Activation actA, Activation actB) {
        TreeSet<Activation> iActs = new TreeSet<Activation>();
        iActs.addAll(actA.inputs);
        iActs.addAll(actB.inputs);
        return iActs;
    }

    private static Set<Activation> prepareDIActs(Activation actA, Activation actB) {
        TreeSet<Activation> diActs = new TreeSet<Activation>();
        diActs.add(actA);
        diActs.add(actB);
        return diActs;
    }

    private Activation getPreviousCtActivation(Activation act) {
        for (Activation ctAct : act.directInputs) {
            if (ctAct.key.n != this.ctNode) continue;
            return ctAct;
        }
        return null;
    }

    private Activation getCtActivation(Activation act) {
        for (Activation ctAct : act.directInputs) {
            if (ctAct.key.n != this.ctNode) continue;
            return ctAct;
        }
        return null;
    }

    private Activation getOutputActivation(Activation act) {
        for (Activation outAct : act.directOutputs) {
            if (outAct.key.n != this) continue;
            return outAct;
        }
        return null;
    }

    private List<Activation> getNextCtActivations(Activation act) {
        ArrayList<Activation> results = new ArrayList<Activation>();
        for (Activation nextCtAct : act.directOutputs) {
            if (nextCtAct.key.n != this.ctNode) continue;
            results.add(nextCtAct);
        }
        return results;
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Range addedRange, Option conflict) {
        if (conflict != null) {
            return;
        }
        this.addActivation(t, act, act.key.pos);
        if (this.neuron != null) {
            this.neuron.propagateAddedActivation(t, act, addedRange);
        }
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act, Range removedRange) {
        this.removeActivation(t, act, removedRange);
        if (this.neuron != null) {
            this.neuron.propagateRemovedActivation(t, act, removedRange);
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RN[");
        sb.append(this.inputNode.logicToString());
        sb.append(",");
        sb.append(this.ctNode.logicToString());
        sb.append("]");
        return sb.toString();
    }
}

