/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.recurrent;

import org.aika.network.Model;
import org.aika.network.neuron.Input;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.recurrent.ClockNode;
import org.aika.network.neuron.recurrent.ClockTerminationNode;
import org.aika.network.neuron.recurrent.InputNode;
import org.aika.network.neuron.recurrent.OutputNode;
import org.aika.network.neuron.recurrent.TerminationNode;

public class RecurrentNeuron
extends Neuron {
    public static final int MAX_RECURRENT_ACTIVATIONS = 10;

    public RecurrentNeuron() {
    }

    public RecurrentNeuron(String label) {
        this.label = label;
    }

    public RecurrentNeuron(String label, boolean isBlocked) {
        this.label = label;
        this.isBlocked = isBlocked;
    }

    public static RecurrentNeuron create(Model m, RecurrentNeuron n, Synapse inputSignal, Synapse clockSignal, Synapse terminationSignal, boolean direction, int maxLength, boolean predefined) {
        OutputNode outputNode;
        ClockTerminationNode ctNode;
        n.m = m;
        n.isPredefined = predefined;
        InputNode inputNode = null;
        if (inputSignal != null) {
            n.inputSynapses.put(inputSignal.input, inputSignal);
            Input.InputKey ik = new Input.InputKey(2, null);
            if (inputSignal.input.outputNodes.get(ik) == null) {
                inputNode = new InputNode(m);
                inputNode.inputNeuron = inputSignal.input;
                inputSignal.input.outputNodes.put(ik, inputNode);
            } else {
                inputNode = (InputNode)inputSignal.input.outputNodes.get(ik);
            }
        }
        ClockNode clockNode = null;
        if (clockSignal != null) {
            n.inputSynapses.put(clockSignal.input, clockSignal);
            Input.InputKey ik = new Input.InputKey(3, null);
            if (clockSignal.input.outputNodes.get(ik) == null) {
                clockNode = new ClockNode(m);
                clockNode.inputNeuron = clockSignal.input;
                clockSignal.input.outputNodes.put(ik, clockNode);
            } else {
                clockNode = (ClockNode)clockSignal.input.outputNodes.get(ik);
            }
        }
        TerminationNode terminationNode = null;
        if (terminationSignal != null) {
            n.inputSynapses.put(terminationSignal.input, terminationSignal);
            Input.InputKey ik = new Input.InputKey(3, null);
            if (terminationSignal.input.outputNodes.get(ik) == null) {
                terminationNode = new TerminationNode(m);
                terminationNode.inputNeuron = terminationSignal.input;
                terminationSignal.input.outputNodes.put(ik, terminationNode);
            } else {
                terminationNode = (TerminationNode)terminationSignal.input.outputNodes.get(ik);
            }
        }
        if ((ctNode = clockNode.ctNodes.get(terminationNode)) == null) {
            ctNode = new ClockTerminationNode(m, direction);
            clockNode.ctNodes.put(terminationNode, ctNode);
            ctNode.clockNode = clockNode;
            if (terminationNode != null) {
                terminationNode.ctNodes.put(clockNode, ctNode);
                ctNode.terminationNode = terminationNode;
            }
            m.clockTerminationNodes.add(ctNode);
        }
        if ((outputNode = ctNode.outputNodes.get(inputNode)) == null) {
            outputNode = new OutputNode(m, maxLength);
            ctNode.outputNodes.put(inputNode, outputNode);
            inputNode.outputNodes.put(ctNode, outputNode);
            outputNode.ctNode = ctNode;
            outputNode.inputNode = inputNode;
        }
        outputNode.neuron = n;
        n.node = outputNode;
        n.publish(m);
        return n;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RN(");
        sb.append(this.id);
        if (this.label != null) {
            sb.append(",");
            sb.append(this.label);
        }
        sb.append(")");
        return sb.toString();
    }
}

