/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.recurrent;

import java.util.Collection;
import java.util.Collections;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Node;

public abstract class RecurrentNode
extends Node {
    public boolean direction;
    public int frequency;

    public RecurrentNode(Model m, int level) {
        super(m, level);
    }

    private Activation.Key computeActivationKey(Iteration t, Activation inputAct) {
        Option o;
        Option option = o = inputAct.newOption != null ? Option.add(t.doc, true, inputAct.key.o, inputAct.newOption) : inputAct.key.o;
        if (o == null) {
            return null;
        }
        return new Activation.Key(this, inputAct.key.pos, 0, o, inputAct.key.fired);
    }

    public void addActivation(Iteration t, Activation inputAct, Range addedRange) {
        Activation.Key ak = this.computeActivationKey(t, inputAct);
        if (ak != null) {
            RecurrentNode.addActivationAndPropagate(t, false, ak, addedRange, null, Collections.singleton(inputAct), Collections.singleton(inputAct));
        }
    }

    public void removeActivation(Iteration t, Activation inputAct, Range removedRange) {
        Activation.Key ak = this.computeActivationKey(t, inputAct);
        if (ak != null) {
            RecurrentNode.removeActivationAndPropagate(t, false, Activation.get(this, ak), removedRange);
        }
    }

    public abstract Collection<? extends RecurrentNode> getChildren();

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Range addedRange, Option conflict) {
        if (conflict != null) {
            return;
        }
        for (RecurrentNode recurrentNode : this.getChildren()) {
            recurrentNode.addActivation(t, act, addedRange);
        }
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act, Range removedRange) {
        for (RecurrentNode recurrentNode : this.getChildren()) {
            recurrentNode.removeActivation(t, act, removedRange);
        }
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
    }

    @Override
    public boolean isAllowedOption(Option n, Activation act, long v) {
        return false;
    }

    @Override
    public boolean isNegative() {
        return false;
    }

    @Override
    public boolean containsNegative() {
        return false;
    }

    @Override
    public void cleanup(Model m) {
    }

    @Override
    public double computeSynapseWeightSum(Neuron n) {
        return 0.0;
    }

    public static enum RecurrentType {
        INPUT_SIGNAL,
        CLOCK_SIGNAL,
        TERMINATION_SIGNAL;

    }
}

