/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.simple;

import java.util.Set;
import org.aika.network.Model;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.recurrent.RecurrentNeuron;
import org.aika.network.neuron.simple.lattice.LatticeNode;

public class SimpleNeuron
extends Neuron {
    public SimpleNeuron() {
    }

    public SimpleNeuron(String label) {
        this.label = label;
    }

    public SimpleNeuron(String label, boolean isBlocked) {
        super(label, isBlocked);
    }

    @Override
    public void remove() {
        this.unpublish();
        for (Synapse is : this.inputSynapses.values()) {
            is.input.outputSynapses.remove(is.output);
        }
        for (Synapse is : this.outputSynapses.values()) {
            is.output.inputSynapses.remove(is.input);
        }
    }

    public static SimpleNeuron create(Model m, SimpleNeuron n, double bias, Set<Synapse> inputs, boolean predefined, boolean inferenceMode) {
        n.m = m;
        n.isPredefined = predefined;
        for (Synapse s : inputs) {
            n.inputSynapses.put(s.input, s);
            s.output = n;
        }
        n.bias = bias;
        n.inferenceMode = inferenceMode;
        n = LatticeNode.addNeuron(n, inputs);
        n.publish(m);
        return n;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SN(");
        sb.append(this.id);
        if (this.label != null) {
            sb.append(",");
            sb.append(this.label);
        }
        sb.append(")");
        return sb.toString();
    }

    public static class Input
    implements Comparable<Input> {
        public final boolean isNeg;
        public final boolean isOptional;
        public final Neuron inputNeuron;
        public final int rid;
        public final boolean relative;

        public Input(boolean isNeg, SimpleNeuron inputNeuron) {
            this.isNeg = isNeg;
            this.isOptional = false;
            this.inputNeuron = inputNeuron;
            this.rid = 0;
            this.relative = true;
        }

        public Input(boolean isNeg, boolean isOptional, SimpleNeuron inputNeuron) {
            this.isNeg = isNeg;
            this.isOptional = isOptional;
            this.inputNeuron = inputNeuron;
            this.rid = 0;
            this.relative = true;
        }

        public Input(boolean isNeg, RecurrentNeuron inputNeuron, int rid, boolean relative) {
            this.isNeg = isNeg;
            this.isOptional = false;
            this.inputNeuron = inputNeuron;
            this.rid = rid;
            this.relative = relative;
        }

        public Input(boolean isNeg, boolean isOptional, RecurrentNeuron inputNeuron, int rid, boolean relative) {
            this.isNeg = isNeg;
            this.isOptional = isOptional;
            this.inputNeuron = inputNeuron;
            this.rid = rid;
            this.relative = relative;
        }

        @Override
        public int compareTo(Input in) {
            int r = Boolean.compare(this.isNeg, in.isNeg);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.isOptional, in.isOptional);
            if (r != 0) {
                return r;
            }
            r = this.inputNeuron.compareTo(in.inputNeuron);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.rid, in.rid);
            if (r != 0) {
                return r;
            }
            return Boolean.compare(this.relative, in.relative);
        }
    }
}

