/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.simple.lattice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.simple.SimpleNeuron;
import org.aika.network.neuron.simple.lattice.InputNode;
import org.aika.network.neuron.simple.lattice.LatticeNode;
import org.aika.network.neuron.simple.lattice.LogicNode;
import org.aika.network.neuron.simple.lattice.NegativeInputNode;
import org.aika.network.neuron.simple.lattice.OrNode;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class AndNode
extends LogicNode {
    public double minPRelevance = 0.0;
    public SortedMap<Refinement, LatticeNode> parents = new TreeMap<Refinement, LatticeNode>();
    public Neuron publishedPatternNeuron = null;
    public boolean isSignificant;
    public AndNode directSignificantAncestor = null;
    public SortedSet<AndNode> significantAncestors;
    public boolean inferenceMode;
    public boolean shouldBePublished = false;

    public AndNode(Model m, int level, SortedMap<Refinement, LatticeNode> parents, boolean inferenceMode) {
        super(m, level);
        this.parents = parents;
        this.inferenceMode = inferenceMode;
        for (Map.Entry<Refinement, LatticeNode> me : parents.entrySet()) {
            me.getValue().andChildren.put(me.getKey(), this);
        }
    }

    @Override
    public boolean isAllowedOption(Option n, Activation act, long v) {
        if (this.visitedAllowedOption == v) {
            return false;
        }
        this.visitedAllowedOption = v;
        if (act.initialOption != null && n.contains(act.initialOption)) {
            return true;
        }
        for (Activation pAct : act.directInputs) {
            if (!pAct.key.n.isAllowedOption(n, pAct, v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNegative() {
        for (LatticeNode n : this.parents.values()) {
            if (n instanceof NegativeInputNode) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsNegative() {
        for (Refinement ref : this.parents.keySet()) {
            if (!(ref.input instanceof NegativeInputNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double computeForwardWeight(Activation act) {
        if (!act.inputs.isEmpty()) {
            return act.computeAverageInputWeight();
        }
        return 0.0;
    }

    @Override
    public double getNodeWeight(Activation act) {
        return this.weight;
    }

    public void addActivation(Iteration t, Activation.Key ak, Range addedRange, Option initOption, Set<Activation> inputActs, Set<Activation> directInputActs) {
        Node.addActivationAndPropagate(t, false, ak, addedRange, initOption, inputActs, directInputActs);
    }

    protected void removeActivation(Iteration t, Activation.Key ak, Range removedRange) {
        for (Activation act : Activation.select(this, 0, ak.pos.intersection(removedRange), Range.Relation.OVERLAPS, ak.o, Option.Relation.CONTAINS, null, null, null, true)) {
            Node.removeActivationAndPropagate(t, false, act, act.key.pos.intersection(removedRange));
        }
    }

    public void computeWeight(Model m) {
        double p;
        if (m.numberOfPositions == 0 || this.frequency < Node.minFrequency) {
            return;
        }
        double nullHyp = 1.0;
        for (Refinement ref : this.parents.keySet()) {
            Node in = ref.input.inputNeuron.node;
            p = (double)in.frequency / (double)m.numberOfPositions;
            if (p > 1.0) {
                p = 1.0;
            }
            nullHyp *= p;
        }
        BinomialDistribution binDist = new BinomialDistribution(null, m.numberOfPositions, nullHyp);
        this.weight = binDist.cumulativeProbability(this.frequency - 1);
        this.n = m.numberOfPositions;
        if (this.level > 1) {
            this.minPRelevance = 1.0;
            for (LatticeNode n : this.parents.values()) {
                p = 1.0 - (double)this.frequency / (double)n.frequency;
                if (!(this.minPRelevance > p)) continue;
                this.minPRelevance = p;
            }
        }
        this.setSignificant(this.weight > 0.99);
    }

    public Map<Node, Double> computeMinPRel() {
        TreeMap<Node, Double> result = new TreeMap<Node, Double>();
        for (LatticeNode n : this.parents.values()) {
            double p = 1.0 - (double)this.frequency / (double)n.frequency;
            result.put(n, p);
        }
        return result;
    }

    public void setSignificant(boolean sig) {
        if (this.isSignificant != sig) {
            this.isSignificant = sig;
            this.propagateSignificance(Node.visitedCounter++);
        }
    }

    private void collectCoveredSignificantAncestors(Set<AndNode> results) {
        for (AndNode sa : this.significantAncestors) {
            results.add(sa);
            sa.collectCoveredSignificantAncestors(results);
        }
    }

    private TreeSet<AndNode> computeSignificantAncestors() {
        TreeSet<AndNode> sa = new TreeSet<AndNode>();
        TreeSet<AndNode> coveredSignificantAncestors = new TreeSet<AndNode>();
        for (AndNode cp : this.andChildren.values()) {
            if (!cp.isSignificant || cp.directSignificantAncestor == null) continue;
            sa.add(cp.directSignificantAncestor);
            cp.directSignificantAncestor.collectCoveredSignificantAncestors(coveredSignificantAncestors);
        }
        sa.removeAll(coveredSignificantAncestors);
        return sa;
    }

    public void propagateSignificance(long v) {
        if (this.visitedPropagateSignificance == v) {
            return;
        }
        this.visitedPropagateSignificance = v;
        if (this.isSignificant) {
            this.significantAncestors = this.computeSignificantAncestors();
            if (this.significantAncestors.size() == 1) {
                if (this.directSignificantAncestor == this) {
                    this.shouldBePublished = false;
                }
                this.directSignificantAncestor = this.significantAncestors.first();
            } else {
                if (this.directSignificantAncestor != this) {
                    this.shouldBePublished = true;
                }
                this.directSignificantAncestor = this;
            }
        } else {
            if (this.directSignificantAncestor == this) {
                this.shouldBePublished = false;
            }
            this.directSignificantAncestor = null;
        }
        for (Node node : this.parents.values()) {
            if (!(node instanceof AndNode)) continue;
            AndNode apn = (AndNode)node;
            if (!apn.isSignificant) continue;
            apn.propagateSignificance(v);
        }
    }

    public void publish(Model m) {
        if (!this.isPredefined && this.publishedPatternNeuron == null) {
            TreeSet<AndNode> significantLowerBound = new TreeSet<AndNode>();
            AndNode.collectSignificantLower(significantLowerBound, new TreeSet<AndNode>(), Collections.singleton(this));
            TreeSet<Node> treeSet = AndNode.computeNonSignificantUpperBound(significantLowerBound);
        }
    }

    public void unpublish() {
        if (this.publishedPatternNeuron != null) {
            this.publishedPatternNeuron.unpublish();
        }
    }

    private Neuron computeNeuron(Model m, TreeSet<AndNode> significantLowerBound, TreeSet<Node> nonSignificantUpperBound) {
        double[] c;
        TreeMap<Refinement, Integer> indexes = new TreeMap<Refinement, Integer>();
        ArrayList<Refinement> revIndexes = new ArrayList<Refinement>();
        for (AndNode n : significantLowerBound) {
            for (Refinement ref : n.parents.keySet()) {
                if (indexes.containsKey(ref)) continue;
                indexes.put(ref, indexes.size());
                revIndexes.add(ref);
            }
        }
        double[] objF = new double[indexes.size() + 1];
        objF[0] = 1.0;
        LinearObjectiveFunction f = new LinearObjectiveFunction(objF, 0.0);
        LinearConstraint[] constraintArr = new LinearConstraint[significantLowerBound.size() + nonSignificantUpperBound.size()];
        int i = 0;
        for (AndNode andNode : significantLowerBound) {
            c = new double[indexes.size() + 1];
            c[0] = 1.0;
            for (Refinement ref : andNode.parents.keySet()) {
                c[((Integer)indexes.get((Object)ref)).intValue() + 1] = ref.input.getSign();
            }
            constraintArr[i] = new LinearConstraint(c, Relationship.GEQ, 0.5);
            ++i;
        }
        for (Node node : nonSignificantUpperBound) {
            c = new double[indexes.size() + 1];
            c[0] = 1.0;
            if (node instanceof InputNode) {
                c[((Integer)indexes.get((Object)node)).intValue() + 1] = ((InputNode)node).getSign();
            } else if (node instanceof AndNode) {
                for (Refinement ref : ((AndNode)node).parents.keySet()) {
                    c[((Integer)indexes.get((Object)ref)).intValue() + 1] = ref.input.getSign();
                }
            }
            constraintArr[i] = new LinearConstraint(c, Relationship.LEQ, -0.5);
            ++i;
        }
        LinearConstraintSet constraints = new LinearConstraintSet(constraintArr);
        SimplexSolver simplexSolver = new SimplexSolver();
        PointValuePair solution = simplexSolver.optimize(new OptimizationData[]{f, constraints, GoalType.MAXIMIZE, new NonNegativeConstraint(false)});
        double bias = ((double[])solution.getKey())[0];
        TreeSet<Synapse> synapses = new TreeSet<Synapse>();
        for (int j = 1; j < ((double[])solution.getKey()).length; ++j) {
            Refinement ref = (Refinement)revIndexes.get(j - 1);
            Synapse s = new Synapse(ref.input.inputNeuron, ref.rid, ref.input.rid == null);
            s.w = (float)((double[])solution.getKey())[j];
            synapses.add(s);
        }
        return SimpleNeuron.create(m, new SimpleNeuron(), bias, synapses, false, false);
    }

    public static void collectSignificantLower(Set<AndNode> significantLowerBound, Set<AndNode> coveredByCurrentLevel, Set<AndNode> currentLevelNodes) {
        TreeSet<AndNode> nextLevelNodes = new TreeSet<AndNode>();
        for (AndNode n : currentLevelNodes) {
            if (n.level <= 2) continue;
            for (Node node : n.parents.values()) {
                nextLevelNodes.add((AndNode)node);
            }
        }
        TreeSet<AndNode> coveredByNextLevel = new TreeSet<AndNode>();
        if (!nextLevelNodes.isEmpty()) {
            AndNode.collectSignificantLower(significantLowerBound, coveredByNextLevel, nextLevelNodes);
        }
        for (AndNode cn : coveredByNextLevel) {
            coveredByCurrentLevel.addAll(cn.andChildren.values());
        }
        for (AndNode n : currentLevelNodes) {
            if (!n.isSignificant || coveredByCurrentLevel.contains(n)) continue;
            significantLowerBound.add(n);
            coveredByCurrentLevel.add(n);
        }
    }

    private static TreeSet<Node> computeNonSignificantUpperBound(TreeSet<AndNode> significantLowerBound) {
        TreeSet<Node> nonSignificantUpperBound = new TreeSet<Node>();
        for (AndNode n : significantLowerBound) {
            nonSignificantUpperBound.addAll(n.parents.values());
        }
        return nonSignificantUpperBound;
    }

    public String significantAncestorsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SA:{");
        boolean first = true;
        if (this.significantAncestors != null) {
            for (AndNode sa : this.significantAncestors) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(sa.id);
                first = false;
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void cleanup(Model m) {
        if (!this.isRemoved && !this.isFrequentOrPredefined()) {
            this.remove(m);
        }
    }

    @Override
    public void expandToNextLevel(Iteration t, Activation act, Range addedRange, Option conflict, boolean train) {
        if (act.isRemoved) {
            return;
        }
        for (Map.Entry<Refinement, LatticeNode> mea : this.parents.entrySet()) {
            LatticeNode pn = mea.getValue();
            for (Map.Entry<Refinement, AndNode> meb : pn.andChildrenWithinDocument.entrySet()) {
                if (meb.getKey().inferenceMode != this.inferenceMode) continue;
                AndNode.processCandidate(t, this, meb.getValue(), new Refinement(meb.getKey().rid - mea.getKey().getOffset(), this.inferenceMode, meb.getKey().input), act, addedRange, conflict, train);
            }
        }
        OrNode.processCandidate(t, this, act, addedRange, conflict, train);
    }

    public static void processCandidate(Iteration t, LatticeNode firstNode, Node secondNode, Refinement refinement, Activation act, Range addedRange, Option conflict, boolean train) {
        if (firstNode != secondNode || refinement.rid != 0) {
            if (train) {
                if (firstNode.isFrequentOrPredefined() && !refinement.inferenceMode) {
                    AndNode.createNextLevelPattern(t, firstNode, refinement);
                }
            } else {
                AndNode.addActivationsToNextLevelPattern(t, firstNode, secondNode, refinement, act, addedRange, conflict);
            }
        }
    }

    public static void createNextLevelPattern(Iteration t, LatticeNode firstNode, Refinement refinement) {
        if (firstNode.andChildren.containsKey(refinement)) {
            return;
        }
        TreeSet<Refinement> inputs = new TreeSet<Refinement>();
        firstNode.collectNodeAndRefinements(refinement, inputs);
        for (Refinement ref : inputs) {
            if (!ref.input.isBlocked && ref.input.inputNeuron != null && !ref.input.inputNeuron.isBlocked) continue;
            return;
        }
        SortedMap<Refinement, LatticeNode> nlParents = AndNode.computeParents(inputs);
        if (nlParents != null) {
            AndNode.prepareNextLevelPattern(t, firstNode.level + 1, nlParents);
        }
    }

    public static void addActivationsToNextLevelPattern(Iteration t, LatticeNode firstNode, Node secondNode, Refinement refinement, Activation act, Range addedRange, Option conflict) {
        Activation.Key ak = act.key;
        AndNode nlp = firstNode.andChildren.get(refinement);
        if (nlp == null) {
            return;
        }
        if (!secondNode.isNegative()) {
            for (Activation secondAct : Activation.select(secondNode, act.key.rid + refinement.rid, addedRange, Range.Relation.OVERLAPS, null, null, null, null, null, false)) {
                Option o = Option.add(t.doc, true, ak.o, secondAct.key.o);
                if (o == null || conflict != null && !o.contains(conflict)) continue;
                Set<Activation>[] iActs = AndNode.prepareInputActs(act, secondAct);
                nlp.addActivationWithNegative(t, nlp.inferenceMode ? Range.add(t.doc, ak.pos, secondAct.key.pos) : ak.pos.intersection(secondAct.key.pos), act.key.rid + refinement.getOffset(), o, Math.max(ak.fired, secondAct.key.fired), nlp.inferenceMode ? Range.add(t.doc, addedRange, secondAct.key.pos) : addedRange.intersection(secondAct.key.pos), iActs[0], iActs[1]);
            }
        } else if (conflict == null) {
            nlp.addActivationWithNegative(t, ak.pos, act.key.rid + refinement.getOffset(), ak.o, ak.fired, addedRange, act.inputs, Collections.singleton(act));
        }
    }

    private void addActivationWithNegative(Iteration t, Range pos, int rid, Option o, Integer fired, Range addedRange, Set<Activation> inputActs, Set<Activation> directInputActs) {
        if (this.isPublic() && this.containsNegative()) {
            TreeSet<NegativeInputNode> negNodes = new TreeSet<NegativeInputNode>();
            for (Refinement ref : this.parents.keySet()) {
                if (!(ref.input instanceof NegativeInputNode)) continue;
                negNodes.add((NegativeInputNode)ref.input);
            }
            TreeMap<Range, Set<Conflicts.Key>> conflicts = NegativeInputNode.getNegationSegments(t.doc, negNodes, addedRange);
            for (Map.Entry<Range, Set<Conflicts.Key>> me : conflicts.entrySet()) {
                Option no = this.retrieveInitialOption(me.getKey(), rid, o);
                if (no == null) {
                    no = Option.addPrimitive(t.doc, me.getKey().getBegin());
                    for (Conflicts.Key ck : me.getValue()) {
                        boolean isAllowed = false;
                        for (Activation pAct : directInputActs) {
                            if (!pAct.key.n.isAllowedOption(ck.o, pAct, visitedCounter++)) continue;
                            isAllowed = true;
                        }
                        if (isAllowed) continue;
                        Conflicts.add(t, ck.n, no, ck.o);
                    }
                }
                this.addActivation(t, new Activation.Key(this, me.getKey(), rid, o, fired), me.getKey(), no, inputActs, directInputActs);
            }
        } else {
            this.addActivation(t, new Activation.Key(this, pos, rid, o, fired), addedRange, null, inputActs, directInputActs);
        }
    }

    private static Set<Activation>[] prepareInputActs(Activation firstAct, Activation secondAct) {
        TreeSet<Activation> inputActs = new TreeSet<Activation>();
        if (firstAct.inputs != null) {
            inputActs.addAll(firstAct.inputs);
        }
        if (secondAct.inputs != null) {
            inputActs.addAll(secondAct.inputs);
        }
        TreeSet<Activation> directInputActs = new TreeSet<Activation>();
        directInputActs.add(firstAct);
        directInputActs.add(secondAct);
        return new Set[]{inputActs, directInputActs};
    }

    public static SortedMap<Refinement, LatticeNode> computeParents(Set<Refinement> refinements) {
        HashSet<LatticeNode.RSKey> visited = new HashSet<LatticeNode.RSKey>();
        TreeMap<Refinement, LatticeNode> parents = new TreeMap<Refinement, LatticeNode>();
        for (Refinement ref : refinements) {
            TreeSet<Refinement> childInputs = new TreeSet<Refinement>(refinements);
            childInputs.remove(ref);
            if (ref.input.computeAndParents(ref.getRelativePosition(), childInputs, parents, visited)) continue;
            return null;
        }
        return parents;
    }

    private static void prepareNextLevelPattern(Iteration t, int level, SortedMap<Refinement, LatticeNode> parents) {
        assert (level == parents.size());
        Boolean im = null;
        for (Refinement ref : parents.keySet()) {
            if (ref.input.inputNeuron != null && ref.input.inputNeuron.isBlocked) {
                return;
            }
            if (im == null) {
                im = ref.inferenceMode;
                continue;
            }
            assert (im == ref.inferenceMode);
        }
        AndNode nlp = new AndNode(t.m, level, parents, im);
        nlp.computePatternActivations(t, parents.values());
        t.addedNodes.add(nlp);
    }

    private Refinement getMinRefinement(Refinement exclude) {
        Refinement minRef = null;
        for (Refinement ref : this.parents.keySet()) {
            if (ref == exclude || minRef != null && minRef.getRelativePosition() <= ref.getRelativePosition()) continue;
            minRef = ref;
        }
        return minRef;
    }

    @Override
    protected void collectNodeAndRefinements(Refinement newRef, Set<Refinement> inputs) {
        Refinement firstRef = null;
        Refinement secondRef = null;
        if (newRef.rid >= 0) {
            Refinement firstMinRef = this.getMinRefinement(null);
            firstRef = newRef.rid < firstMinRef.getRelativePosition() ? newRef : firstMinRef;
            Refinement secondMinRef = this.getMinRefinement(firstRef);
            secondRef = newRef != firstRef && newRef.rid < secondMinRef.getRelativePosition() ? newRef : secondMinRef;
        }
        for (Refinement ref : this.parents.keySet()) {
            int nRid = ref == firstRef ? -secondRef.rid : ref.getRelativePosition() - Math.min(0, newRef.rid);
            inputs.add(new Refinement(nRid, ref.inferenceMode, ref.input));
        }
        inputs.add(newRef);
    }

    @Override
    public double computeSynapseWeightSum(Neuron n) {
        double sum = n.bias;
        for (Refinement ref : this.parents.keySet()) {
            Synapse s = (Synapse)n.inputSynapses.get(ref.input.inputNeuron);
            sum += (double)Math.abs(s.w);
        }
        return sum;
    }

    private void computePatternActivations(Iteration t, Collection<LatticeNode> parentNodes) {
        Iterator<LatticeNode> it = parentNodes.iterator();
        Node firstParentNode = it.next();
        Node secondParentNode = it.next();
        if (firstParentNode instanceof NegativeInputNode) {
            Node tmp = firstParentNode;
            firstParentNode = secondParentNode;
            secondParentNode = tmp;
        }
        assert (!(firstParentNode instanceof NegativeInputNode));
        for (Activation firstAct : firstParentNode.activations.values()) {
            for (Activation secondAct : Activation.select(secondParentNode, 0, firstAct.key.pos, Range.Relation.OVERLAPS, null, null, null, null, null, true)) {
                Option o = Option.add(t.doc, true, firstAct.key.o, secondAct.key.o);
                if (o == null) continue;
                Set<Activation>[] iActs = AndNode.prepareInputActs(firstAct, secondAct);
                Range pos = firstAct.key.pos.intersection(secondAct.key.pos);
                this.addActivation(t, new Activation.Key(this, pos, Math.min(firstAct.key.rid, secondAct.key.rid), o, Math.max(firstAct.key.fired, secondAct.key.fired)), pos, null, iActs[0], iActs[1]);
            }
        }
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
        if (this.activations.isEmpty()) {
            for (Map.Entry<Refinement, LatticeNode> me : this.parents.entrySet()) {
                me.getValue().andChildrenWithinDocument.put(me.getKey(), this);
            }
        }
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
        if (this.activations.isEmpty()) {
            for (Map.Entry<Refinement, LatticeNode> me : this.parents.entrySet()) {
                me.getValue().andChildrenWithinDocument.remove(me.getKey());
            }
        }
    }

    @Override
    public void clearActivations() {
        super.clearActivations();
        for (Map.Entry<Refinement, LatticeNode> me : this.parents.entrySet()) {
            me.getValue().andChildrenWithinDocument.remove(me.getKey());
        }
    }

    @Override
    public void remove(Model m) {
        super.remove(m);
        for (Map.Entry<Refinement, LatticeNode> me : this.parents.entrySet()) {
            me.getValue().andChildren.remove(me.getKey());
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND[");
        boolean first = true;
        for (Refinement ref : this.parents.keySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(ref.rid);
            sb.append(":");
            sb.append(ref.input.logicToString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static class Refinement
    implements Comparable<Refinement> {
        public final int rid;
        public final boolean inferenceMode;
        public final InputNode input;

        public Refinement(int rid, boolean inferenceMode, InputNode input) {
            this.rid = rid;
            this.inferenceMode = inferenceMode;
            this.input = input;
        }

        public int getOffset() {
            return Math.min(0, this.rid);
        }

        public int getRelativePosition() {
            return Math.max(0, this.rid);
        }

        public String toString() {
            return "[" + (this.inferenceMode ? "+" : "-") + this.rid + ":" + this.input.logicToString() + "]";
        }

        @Override
        public int compareTo(Refinement ref) {
            int r = Integer.compare(this.rid, ref.rid);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.inferenceMode, ref.inferenceMode);
            if (r != 0) {
                return r;
            }
            return this.input.compareTo(ref.input);
        }
    }
}

