/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.simple.lattice;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Input;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.recurrent.RecurrentNeuron;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.LatticeNode;
import org.aika.network.neuron.simple.lattice.NegativeInputNode;
import org.aika.network.neuron.simple.lattice.OrNode;
import org.aika.network.neuron.simple.lattice.PositiveInputNode;

public abstract class InputNode
extends LatticeNode
implements Input {
    public Integer rid;
    public Neuron inputNeuron;

    public InputNode(Model m, Integer rid) {
        super(m, 1);
        this.rid = rid;
    }

    public static InputNode add(Model m, Integer rid, Neuron input, boolean isNeg) {
        Input.InputKey ik = new Input.InputKey(!isNeg ? 0 : 1, rid);
        InputNode in = (InputNode)(input != null ? (Input)input.outputNodes.get(ik) : null);
        if (in != null) {
            return in;
        }
        if (!isNeg) {
            in = new PositiveInputNode(m, rid);
        } else {
            NegativeInputNode negIn = new NegativeInputNode(m, rid);
            m.negationNodes.add(negIn);
            in = negIn;
        }
        if (input != null) {
            in.inputNeuron = input;
            input.outputNodes.put(ik, in);
        }
        return in;
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
    }

    private Activation.Key computeActivationKey(Iteration t, Activation iAct) {
        Option o;
        int rid;
        int n = rid = this.inputNeuron instanceof RecurrentNeuron ? iAct.key.rid : 0;
        if (this.rid != null && this.rid != rid) {
            return null;
        }
        Option option = o = iAct.newOption != null ? Option.add(t.doc, true, iAct.key.o, iAct.newOption) : iAct.key.o;
        if (o == null) {
            return null;
        }
        return new Activation.Key(this, iAct.key.pos, rid, o, iAct.key.fired + 1);
    }

    @Override
    public void addActivation(Iteration t, Activation inputAct, Range addedRange) {
        Activation.Key ak = this.computeActivationKey(t, inputAct);
        if (ak != null) {
            InputNode.addActivationAndPropagate(t, false, ak, addedRange, null, Collections.singleton(inputAct), Collections.singleton(inputAct));
        }
    }

    @Override
    public void removeActivation(Iteration t, Activation inputAct, Range removedRange) {
        Activation.Key ak = this.computeActivationKey(t, inputAct);
        if (ak != null) {
            InputNode.removeActivationAndPropagate(t, false, Activation.get(this, null, removedRange, Range.Relation.CONTAINS, ak.o, Option.Relation.EQUALS, ak.fired, null, true), removedRange);
        }
    }

    public abstract int getSign();

    @Override
    public boolean isAllowedOption(Option n, Activation act, long v) {
        return false;
    }

    @Override
    protected void collectNodeAndRefinements(AndNode.Refinement newRef, Set<AndNode.Refinement> inputs) {
        inputs.add(new AndNode.Refinement(-newRef.rid, newRef.inferenceMode, this));
        inputs.add(newRef);
    }

    @Override
    public void expandToNextLevel(Iteration t, Activation act, Range addedRange, Option removedConflict, boolean train) {
        if (act.isRemoved) {
            return;
        }
        for (AndNode.Refinement ref : this.getNodesFromActivations(act, act.key.pos.getOverlappingInputActivations())) {
            AndNode.processCandidate(t, this, ref.input, ref, act, addedRange, removedConflict, train);
        }
        if (removedConflict == null) {
            for (AndNode.Refinement ref : this.andChildren.keySet()) {
                if (!(ref.input instanceof NegativeInputNode)) continue;
                AndNode.processCandidate(t, this, ref.input, ref, act, addedRange, null, train);
            }
        }
        OrNode.processCandidate(t, this, act, addedRange, removedConflict, train);
    }

    private Set<AndNode.Refinement> getNodesFromActivations(Activation firstAct, Collection<Activation> acts) {
        TreeSet<AndNode.Refinement> results = new TreeSet<AndNode.Refinement>();
        for (Activation secondAct : acts) {
            if (firstAct == secondAct || secondAct.key.n instanceof NegativeInputNode) continue;
            results.add(new AndNode.Refinement(secondAct.key.rid - firstAct.key.rid, false, (InputNode)secondAct.key.n));
            results.add(new AndNode.Refinement(secondAct.key.rid - firstAct.key.rid, true, (InputNode)secondAct.key.n));
        }
        return results;
    }

    @Override
    public double computeSynapseWeightSum(Neuron n) {
        return n.bias + (double)Math.abs(((Synapse)n.inputSynapses.get((Object)this.inputNeuron)).w);
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        if (this instanceof PositiveInputNode) {
            sb.append("P");
        } else {
            sb.append("N");
        }
        sb.append("[");
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (this.inputNeuron.label != null) {
                sb.append(",");
                sb.append(this.inputNeuron.label);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

