/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.simple.lattice;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.simple.SimpleNeuron;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.InputNode;
import org.aika.network.neuron.simple.lattice.OrNode;

public abstract class LatticeNode
extends Node {
    public TreeMap<AndNode.Refinement, AndNode> andChildrenWithinDocument = new TreeMap();
    public TreeMap<AndNode.Refinement, AndNode> andChildren = new TreeMap();
    public TreeSet<OrNode> orChildren = new TreeSet();
    public long visitedPropagateSignificance = -1L;
    public long visitedCollectPublicNodes = -1L;
    public long visitedAllowedOption = -1L;

    public LatticeNode(Model m, int level) {
        super(m, level);
    }

    public abstract void expandToNextLevel(Iteration var1, Activation var2, Range var3, Option var4, boolean var5);

    protected abstract void collectNodeAndRefinements(AndNode.Refinement var1, Set<AndNode.Refinement> var2);

    public boolean isPublic() {
        return this.neuron != null || !this.orChildren.isEmpty();
    }

    public void collectPublicNodes(List<LatticeNode> results, long v) {
        if (this.visitedCollectPublicNodes == v) {
            return;
        }
        this.visitedCollectPublicNodes = v;
        if (this.isPublic()) {
            results.add(this);
        }
        for (AndNode n : this.andChildrenWithinDocument.values()) {
            n.collectPublicNodes(results, v);
        }
    }

    public void train(Iteration t) {
        if (this.isFrequentOrPredefined(this.frequency)) {
            for (Activation act : this.activations.values()) {
                this.expandToNextLevel(t, act, act.key.pos, null, true);
            }
        }
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Range addedRange, Option conflict) {
        super.propagateAddedActivation(t, act, addedRange, conflict);
        this.expandToNextLevel(t, act, addedRange, conflict, false);
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act, Range removedRange) {
        super.propagateRemovedActivation(t, act, removedRange);
        this.removeFromNextLevel(t, act, removedRange);
    }

    public Set<AndNode> getAndChildPatterns(Set<AndNode> results) {
        for (AndNode cp : this.andChildren.values()) {
            results.add(cp);
            cp.getAndChildPatterns(results);
        }
        return results;
    }

    public boolean computeAndParents(int offset, SortedSet<AndNode.Refinement> inputs, Map<AndNode.Refinement, LatticeNode> parents, Set<RSKey> visited) {
        RSKey v = new RSKey(this, offset);
        if (visited.contains(v)) {
            return true;
        }
        visited.add(v);
        if (inputs.size() == 1) {
            parents.put(inputs.first(), this);
            return true;
        }
        for (AndNode.Refinement ref : inputs) {
            int nOffset = Math.min(offset, ref.getRelativePosition());
            TreeSet<AndNode.Refinement> childInputs = new TreeSet<AndNode.Refinement>(inputs);
            childInputs.remove(ref);
            LatticeNode cp = this.andChildren.get(new AndNode.Refinement(nOffset < offset ? nOffset - offset : ref.getRelativePosition() - nOffset, ref.inferenceMode, ref.input));
            if (cp == null) {
                return false;
            }
            if (!cp.isFrequentOrPredefined()) {
                return false;
            }
            if (cp.computeAndParents(nOffset, childInputs, parents, visited)) continue;
            return false;
        }
        return true;
    }

    public void removeFromNextLevel(Iteration t, Activation iAct, Range removedRange) {
        Activation.Key ak = iAct.key;
        for (AndNode andNode : this.andChildrenWithinDocument.values()) {
            andNode.removeActivation(t, ak, removedRange);
        }
        for (OrNode orNode : this.orChildren) {
            Activation act = Activation.get(orNode, new Activation.Key(this, ak.pos, ak.rid, iAct.newOption != null ? Option.add(t.doc, false, ak.o, iAct.newOption) : ak.o, ak.fired, this.id));
            orNode.removeActivation(t, act, removedRange);
        }
    }

    public void remove(Model m) {
        assert (!this.isRemoved);
        if (this.neuron != null) {
            this.neuron.remove();
        }
        while (!this.andChildren.isEmpty()) {
            this.andChildren.pollFirstEntry().getValue().remove(m);
        }
        while (!this.orChildren.isEmpty()) {
            this.orChildren.pollFirst().remove(m);
        }
        m.allNodes.remove(this);
        this.clearActivations();
        this.isRemoved = true;
        this.isRemovedId = isRemovedIdCounter++;
    }

    public static SimpleNeuron addNeuron(SimpleNeuron n, Set<Synapse> inputs) {
        TreeSet<LatticeNode> outputs = new TreeSet<LatticeNode>();
        if (inputs.isEmpty()) {
            InputNode node = InputNode.add(n.m, null, null, false);
            node.isPredefined = true;
            outputs.add(node);
        } else {
            Map<RSKey, Set<Synapse>> nextLevel;
            Map<RSKey, Set<Synapse>> firstLevel = LatticeNode.computePredefinedInputNodes(n, outputs, inputs);
            Map<RSKey, Set<Synapse>> map = nextLevel = !firstLevel.isEmpty() ? LatticeNode.computePredefinedSecondLevelAndNodes(n, outputs, firstLevel) : null;
            while (nextLevel != null && !nextLevel.isEmpty()) {
                nextLevel = LatticeNode.computePredefinedAndNodes(n, outputs, nextLevel);
            }
        }
        assert (!outputs.isEmpty());
        Node outputNode = null;
        if (outputs.size() == 1) {
            outputNode = (Node)outputs.first();
        } else if (outputs.size() > 1) {
            OrNode orNode = new OrNode(n.m, -1);
            for (LatticeNode on : outputs) {
                orNode.addInput(on);
            }
            outputNode = orNode;
        }
        assert (outputNode != null);
        assert (n.node == null);
        n.node = outputNode;
        if (outputNode.neuron == null) {
            outputNode.neuron = n;
        }
        outputNode.isPredefined = true;
        return (SimpleNeuron)outputNode.neuron;
    }

    public static Map<RSKey, Set<Synapse>> computePredefinedInputNodes(Neuron n, Set<LatticeNode> outputs, Set<Synapse> inputs) {
        TreeMap<RSKey, Set<Synapse>> results = new TreeMap<RSKey, Set<Synapse>>();
        for (Synapse s : inputs) {
            InputNode in = InputNode.add(n.m, !s.relative ? Integer.valueOf(s.rid) : null, s.input, s.w < 0.0f);
            in.isPredefined = true;
            LatticeNode.prepareResultsForPredefinedNodes(results, outputs, in, n, s, s.rid, inputs);
        }
        return results;
    }

    public static Map<RSKey, Set<Synapse>> computePredefinedSecondLevelAndNodes(Neuron n, Set<LatticeNode> outputs, Map<RSKey, Set<Synapse>> previousLevel) {
        TreeMap<RSKey, Set<Synapse>> results = new TreeMap<RSKey, Set<Synapse>>();
        for (Map.Entry<RSKey, Set<Synapse>> me : previousLevel.entrySet()) {
            for (Synapse s : me.getValue()) {
                InputNode pb = s.getInputNode();
                AndNode.Refinement refa = new AndNode.Refinement(me.getKey().offset - s.rid, n.inferenceMode, (InputNode)me.getKey().pa);
                AndNode.Refinement refb = new AndNode.Refinement(s.rid - me.getKey().offset, n.inferenceMode, pb);
                int nOffset = Math.min(s.rid, me.getKey().offset);
                if (!(pb.computeSynapseWeightSum(n) <= 0.0)) continue;
                AndNode sln = me.getKey().pa.andChildren.get(refb);
                if (sln == null) {
                    TreeMap<AndNode.Refinement, LatticeNode> parents = new TreeMap<AndNode.Refinement, LatticeNode>();
                    parents.put(refb, me.getKey().pa);
                    parents.put(refa, pb);
                    sln = new AndNode(n.m, 2, parents, n.inferenceMode);
                }
                LatticeNode.prepareResultsForPredefinedNodes(results, outputs, sln, n, s, nOffset, me.getValue());
            }
        }
        return results;
    }

    public static Map<RSKey, Set<Synapse>> computePredefinedAndNodes(Neuron n, Set<LatticeNode> outputs, Map<RSKey, Set<Synapse>> previousLevel) {
        TreeMap<RSKey, Set<Synapse>> results = new TreeMap<RSKey, Set<Synapse>>();
        for (Map.Entry<RSKey, Set<Synapse>> me : previousLevel.entrySet()) {
            AndNode pa = (AndNode)me.getKey().pa;
            for (Map.Entry<AndNode.Refinement, LatticeNode> mea : pa.parents.entrySet()) {
                int pOffset = me.getKey().offset - mea.getKey().getOffset();
                for (Synapse s : me.getValue()) {
                    int nOffset = Math.min(s.rid, me.getKey().offset);
                    AndNode.Refinement pRef = new AndNode.Refinement(s.rid - pOffset, n.inferenceMode, s.getInputNode());
                    AndNode.Refinement ref = new AndNode.Refinement(s.rid - me.getKey().offset, n.inferenceMode, s.getInputNode());
                    AndNode pb = mea.getValue().andChildren.get(pRef);
                    if (pb == null || !(pb.computeSynapseWeightSum(n) <= 0.0)) continue;
                    AndNode nln = (AndNode)pa.andChildren.get(ref);
                    if (nln == null) {
                        TreeSet<AndNode.Refinement> inputs = new TreeSet<AndNode.Refinement>();
                        pa.collectNodeAndRefinements(ref, inputs);
                        nln = new AndNode(n.m, pa.level + 1, AndNode.computeParents(inputs), n.inferenceMode);
                    }
                    LatticeNode.prepareResultsForPredefinedNodes(results, outputs, nln, n, s, nOffset, me.getValue());
                }
            }
        }
        return results;
    }

    private static void prepareResultsForPredefinedNodes(Map<RSKey, Set<Synapse>> results, Set<LatticeNode> outputs, LatticeNode in, Neuron n, Synapse s, int offset, Set<Synapse> inputs) {
        in.isPredefined = true;
        if (in.computeSynapseWeightSum(n) > 0.0) {
            outputs.add(in);
        } else {
            RSKey rs = new RSKey(in, offset);
            TreeSet<Synapse> nInputs = new TreeSet<Synapse>(inputs);
            nInputs.remove(s);
            rs.offset = offset;
            results.put(rs, nInputs);
        }
    }

    public static class RSKey
    implements Comparable<RSKey> {
        LatticeNode pa;
        int offset;

        public RSKey(LatticeNode pa, int offset) {
            this.pa = pa;
            this.offset = offset;
        }

        public String toString() {
            return "Offset:" + this.offset;
        }

        @Override
        public int compareTo(RSKey rs) {
            int r = this.pa.compareTo(rs.pa);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.offset, rs.offset);
        }
    }
}

