/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.simple.lattice;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Input;
import org.aika.network.neuron.simple.lattice.InputNode;
import org.aika.network.neuron.simple.lattice.LatticeNode;

public class NegativeInputNode
extends InputNode {
    public static final int INPUT_TYPE = 1;

    public NegativeInputNode(Model m, Integer rid) {
        super(m, rid);
    }

    public static TreeMap<Range, Set<Conflicts.Key>> getNegationSegments(Document doc, Set<NegativeInputNode> nn, Range r) {
        TreeSet<Integer> positions = new TreeSet<Integer>();
        for (int[] seg : r.getSegments()) {
            positions.add(seg[0]);
            positions.add(seg[1]);
        }
        for (NegativeInputNode n : nn) {
            for (Activation act : Activation.select(n, null, r, Range.Relation.OVERLAPS, null, null, null, null, null, true)) {
                int end;
                int begin = act.key.pos.getBegin();
                if (r.contains(begin)) {
                    positions.add(begin);
                }
                if (!r.contains(end = act.key.pos.getEnd())) continue;
                positions.add(end);
            }
        }
        TreeMap<Range, Set<Conflicts.Key>> results = new TreeMap<Range, Set<Conflicts.Key>>();
        Integer lastP = null;
        for (Integer p : positions) {
            Range nr;
            if (lastP != null && r.contains(nr = Range.create(doc, lastP, p))) {
                TreeSet<Conflicts.Key> opts = new TreeSet<Conflicts.Key>();
                for (NegativeInputNode n : nn) {
                    for (Activation act : Activation.select(n, null, nr, Range.Relation.OVERLAPS, null, null, null, null, null, true)) {
                        opts.add(new Conflicts.Key(act.key.o, n));
                    }
                }
                results.put(nr, opts);
            }
            lastP = p;
        }
        return results;
    }

    @Override
    public boolean isNegative() {
        return true;
    }

    @Override
    public boolean containsNegative() {
        return true;
    }

    @Override
    public double computeForwardWeight(Activation act) {
        return 1.0;
    }

    @Override
    public double getNodeWeight(Activation act) {
        return this.weight;
    }

    @Override
    public void propagateAddedActivation(Iteration t, Activation act, Range addedRange, Option conflict) {
        if (conflict != null) {
            return;
        }
        ArrayList<LatticeNode> publicNodes = new ArrayList<LatticeNode>();
        this.collectPublicNodes(publicNodes, visitedCounter++);
        for (LatticeNode n : publicNodes) {
            for (Activation nAct : Activation.select(n, null, addedRange, Range.Relation.OVERLAPS, null, null, null, null, null, true)) {
                if (n.isAllowedOption(act.key.o, nAct, visitedCounter++)) continue;
                if (addedRange.contains(nAct.key.pos)) {
                    assert (nAct.initialOption != null);
                    Conflicts.add(t, this, nAct.initialOption, act.key.o);
                    continue;
                }
                LatticeNode.removeActivationAndPropagate(t, true, nAct, nAct.key.pos.intersection(addedRange));
                for (int[] seg : nAct.key.pos.intersection(addedRange).getSegments()) {
                    Range r = Range.create(t.doc, seg);
                    Option nio = nAct.initialOption.clonePrimitive(t);
                    Conflicts.add(t, this, nio, act.key.o);
                    LatticeNode.addActivationAndPropagate(t, true, new Activation.Key(n, r, act.key.rid, nAct.key.o, nAct.key.fired), r, nio, nAct.inputs, nAct.directInputs);
                }
            }
        }
    }

    @Override
    public void propagateRemovedActivation(Iteration t, Activation act, Range removedRange) {
        ArrayList<LatticeNode> publicNodes = new ArrayList<LatticeNode>();
        this.collectPublicNodes(publicNodes, visitedCounter++);
        for (LatticeNode n : publicNodes) {
            for (Activation nAct : Activation.select(n, null, removedRange, Range.Relation.OVERLAPS, null, null, null, null, null, true)) {
                if (n.isAllowedOption(act.key.o, nAct, visitedCounter++)) continue;
                if (removedRange.contains(nAct.key.pos)) {
                    assert (nAct.initialOption != null);
                    Conflicts.remove(t, this, nAct.initialOption, act.key.o);
                    continue;
                }
                LatticeNode.removeActivationAndPropagate(t, true, nAct, nAct.key.pos.intersection(removedRange));
                for (int[] seg : nAct.key.pos.intersection(removedRange).getSegments()) {
                    Range r = Range.create(t.doc, seg);
                    Option nio = nAct.initialOption.clonePrimitive(t);
                    Conflicts.remove(t, this, nio, act.key.o);
                    LatticeNode.addActivationAndPropagate(t, true, new Activation.Key(n, r, act.key.rid, nAct.key.o, nAct.key.fired), r, nio, nAct.inputs, nAct.directInputs);
                }
            }
        }
    }

    @Override
    public int getSign() {
        return -1;
    }

    @Override
    public void cleanup(Model m) {
    }

    @Override
    public void remove(Model m) {
        this.inputNeuron.outputNodes.remove(new Input.InputKey(1, this.rid));
        super.remove(m);
    }
}

