/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.simple.lattice;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.aika.corpus.Option;
import org.aika.corpus.Range;
import org.aika.network.Iteration;
import org.aika.network.Model;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Node;
import org.aika.network.neuron.simple.lattice.AndNode;
import org.aika.network.neuron.simple.lattice.LatticeNode;
import org.aika.network.neuron.simple.lattice.LogicNode;

public class OrNode
extends LogicNode {
    public Map<LatticeNode, Double> parents = new TreeMap<LatticeNode, Double>();

    public OrNode(Model m, int level) {
        super(m, level);
    }

    @Override
    public boolean isNegative() {
        return false;
    }

    @Override
    public boolean isAllowedOption(Option n, Activation act, long v) {
        return false;
    }

    @Override
    public boolean containsNegative() {
        return false;
    }

    @Override
    public void initActivation(Iteration t, Activation act) {
    }

    @Override
    public void deleteActivation(Iteration t, Activation act) {
    }

    @Override
    public double computeForwardWeight(Activation act) {
        assert (!act.inputs.isEmpty());
        double maxForwardsWeight = act.computeAverageInputWeight();
        for (Activation shdAct : act.shadows.values()) {
            assert (!shdAct.inputs.isEmpty());
            maxForwardsWeight = Math.max(maxForwardsWeight, shdAct.computeAverageInputWeight());
        }
        return maxForwardsWeight;
    }

    @Override
    public double getNodeWeight(Activation act) {
        Double iw = this.parents.get(act.directInputs.first().key.n);
        return this.weight * (iw != null ? iw : 1.0);
    }

    public void addActivation(Iteration t, Activation.Key ak, Range addedRange, Activation inputAct) {
        OrNode.addActivationAndPropagate(t, true, ak, addedRange, null, inputAct.inputs, Collections.singleton(inputAct));
    }

    protected void removeActivation(Iteration t, Activation act, Range removedRange) {
        OrNode.removeActivationAndPropagate(t, true, act, removedRange);
    }

    @Override
    public double computeSynapseWeightSum(Neuron n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup(Model m) {
    }

    @Override
    public void expandToNextLevel(Iteration t, Activation act, Range addedRange, Option conflict, boolean train) {
        OrNode.processCandidate(t, this, act, addedRange, conflict, train);
    }

    public static void processCandidate(Iteration t, LatticeNode parentNode, Activation act, Range addedRange, Option conflict, boolean train) {
        Activation.Key ak = act.key;
        for (OrNode n : parentNode.orChildren) {
            n.addActivation(t, new Activation.Key(n, ak.pos, 0, act.newOption != null ? Option.add(t.doc, false, ak.o, act.newOption) : ak.o, ak.fired, parentNode.id), addedRange, act);
        }
    }

    @Override
    protected void collectNodeAndRefinements(AndNode.Refinement newRef, Set<AndNode.Refinement> inputs) {
        throw new UnsupportedOperationException();
    }

    public void addInput(LatticeNode inputNode) {
        inputNode.orChildren.add(this);
        this.parents.put(inputNode, 1.0);
    }

    public void setWeight(LatticeNode inputNode, double weight) {
        if (this.parents.containsKey(inputNode)) {
            this.parents.put(inputNode, weight);
        }
    }

    @Override
    public void remove(Model m) {
        super.remove(m);
        for (LatticeNode n : this.parents.keySet()) {
            n.orChildren.remove(this);
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        for (Node node : this.parents.keySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(node.logicToString());
            if (i > 10) {
                sb.append(",...");
                break;
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

