/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import network.aika.DistanceFunction;
import network.aika.Document;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Range;
import network.aika.neuron.relation.InstanceRelation;
import network.aika.neuron.relation.RangeRelation;
import network.aika.neuron.relation.Relation;

public class Synapse
implements Writable {
    public static final Comparator<Synapse> INPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.input.compareTo(s2.input);
        if (r != 0) {
            return r;
        }
        r = s1.key.compareTo(s2.key);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    public static final Comparator<Synapse> OUTPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.output.compareTo(s2.output);
        if (r != 0) {
            return r;
        }
        r = s1.key.compareTo(s2.key);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    public Neuron input;
    public Neuron output;
    public Integer id;
    public Key key;
    public Map<Integer, Relation> relations;
    public DistanceFunction distanceFunction = null;
    public Writable statistic;
    public boolean inactive;
    public double weight;
    public double weightDelta;
    public double bias;
    public double biasDelta;
    public boolean toBeDeleted;
    public boolean isConjunction;
    public int createdInDoc;
    public int committedInDoc;
    static Map<Key, Key> keyMap = new TreeMap<Key, Key>();

    public Synapse() {
        this.relations = new TreeMap<Integer, Relation>();
    }

    public Synapse(Neuron input, Neuron output, Integer id, Key key, Map<Integer, Relation> relations, DistanceFunction distanceFunction) {
        this.key = Synapse.lookupKey(key);
        this.relations = relations;
        this.id = id;
        this.input = input;
        this.output = output;
        this.distanceFunction = distanceFunction;
        if (output.model.synapseStatisticFactory != null) {
            this.statistic = output.model.synapseStatisticFactory.createObject();
        }
    }

    public void link() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        ((Neuron)in.provider).lock.acquireWriteLock();
        ((Neuron)in.provider).inMemoryOutputSynapses.put(this, this);
        ((Neuron)in.provider).lock.releaseWriteLock();
        ((Neuron)out.provider).lock.acquireWriteLock();
        this.reverseLinkRelations(out);
        ((Neuron)out.provider).inMemoryInputSynapses.put(this, this);
        ((Neuron)out.provider).inputSynapsesById.put(this.id, this);
        ((Neuron)out.provider).lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        if (this.isConjunction(true, false)) {
            out.inputSynapses.put(this, this);
            this.isConjunction = true;
            out.setModified();
        } else {
            in.outputSynapses.put(this, this);
            this.isConjunction = false;
            in.setModified();
        }
        ++out.numberOfInputSynapses;
        if (in.isPassiveInputNeuron()) {
            out.registerPassiveInputSynapse(this);
        }
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    private void reverseLinkRelations(INeuron out) {
        for (Map.Entry<Integer, Relation> me : this.relations.entrySet()) {
            int rId = me.getKey();
            Map<Integer, Relation> rel = null;
            if (rId >= 0) {
                Synapse rs = ((Neuron)out.provider).getSynapseById(rId);
                if (rs != null) {
                    rel = rs.relations;
                }
            } else {
                if (out.outputRelations == null) {
                    out.outputRelations = new TreeMap<Integer, Relation>();
                }
                rel = out.outputRelations;
            }
            if (rel == null) continue;
            rel.put(this.id, me.getValue().invert());
        }
    }

    public void relink() {
        boolean newIsConjunction = this.isConjunction(true, false);
        if (newIsConjunction != this.isConjunction) {
            INeuron in = (INeuron)this.input.get();
            INeuron out = (INeuron)this.output.get();
            boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
            (dir ? in : out).lock.acquireWriteLock();
            (dir ? out : in).lock.acquireWriteLock();
            if (newIsConjunction) {
                out.inputSynapses.put(this, this);
                this.isConjunction = true;
                out.setModified();
            } else {
                in.outputSynapses.put(this, this);
                this.isConjunction = false;
                in.setModified();
            }
            (dir ? in : out).lock.releaseWriteLock();
            (dir ? out : in).lock.releaseWriteLock();
        }
    }

    public void unlink() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        ((Neuron)in.provider).lock.acquireWriteLock();
        ((Neuron)in.provider).inMemoryOutputSynapses.remove(this);
        ((Neuron)in.provider).lock.releaseWriteLock();
        ((Neuron)out.provider).lock.acquireWriteLock();
        ((Neuron)out.provider).inMemoryInputSynapses.remove(this);
        ((Neuron)out.provider).inputSynapsesById.remove(this.id);
        ((Neuron)out.provider).lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    private void removeLinkInternal(INeuron in, INeuron out) {
        if (this.isConjunction(false, false)) {
            if (out.inputSynapses.remove(this) != null) {
                out.setModified();
                --out.numberOfInputSynapses;
            }
        } else if (in.outputSynapses.remove(this) != null) {
            in.setModified();
            --out.numberOfInputSynapses;
        }
    }

    public boolean exists() {
        if (((INeuron)this.input.get()).outputSynapses.containsKey(this)) {
            return true;
        }
        return ((INeuron)this.output.get()).inputSynapses.containsKey(this);
    }

    public boolean isConjunction(boolean v, boolean absolute) {
        INeuron out = (INeuron)this.output.get();
        return (v ? this.getNewWeight() : this.weight) + (absolute ? 0.0 : out.requiredSum) + (v ? out.getNewBiasSum() : out.biasSum) <= 0.0;
    }

    public void updateDelta(Document doc, double weightDelta, double biasDelta) {
        this.weightDelta += weightDelta;
        this.biasDelta += biasDelta;
        ((INeuron)this.output.get()).biasSumDelta += biasDelta;
        this.relink();
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public void update(Document doc, double weight, double bias) {
        this.weightDelta = weight - this.weight;
        double newBiasDelta = bias - this.bias;
        ((INeuron)this.output.get()).biasSumDelta += newBiasDelta - this.biasDelta;
        this.biasDelta = newBiasDelta;
        this.relink();
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public boolean isNegative() {
        return this.weight < 0.0;
    }

    public String toString() {
        return "S OW:" + this.weight + " NW:" + (this.weight + this.weightDelta) + " rec:" + this.key.isRecurrent + " o:" + this.key.rangeOutput + " " + this.input + "->" + this.output;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        this.key.write(out);
        out.writeInt(this.input.id);
        out.writeInt(this.output.id);
        out.writeInt(this.relations.size());
        for (Map.Entry<Integer, Relation> me : this.relations.entrySet()) {
            out.writeInt(me.getKey());
            me.getValue().write(out);
        }
        out.writeBoolean(this.distanceFunction != null);
        if (this.distanceFunction != null) {
            out.writeUTF(this.distanceFunction.name());
        }
        out.writeDouble(this.weight);
        out.writeDouble(this.bias);
        out.writeBoolean(this.isConjunction);
        out.writeBoolean(this.statistic != null);
        if (this.statistic != null) {
            this.statistic.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.id = in.readInt();
        this.key = Key.read(in, m);
        this.input = m.lookupNeuron(in.readInt());
        this.output = m.lookupNeuron(in.readInt());
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            int synId = in.readInt();
            Relation r = Relation.read(in, m);
            this.relations.put(synId, r);
        }
        if (in.readBoolean()) {
            this.distanceFunction = DistanceFunction.valueOf(in.readUTF());
        }
        this.weight = in.readDouble();
        this.bias = in.readDouble();
        this.isConjunction = in.readBoolean();
        if (in.readBoolean()) {
            this.statistic = m.synapseStatisticFactory.createObject();
            this.statistic.readFields(in, m);
        }
    }

    public static Synapse read(DataInput in, Model m) throws IOException {
        Synapse s = new Synapse();
        s.readFields(in, m);
        return s;
    }

    public static Synapse createOrLookup(Document doc, Integer synapseId, Key k, Map<Integer, Relation> relations, DistanceFunction distFunc, Neuron inputNeuron, Neuron outputNeuron) {
        outputNeuron.get(doc);
        inputNeuron.get(doc);
        outputNeuron.lock.acquireWriteLock();
        Synapse synapse = null;
        if (synapseId != null) {
            synapse = (Synapse)outputNeuron.inputSynapsesById.get(synapseId);
        } else {
            Map.Entry<Synapse, Synapse> me = outputNeuron.inMemoryInputSynapses.subMap(new Synapse(inputNeuron, outputNeuron, Integer.MIN_VALUE, k, null, null), true, new Synapse(inputNeuron, outputNeuron, Integer.MAX_VALUE, k, null, null), true).firstEntry();
            if (me != null) {
                synapse = me.getKey();
            }
        }
        outputNeuron.lock.releaseWriteLock();
        if (synapse == null) {
            synapse = new Synapse(inputNeuron, outputNeuron, synapseId, k, relations, distFunc);
            if (synapseId == null) {
                synapse.id = ((INeuron)outputNeuron.get((Document)doc)).numberOfInputSynapses;
            }
            synapse.link();
            if (doc != null) {
                synapse.createdInDoc = doc.id;
            }
        }
        return synapse;
    }

    public double getNewWeight() {
        return this.weight + this.weightDelta;
    }

    public double getNewBias() {
        return this.bias + this.biasDelta;
    }

    public static Key lookupKey(Key k) {
        Key rk = keyMap.get(k);
        if (rk == null) {
            keyMap.put(k, k);
            rk = k;
        }
        return rk;
    }

    public static class Key
    implements Comparable<Key>,
    Writable {
        public boolean isRecurrent;
        public int rangeInput;
        public Range.Output rangeOutput;
        public boolean identity;

        private Key() {
        }

        public Key(boolean isRecurrent, int rangeInput, Range.Output rangeOutput, boolean identity) {
            this.isRecurrent = isRecurrent;
            this.rangeInput = rangeInput;
            this.rangeOutput = rangeOutput;
            this.identity = identity;
        }

        @Override
        public int compareTo(Key k) {
            int r = Boolean.compare(this.isRecurrent, k.isRecurrent);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.rangeInput, k.rangeInput);
            if (r != 0) {
                return r;
            }
            r = this.rangeOutput.compareTo(k.rangeOutput);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.identity, k.identity);
            return r;
        }

        public static Key read(DataInput in, Model m) throws IOException {
            Key k = new Key();
            k.readFields(in, m);
            return k;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.isRecurrent);
            out.writeInt(this.rangeInput);
            this.rangeOutput.write(out);
            out.writeBoolean(this.identity);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.isRecurrent = in.readBoolean();
            this.rangeInput = in.readInt();
            this.rangeOutput = Range.Output.read(in, m);
            this.identity = in.readBoolean();
        }
    }

    public static class Builder
    implements Comparable<Builder> {
        public static final int OUTPUT = -1;
        public boolean recurrent;
        public Neuron neuron;
        public double weight;
        public double bias;
        public DistanceFunction distanceFunction;
        public int rangeInput = -1;
        public Range.Output rangeOutput = Range.Output.NONE;
        public boolean identity;
        public Integer synapseId;
        public Map<Integer, Relation> relations = new TreeMap<Integer, Relation>();

        public Builder setRecurrent(boolean recurrent) {
            this.recurrent = recurrent;
            return this;
        }

        public Builder setNeuron(Neuron neuron) {
            assert (neuron != null);
            this.neuron = neuron;
            return this;
        }

        public Builder setWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder setBias(double bias) {
            this.bias = bias;
            return this;
        }

        public Builder setDistanceFunction(DistanceFunction distFunc) {
            this.distanceFunction = distFunc;
            return this;
        }

        public Builder setRangeInput(int synapseId) {
            this.rangeInput = synapseId;
            return this;
        }

        public Builder setRangeOutput(boolean ro) {
            this.rangeOutput = ro ? Range.Output.DIRECT : Range.Output.NONE;
            return this;
        }

        public Builder setRangeOutput(boolean begin, boolean end) {
            return this.setRangeOutput(begin ? Range.Mapping.BEGIN : Range.Mapping.NONE, end ? Range.Mapping.END : Range.Mapping.NONE);
        }

        public Builder setIdentity(boolean identity) {
            this.identity = identity;
            return this;
        }

        public Builder setRangeOutput(Range.Output rangeOutput) {
            this.rangeOutput = rangeOutput;
            return this;
        }

        public Builder setRangeOutput(Range.Mapping begin, Range.Mapping end) {
            this.rangeOutput = Range.Output.create(begin, end);
            return this;
        }

        public Builder setSynapseId(int synapseId) {
            assert (synapseId >= 0);
            this.synapseId = synapseId;
            return this;
        }

        public Builder addRelations(Map<Integer, Relation> relations) {
            this.relations.putAll(relations);
            return this;
        }

        public Builder addInstanceRelation(InstanceRelation.Type type, int synapseId) {
            assert (synapseId >= -1);
            this.relations.put(synapseId, new InstanceRelation(type));
            return this;
        }

        public Builder addRangeRelation(Range.Relation relation, int synapseId) {
            assert (synapseId >= -1);
            this.relations.put(synapseId, new RangeRelation(relation));
            return this;
        }

        public Synapse getSynapse(Neuron outputNeuron) {
            return Synapse.createOrLookup(null, this.synapseId, new Key(this.recurrent, this.rangeInput, this.rangeOutput, this.identity), this.relations, this.distanceFunction, this.neuron, outputNeuron);
        }

        @Override
        public int compareTo(Builder in) {
            return Integer.compare(this.synapseId, in.synapseId);
        }
    }
}

