/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayDeque;
import java.util.Map;
import network.aika.Document;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.relation.Relation;

public class Linker {
    Document doc;
    ArrayDeque<Activation.Link> queue = new ArrayDeque();

    public Linker(Document doc) {
        this.doc = doc;
    }

    public void link(Activation act, OrNode.Link ol) {
        this.linkOrNodeRelations(act, ol);
        this.process();
    }

    private void linkOrNodeRelations(Activation act, OrNode.Link ol) {
        for (int i = 0; i < ol.oe.synapseIds.length; ++i) {
            int synId = ol.oe.synapseIds[i];
            Synapse s = ((OrNode)act.node).neuron.getSynapseById(synId);
            Activation iAct = ol.input.getInputActivation(i);
            this.link(s, iAct, act);
        }
    }

    private void linkOutputRelations(Activation act) {
        INeuron n = act.getINeuron();
        if (n.outputRelations != null) {
            for (Map.Entry<Integer, Relation> me : n.outputRelations.entrySet()) {
                Synapse s = ((OrNode)act.node).neuron.getSynapseById(me.getKey());
                this.link(act, act, s, me.getValue());
            }
        }
    }

    public void lateLinking() {
        int oldSize;
        do {
            oldSize = this.doc.activationsByRangeBegin.size();
            for (Activation act : this.doc.activationsByRangeBegin.values()) {
                this.linkOutputRelations(act);
                for (Activation.Link l : act.neuronInputs.values()) {
                    this.queue.add(l);
                }
            }
            this.doc.linker.process();
        } while (oldSize != this.doc.activationsByRangeBegin.size());
    }

    public void process() {
        while (!this.queue.isEmpty()) {
            Activation.Link l = this.queue.pollFirst();
            for (Map.Entry<Integer, Relation> me : l.synapse.relations.entrySet()) {
                Synapse s;
                int relId = me.getKey();
                if (relId < 0 || (s = l.output.getNeuron().getSynapseById(relId)) == null || s.key.identity) continue;
                Relation r = me.getValue();
                this.link(l.input, l.output, s, r);
            }
            this.doc.propagate();
        }
    }

    private void link(Activation rAct, Activation oAct, Synapse s, Relation r) {
        if (!r.isExact()) {
            INeuron.ThreadState ts = ((INeuron)s.input.get()).getThreadState(this.doc.threadId, true);
            for (Activation iAct : ts.activations.values()) {
                if (!r.test(rAct, iAct)) continue;
                this.link(s, iAct, oAct);
            }
        } else {
            for (Activation iAct : r.invert().getActivations((INeuron)s.input.get(rAct.doc), rAct)) {
                this.link(s, iAct, oAct);
            }
        }
    }

    private void link(Synapse s, Activation iAct, Activation oAct) {
        Integer outputBegin = null;
        Integer outputEnd = null;
        if (s.key.rangeInput == -1) {
            outputBegin = s.key.rangeOutput.begin.map(iAct.range);
            outputEnd = s.key.rangeOutput.end.map(iAct.range);
        } else {
            for (Activation.Link l : iAct.neuronInputs.values()) {
                if (l.synapse.id != s.key.rangeInput) continue;
                outputBegin = l.input.range.begin;
                outputEnd = l.input.range.end;
            }
        }
        if (outputBegin != null && outputBegin.intValue() != oAct.range.begin.intValue() || outputEnd != null && outputEnd.intValue() != oAct.range.end.intValue()) {
            return;
        }
        Activation.Link l = new Activation.Link(s, iAct, oAct);
        Activation.Link el = oAct.neuronInputs.get(l);
        if (el != null) {
            return;
        }
        iAct.addSynapseActivation(Direction.INPUT, l);
        oAct.addSynapseActivation(Direction.OUTPUT, l);
        this.queue.add(l);
        this.doc.ubQueue.add(l.output);
    }

    public static enum Direction {
        INPUT,
        OUTPUT;

    }
}

