/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import network.aika.AbstractNode;
import network.aika.ActivationFunction;
import network.aika.Document;
import network.aika.Model;
import network.aika.PassiveInputFunction;
import network.aika.Provider;
import network.aika.ReadWriteLock;
import network.aika.Utils;
import network.aika.Writable;
import network.aika.lattice.InputNode;
import network.aika.lattice.OrNode;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.SearchNode;
import network.aika.neuron.range.Position;
import network.aika.neuron.range.Range;
import network.aika.neuron.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INeuron
extends AbstractNode<Neuron, Activation>
implements Comparable<INeuron> {
    public static boolean ALLOW_WEAK_NEGATIVE_WEIGHTS = false;
    private static final Logger log = LoggerFactory.getLogger(INeuron.class);
    public static double WEIGHT_TOLERANCE = 0.001;
    public static double TOLERANCE = 1.0E-6;
    public String label;
    public Type type;
    public String outputText;
    public volatile double bias;
    public volatile double biasDelta;
    public volatile double biasSum;
    public volatile double biasSumDelta;
    public volatile double posDirSum;
    public volatile double negDirSum;
    public volatile double negRecSum;
    public volatile double posRecSum;
    public volatile double posPassiveSum;
    public volatile double requiredSum;
    public volatile int numDisjunctiveSynapses = 0;
    public boolean createBeginPosition = true;
    public boolean createEndPosition = true;
    public Writable extension;
    public ActivationFunction activationFunction = ActivationFunction.RECTIFIED_SCALED_LOGISTIC_SIGMOID;
    public int synapseIdCounter = 0;
    public Map<Integer, Set<Relation>> outputRelations;
    public TreeMap<Synapse, Synapse> inputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
    public TreeMap<Synapse, Synapse> outputSynapses = new TreeMap(Synapse.OUTPUT_SYNAPSE_COMP);
    public TreeMap<Synapse, Synapse> passiveInputSynapses = null;
    public Provider<InputNode> outputNode;
    public Provider<OrNode> node;
    public ReadWriteLock lock = new ReadWriteLock();
    public PassiveInputFunction passiveInputFunction = null;
    public ThreadState[] threads;
    public static final Comparator<ActKey> BEGIN_COMP = (ak1, ak2) -> {
        int r = Range.BEGIN_COMP.compare(ak1.r, ak2.r);
        if (r != 0) {
            return r;
        }
        return Integer.compare(ak1.actId, ak2.actId);
    };
    public static final Comparator<ActKey> END_COMP = (ak1, ak2) -> {
        int r = Range.END_COMP.compare(ak1.r, ak2.r);
        if (r != 0) {
            return r;
        }
        return Integer.compare(ak1.actId, ak2.actId);
    };

    public ThreadState getThreadState(int threadId, boolean create) {
        ThreadState th = this.threads[threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[threadId] = th = new ThreadState();
        }
        th.lastUsed = ((Neuron)this.provider).model.docIdCounter.get();
        return th;
    }

    private INeuron() {
    }

    public INeuron(Model m) {
        this(m, null);
    }

    public INeuron(Model m, String label) {
        this(m, label, null);
    }

    public INeuron(Model m, String label, String outputText) {
        this.label = label;
        this.outputText = outputText;
        if (m.getNeuronExtensionFactory() != null) {
            this.extension = m.getNeuronExtensionFactory().createObject();
        }
        this.threads = new ThreadState[m.numberOfThreads];
        this.provider = new Neuron(m, this);
        OrNode node = new OrNode(m);
        node.neuron = (Neuron)this.provider;
        this.node = node.provider;
        this.setModified();
    }

    public Activation addInput(Document doc, Activation.Builder input) {
        Range r = new Range(doc, input.begin, input.end);
        Activation act = this.getThreadState(doc.threadId, true).getActivationByRange(r);
        if (act == null) {
            act = new Activation(doc.activationIdCounter++, doc, this.node.get(doc));
            act.range = r;
        }
        this.register(act);
        Activation.State s = new Activation.State(input.value, input.value, 1.0, 0.0, 0.0, input.fired, 0.0);
        act.rounds.set(0, s);
        act.avgState = s;
        act.inputValue = input.value;
        act.upperBound = input.value;
        act.lowerBound = input.value;
        act.finalDecision = act.inputDecision = SearchNode.Decision.SELECTED;
        act.setDecision(act.inputDecision, doc.visitedCounter++);
        act.setTargetValue(input.targetValue);
        doc.inputNeuronActivations.add(act);
        doc.finallyActivatedNeurons.add(act.getINeuron());
        doc.linker.linkInput(act);
        this.propagate(act);
        doc.propagate();
        return act;
    }

    public void remove() {
        this.clearActivations();
        for (Synapse s : this.inputSynapses.values()) {
            INeuron in = (INeuron)s.input.get();
            ((Neuron)in.provider).lock.acquireWriteLock();
            ((Neuron)in.provider).inMemoryOutputSynapses.remove(s);
            ((Neuron)in.provider).lock.releaseWriteLock();
        }
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            INeuron out = (INeuron)s.output.get();
            out.lock.acquireWriteLock();
            out.inputSynapses.remove(s);
            out.lock.releaseWriteLock();
        }
        ((Neuron)this.provider).lock.releaseReadLock();
    }

    public int getNewSynapseId() {
        return this.synapseIdCounter++;
    }

    public void registerSynapseId(Integer synId) {
        if (synId >= this.synapseIdCounter) {
            this.synapseIdCounter = synId + 1;
        }
    }

    @Override
    public void propagate(Activation act) {
        Document doc = act.doc;
        this.outputNode.get(doc).addActivation(act);
    }

    public Collection<Activation> getActivations(Document doc, boolean onlyFinal) {
        ThreadState th = this.getThreadState(doc.threadId, false);
        if (th == null) {
            return Collections.EMPTY_LIST;
        }
        return th.getActivations(onlyFinal);
    }

    public Activation getActivation(Document doc, Range r, boolean onlyFinal) {
        block4: {
            ThreadState th;
            block3: {
                th = this.getThreadState(doc.threadId, false);
                if (th == null) {
                    return null;
                }
                if (r.begin == null) break block3;
                for (Activation act : th.getActivationsByRangeBegin(r.begin, true, r.begin, false)) {
                    if (onlyFinal && !act.isFinalActivation() || !r.equalsIgnoreNull(act.range)) continue;
                    return act;
                }
                break block4;
            }
            if (r.end == null) break block4;
            for (Activation act : th.getActivationsByRangeEnd(r.end, true, r.end, false)) {
                if (onlyFinal && (!act.isFinalActivation() || !r.equalsIgnoreNull(act.range))) continue;
                return act;
            }
        }
        return null;
    }

    public void clearActivations() {
        for (int i = 0; i < ((Neuron)this.provider).model.numberOfThreads; ++i) {
            this.clearActivations(i);
        }
    }

    public void clearActivations(Document doc) {
        this.clearActivations(doc.threadId);
    }

    public void clearActivations(int threadId) {
        ThreadState th = this.getThreadState(threadId, false);
        if (th == null) {
            return;
        }
        th.clearActivations();
    }

    @Override
    public int compareTo(INeuron n) {
        if (((Neuron)this.provider).id < ((Neuron)n.provider).id) {
            return -1;
        }
        if (((Neuron)this.provider).id > ((Neuron)n.provider).id) {
            return 1;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(true);
        out.writeBoolean(this.label != null);
        if (this.label != null) {
            out.writeUTF(this.label);
        }
        out.writeBoolean(this.type != null);
        if (this.type != null) {
            out.writeUTF(this.type.name());
        }
        out.writeBoolean(this.outputText != null);
        if (this.outputText != null) {
            out.writeUTF(this.outputText);
        }
        out.writeBoolean(this.extension != null);
        if (this.extension != null) {
            this.extension.write(out);
        }
        out.writeDouble(this.bias);
        out.writeDouble(this.biasSum);
        out.writeDouble(this.posDirSum);
        out.writeDouble(this.negDirSum);
        out.writeDouble(this.negRecSum);
        out.writeDouble(this.posRecSum);
        out.writeDouble(this.posPassiveSum);
        out.writeDouble(this.requiredSum);
        out.writeInt(this.numDisjunctiveSynapses);
        out.writeUTF(this.activationFunction.name());
        out.writeBoolean(this.createBeginPosition);
        out.writeBoolean(this.createEndPosition);
        out.writeInt(this.outputNode.id);
        out.writeBoolean(this.node != null);
        if (this.node != null) {
            out.writeInt(this.node.id);
        }
        out.writeInt(this.synapseIdCounter);
        for (Synapse synapse : this.inputSynapses.values()) {
            if (synapse.input == null) continue;
            out.writeBoolean(true);
            synapse.write(out);
            out.writeBoolean(this.passiveInputSynapses != null && this.passiveInputSynapses.containsKey(synapse));
        }
        out.writeBoolean(false);
        for (Synapse synapse : this.outputSynapses.values()) {
            if (synapse.output == null) continue;
            out.writeBoolean(true);
            synapse.write(out);
        }
        out.writeBoolean(false);
        if (this.outputRelations != null) {
            out.writeInt(this.outputRelations.size());
            for (Map.Entry entry : this.outputRelations.entrySet()) {
                out.writeInt((Integer)entry.getKey());
                out.writeInt(((Set)entry.getValue()).size());
                for (Relation rel : (Set)entry.getValue()) {
                    rel.write(out);
                }
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        Synapse syn;
        if (in.readBoolean()) {
            this.label = in.readUTF();
        }
        if (in.readBoolean()) {
            this.type = Type.valueOf(in.readUTF());
        }
        if (in.readBoolean()) {
            this.outputText = in.readUTF();
        }
        if (in.readBoolean()) {
            this.extension = m.getNeuronExtensionFactory().createObject();
            this.extension.readFields(in, m);
        }
        this.bias = in.readDouble();
        this.biasSum = in.readDouble();
        this.posDirSum = in.readDouble();
        this.negDirSum = in.readDouble();
        this.negRecSum = in.readDouble();
        this.posRecSum = in.readDouble();
        this.posPassiveSum = in.readDouble();
        this.requiredSum = in.readDouble();
        this.numDisjunctiveSynapses = in.readInt();
        this.activationFunction = ActivationFunction.valueOf(in.readUTF());
        this.createBeginPosition = in.readBoolean();
        this.createEndPosition = in.readBoolean();
        this.outputNode = m.lookupNodeProvider(in.readInt());
        if (in.readBoolean()) {
            Integer nId = in.readInt();
            this.node = m.lookupNodeProvider(nId);
        }
        this.synapseIdCounter = in.readInt();
        while (in.readBoolean()) {
            syn = Synapse.read(in, m);
            this.inputSynapses.put(syn, syn);
            if (!in.readBoolean()) continue;
            this.registerPassiveInputSynapse(syn);
        }
        while (in.readBoolean()) {
            syn = Synapse.read(in, m);
            this.outputSynapses.put(syn, syn);
        }
        int l = in.readInt();
        if (l > 0) {
            this.outputRelations = new TreeMap<Integer, Set<Relation>>();
            for (int i = 0; i < l; ++i) {
                Integer relId = in.readInt();
                TreeSet<Relation> relSet = new TreeSet<Relation>(Relation.COMPARATOR);
                int s = in.readInt();
                for (int j = 0; j < s; ++j) {
                    Relation r = Relation.read(in, m);
                    relSet.add(r);
                }
                this.outputRelations.put(relId, relSet);
            }
        }
        this.passiveInputFunction = m.passiveActivationFunctions.get(((Neuron)this.provider).id);
    }

    @Override
    public void suspend() {
        for (Synapse s : this.inputSynapses.values()) {
            s.input.removeInMemoryOutputSynapse(s);
        }
        for (Synapse s : this.outputSynapses.values()) {
            s.output.removeInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryInputSynapses.values()) {
            if (s.isConjunction) continue;
            s.input.removeInMemoryOutputSynapse(s);
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            if (!s.isConjunction) continue;
            s.output.removeInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.releaseReadLock();
    }

    @Override
    public void reactivate() {
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryInputSynapses.values()) {
            if (s.isConjunction) continue;
            s.input.addInMemoryOutputSynapse(s);
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            if (!s.isConjunction) continue;
            s.output.addInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.releaseReadLock();
        for (Synapse s : this.inputSynapses.values()) {
            s.input.addInMemoryOutputSynapse(s);
            if (s.input.isSuspended()) continue;
            s.output.addInMemoryInputSynapse(s);
        }
        for (Synapse s : this.outputSynapses.values()) {
            s.output.addInMemoryInputSynapse(s);
            if (s.output.isSuspended()) continue;
            s.input.addInMemoryOutputSynapse(s);
        }
    }

    public void setBias(double b) {
        double newBiasDelta = b - this.bias;
        this.biasSumDelta += newBiasDelta - this.biasDelta;
        this.biasDelta = newBiasDelta;
    }

    public void changeBias(double bd) {
        this.biasDelta += bd;
        this.biasSumDelta += bd;
    }

    public double getNewBiasSum() {
        return this.biasSum + this.biasSumDelta;
    }

    public void register(Activation act) {
        Integer l;
        Document doc = act.doc;
        ThreadState th = ((INeuron)((OrNode)act.node).neuron.get()).getThreadState(doc.threadId, true);
        if (th.isEmpty()) {
            doc.activatedNeurons.add((INeuron)((OrNode)act.node).neuron.get());
        }
        if ((l = act.range.length()) != null) {
            th.minLength = Math.min(th.minLength, act.range.length());
            th.maxLength = Math.max(th.maxLength, act.range.length());
        }
        th.addActivation(act);
        act.range.begin.addBeginActivation(act);
        act.range.end.addEndActivations(act);
        doc.addActivation(act);
    }

    public static INeuron readNeuron(DataInput in, Neuron p) throws IOException {
        INeuron n = new INeuron();
        n.provider = p;
        n.threads = new ThreadState[p.model.numberOfThreads];
        n.readFields(in, p.model);
        return n;
    }

    public boolean isPassiveInputNeuron() {
        return this.passiveInputFunction != null;
    }

    public void registerPassiveInputSynapse(Synapse s) {
        if (this.passiveInputSynapses == null) {
            this.passiveInputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
        }
        this.passiveInputSynapses.put(s, s);
    }

    public String toString() {
        return this.label;
    }

    public String toStringWithSynapses() {
        TreeSet<Synapse> is = new TreeSet<Synapse>((s1, s2) -> {
            int r = Double.compare(s2.weight, s1.weight);
            if (r != 0) {
                return r;
            }
            return Integer.compare(s1.input.id, s2.input.id);
        });
        is.addAll(this.inputSynapses.values());
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("<");
        sb.append("B:");
        sb.append(Utils.round(this.biasSum));
        for (Synapse s : is) {
            sb.append(", ");
            sb.append(Utils.round(s.weight));
            sb.append(":");
            sb.append(s.input.toString());
        }
        sb.append(">");
        return sb.toString();
    }

    public static class ActKey {
        Range r;
        int actId;

        public ActKey(Range r, int actId) {
            this.r = r;
            this.actId = actId;
        }
    }

    public static class ThreadState {
        public long lastUsed;
        private TreeMap<ActKey, Activation> activations;
        private TreeMap<ActKey, Activation> activationsEnd;
        public int minLength = Integer.MAX_VALUE;
        public int maxLength = 0;

        public ThreadState() {
            this.activations = new TreeMap(BEGIN_COMP);
            this.activationsEnd = new TreeMap(END_COMP);
        }

        public void addActivation(Activation act) {
            ActKey ak = new ActKey(act.range, act.id);
            this.activations.put(ak, act);
            TreeMap<ActKey, Activation> actEnd = this.activationsEnd;
            if (actEnd != null) {
                actEnd.put(ak, act);
            }
        }

        public Collection<Activation> getActivations() {
            return this.activations.values();
        }

        public boolean isEmpty() {
            return this.activations.isEmpty();
        }

        public int size() {
            return this.activations.size();
        }

        public void clearActivations() {
            this.activations.clear();
            if (this.activationsEnd != null) {
                this.activationsEnd.clear();
            }
        }

        public Collection<Activation> getActivationsByRangeBeginLimited(Position fromKey, boolean fromInclusive, Position toKey, boolean toInclusive) {
            if (fromKey.getFinalPosition() != null && toKey.getFinalPosition() != null) {
                if (fromKey != Position.MIN) {
                    fromKey = new Position(fromKey.doc, fromKey.getFinalPosition() - this.maxLength);
                }
                if (fromKey.compare(Position.Operator.GREATER_THAN, toKey)) {
                    return Collections.EMPTY_LIST;
                }
                return this.getActivationsByRangeBegin(fromKey, fromInclusive, toKey, toInclusive);
            }
            return Collections.EMPTY_LIST;
        }

        public Collection<Activation> getActivationsByRangeEndLimited(Position fromKey, boolean fromInclusive, Position toKey, boolean toInclusive) {
            if (fromKey.getFinalPosition() != null && toKey.getFinalPosition() != null) {
                if (fromKey != Position.MIN) {
                    fromKey = new Position(fromKey.doc, fromKey.getFinalPosition() - this.maxLength);
                }
                if (fromKey.compare(Position.Operator.GREATER_THAN, toKey)) {
                    return Collections.EMPTY_LIST;
                }
                return this.getActivationsByRangeEnd(fromKey, fromInclusive, toKey, toInclusive);
            }
            return Collections.EMPTY_LIST;
        }

        public Collection<Activation> getActivationsByRangeBegin(Position fromKey, boolean fromInclusive, Position toKey, boolean toInclusive) {
            return this.activations.subMap(new ActKey(new Range(fromKey, Position.MIN), Integer.MIN_VALUE), fromInclusive, new ActKey(new Range(toKey, Position.MAX), Integer.MAX_VALUE), toInclusive).values();
        }

        public Collection<Activation> getActivationsByRangeEnd(Position fromKey, boolean fromInclusive, Position toKey, boolean toInclusive) {
            return this.activationsEnd.subMap(new ActKey(new Range(Position.MIN, fromKey), Integer.MIN_VALUE), fromInclusive, new ActKey(new Range(Position.MAX, toKey), Integer.MAX_VALUE), toInclusive).values();
        }

        public Activation getActivationByRange(Range r) {
            Map.Entry<ActKey, Activation> me = this.activations.higherEntry(new ActKey(r, Integer.MIN_VALUE));
            if (me != null && me.getValue().range.equals(r)) {
                return me.getValue();
            }
            return null;
        }

        public Collection<Activation> getActivations(boolean onlyFinal) {
            return onlyFinal ? (Collection)this.activations.values().stream().filter(act -> act.isFinalActivation()).collect(Collectors.toList()) : this.getActivations();
        }
    }

    public static enum Type {
        EXCITATORY,
        INHIBITORY;

    }
}

